/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.connection;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.Rotate;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.utils.PathUtils;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.EdgeNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class EdgeSceneGraph
implements SceneGraph {
    private static final long serialVersionUID = 2914383071126238996L;
    public static final EdgeSceneGraph INSTANCE = new EdgeSceneGraph();
    public static final Stroke ARROW_STROKE = new BasicStroke(1.0f, 0, 0);
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(EdgeNode.class, "EDGE_SG_NODE");
    private static final Rectangle2D EMPTY = new Rectangle2D.Double();
    private final Collection<Topology.Connection> connectionsTemp = new ArrayList<Topology.Connection>();
    public static final Path2D NORMAL_ARROW;
    public static final Path2D FILLED_ARROW;

    static {
        FILLED_ARROW = new Path2D.Double();
        FILLED_ARROW.moveTo(-0.5, 1.0);
        FILLED_ARROW.lineTo(0.0, 0.0);
        FILLED_ARROW.lineTo(0.5, 1.0);
        FILLED_ARROW.closePath();
        NORMAL_ARROW = new Path2D.Double();
        NORMAL_ARROW.moveTo(-0.5, 1.0);
        NORMAL_ARROW.lineTo(0.0, 0.0);
        NORMAL_ARROW.lineTo(0.5, 1.0);
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        ElementUtils.getOrCreateNode(e, parent, KEY_SG_NODE, "edge_" + e.hashCode(), EdgeNode.class);
        this.update(e);
    }

    @Override
    public void cleanup(IElement e) {
        ElementUtils.removePossibleNode(e, KEY_SG_NODE);
    }

    public void update(IElement e) {
        Topology topology;
        EdgeNode node = (EdgeNode)e.getHint(KEY_SG_NODE);
        if (node == null) {
            return;
        }
        EdgeVisuals vh = e.getElementClass().getSingleItem(EdgeVisuals.class);
        EdgeVisuals.ArrowType at1 = vh.getArrowType(e, EdgeVisuals.EdgeEnd.Begin);
        EdgeVisuals.ArrowType at2 = vh.getArrowType(e, EdgeVisuals.EdgeEnd.End);
        Stroke stroke = vh.getStroke(e);
        double as1 = vh.getArrowSize(e, EdgeVisuals.EdgeEnd.Begin);
        double as2 = vh.getArrowSize(e, EdgeVisuals.EdgeEnd.End);
        Color c = ElementUtils.getFillColor(e, Color.BLACK);
        IDiagram diagram = ElementUtils.peekDiagram(e);
        if (diagram != null && (topology = diagram.getDiagramClass().getAtMostOneItemOfClass(Topology.class)) != null) {
            Topology.Connection beginConnection = topology.getConnection(e, EdgeVisuals.EdgeEnd.Begin);
            Topology.Connection endConnection = topology.getConnection(e, EdgeVisuals.EdgeEnd.End);
            EdgeSceneGraph.getTerminalShape(beginConnection);
            EdgeSceneGraph.getTerminalShape(endConnection);
            int beginBranchDegree = this.getBranchPointDegree(beginConnection, topology);
            int endBranchDegree = this.getBranchPointDegree(endConnection, topology);
            if (beginBranchDegree > 0 && beginBranchDegree < 3) {
                at1 = EdgeVisuals.ArrowType.None;
            }
            if (endBranchDegree > 0 && endBranchDegree < 3) {
                at2 = EdgeVisuals.ArrowType.None;
            }
        }
        BendsHandler bh = e.getElementClass().getSingleItem(BendsHandler.class);
        Path2D line = bh.getPath(e);
        boolean drawArrows = at1 != EdgeVisuals.ArrowType.None || at2 != EdgeVisuals.ArrowType.None;
        Point2D.Double first = new Point2D.Double();
        Point2D.Double dir1 = new Point2D.Double();
        Point2D.Double last = new Point2D.Double();
        Point2D.Double dir2 = new Point2D.Double();
        PathIterator pi = line.getPathIterator(null);
        if (drawArrows &= PathUtils.getPathArrows(pi, first, dir1, last, dir2)) {
            line = EdgeSceneGraph.trimLineToArrows(line, at1, as1, at2, as2);
        }
        EdgeNode.ArrowType pat1 = EdgeSceneGraph.convert(at1);
        EdgeNode.ArrowType pat2 = EdgeSceneGraph.convert(at2);
        node.init((Shape)new GeneralPath(line), stroke, c, (Point2D)dir1, (Point2D)dir2, (Point2D)first, (Point2D)last, as1, as2, pat1, pat2, null, null);
    }

    private static EdgeNode.ArrowType convert(EdgeVisuals.ArrowType at) {
        switch (at) {
            case None: {
                return EdgeNode.ArrowType.None;
            }
            case Stroke: {
                return EdgeNode.ArrowType.Stroke;
            }
            case Fill: {
                return EdgeNode.ArrowType.Fill;
            }
        }
        throw new IllegalArgumentException("unsupported arrow type: " + (Object)((Object)at));
    }

    private static Shape getTerminalShape(Topology.Connection connection) {
        TerminalLayout layout;
        if (connection != null && connection.node != null && connection.terminal != null && (layout = connection.node.getElementClass().getAtMostOneItemOfClass(TerminalLayout.class)) != null) {
            Shape shp = layout.getTerminalShape(connection.node, connection.terminal);
            Rotate rotate = connection.node.getElementClass().getAtMostOneItemOfClass(Rotate.class);
            if (rotate == null) {
                return shp;
            }
            double theta = rotate.getAngle(connection.node);
            return AffineTransform.getRotateInstance(theta).createTransformedShape(shp);
        }
        return null;
    }

    private int getBranchPointDegree(Topology.Connection connection, Topology topology) {
        if (connection != null && connection.node != null && connection.node.getElementClass().containsClass(BranchPoint.class)) {
            this.connectionsTemp.clear();
            topology.getConnections(connection.node, connection.terminal, this.connectionsTemp);
            int degree = this.connectionsTemp.size();
            this.connectionsTemp.clear();
            return degree;
        }
        return -1;
    }

    private static Path2D clipLineEnds(Path2D line, Shape beginTerminalShape, Shape endTerminalShape) {
        Rectangle2D eb;
        if (beginTerminalShape == null && endTerminalShape == null) {
            return line;
        }
        Rectangle2D bb = beginTerminalShape != null ? beginTerminalShape.getBounds2D() : EMPTY;
        Rectangle2D rectangle2D = eb = endTerminalShape != null ? endTerminalShape.getBounds2D() : EMPTY;
        if (bb != EMPTY && !bb.contains(0.0, 0.0)) {
            bb = EMPTY;
        }
        if (eb != EMPTY && !eb.contains(0.0, 0.0)) {
            eb = EMPTY;
        }
        if (bb.isEmpty() && eb.isEmpty()) {
            return line;
        }
        Path2D.Double result = new Path2D.Double();
        PathIterator pi = line.getPathIterator(null);
        Iterator<double[]> it = PathUtils.toLineIterator(pi);
        boolean first = true;
        while (it.hasNext()) {
            Point2D ep;
            double[] seg = it.next();
            int degree = PathUtils.getLineDegree(seg);
            if (first) {
                first = false;
                Point2D start = PathUtils.getLinePos(seg, 0.0);
                Point2D sp = EdgeSceneGraph.clipToRectangle(bb, PathUtils.getLinePos(seg, 1.0), start);
                if (sp != null) {
                    ((Path2D)result).moveTo(sp.getX(), sp.getY());
                } else {
                    ((Path2D)result).moveTo(start.getX(), start.getY());
                }
            }
            if (!it.hasNext() && (ep = EdgeSceneGraph.clipToRectangle(eb, PathUtils.getLinePos(seg, 0.0), PathUtils.getLinePos(seg, 1.0))) != null) {
                seg[degree * 2] = ep.getX();
                seg[degree * 2 + 1] = ep.getY();
            }
            if (degree == 1) {
                ((Path2D)result).lineTo(seg[2], seg[3]);
                continue;
            }
            if (degree == 2) {
                ((Path2D)result).quadTo(seg[2], seg[3], seg[4], seg[5]);
                continue;
            }
            if (degree == 3) {
                ((Path2D)result).curveTo(seg[2], seg[3], seg[4], seg[5], seg[6], seg[7]);
                continue;
            }
            throw new UnsupportedOperationException("invalid path segment degree: " + degree);
        }
        result.setWindingRule(line.getWindingRule());
        return result;
    }

    private static Path2D trimLineToArrows(Path2D line, EdgeVisuals.ArrowType beginArrowType, double beginArrowSize, EdgeVisuals.ArrowType endArrowType, double endArrowSize) {
        Path2D.Double result = new Path2D.Double();
        PathIterator pi = line.getPathIterator(null);
        Iterator<double[]> it = PathUtils.toLineIterator(pi);
        boolean first = true;
        while (it.hasNext()) {
            double scale;
            double len;
            Point2D t;
            double[] seg = it.next();
            int degree = PathUtils.getLineDegree(seg);
            if (first) {
                first = false;
                if (beginArrowType == EdgeVisuals.ArrowType.Fill) {
                    t = PathUtils.getLineTangent(seg, 0.0);
                    len = Math.sqrt(EdgeSceneGraph.lensq(t, null));
                    if (len > beginArrowSize) {
                        scale = beginArrowSize / len;
                        seg[0] = seg[0] + t.getX() * scale;
                        seg[1] = seg[1] + t.getY() * scale;
                    } else {
                        ((Path2D)result).moveTo(seg[degree * 2], seg[degree * 2 + 1]);
                        continue;
                    }
                }
                ((Path2D)result).moveTo(seg[0], seg[1]);
            }
            if (!it.hasNext() && endArrowType == EdgeVisuals.ArrowType.Fill && (len = Math.sqrt(EdgeSceneGraph.lensq(t = PathUtils.getLineTangent(seg, 1.0), null))) > endArrowSize) {
                scale = endArrowSize / len;
                int n = degree * 2;
                seg[n] = seg[n] - t.getX() * scale;
                int n2 = degree * 2 + 1;
                seg[n2] = seg[n2] - t.getY() * scale;
            }
            if (degree == 1) {
                ((Path2D)result).lineTo(seg[2], seg[3]);
                continue;
            }
            if (degree == 2) {
                ((Path2D)result).quadTo(seg[2], seg[3], seg[4], seg[5]);
                continue;
            }
            if (degree == 3) {
                ((Path2D)result).curveTo(seg[2], seg[3], seg[4], seg[5], seg[6], seg[7]);
                continue;
            }
            throw new UnsupportedOperationException("invalid path segment degree: " + degree);
        }
        result.setWindingRule(line.getWindingRule());
        return result;
    }

    private static Point2D clipToRectangle(Rectangle2D bounds, Point2D p1, Point2D p2) {
        if (bounds.isEmpty()) {
            return p2;
        }
        Line2D.Double line = new Line2D.Double(p1, p2);
        Point2D vi1 = EdgeSceneGraph.intersectWithHorizontalLine(line, bounds.getMinY() + p2.getY());
        Point2D vi2 = EdgeSceneGraph.intersectWithHorizontalLine(line, bounds.getMaxY() + p2.getY());
        Point2D hi1 = EdgeSceneGraph.intersectWithVerticalLine(line, bounds.getMinX() + p2.getX());
        Point2D hi2 = EdgeSceneGraph.intersectWithVerticalLine(line, bounds.getMaxX() + p2.getX());
        int i = 0;
        Point2D[] intersections = new Point2D[4];
        if (vi1 != null) {
            intersections[i++] = vi1;
        }
        if (vi2 != null) {
            intersections[i++] = vi2;
        }
        if (hi1 != null) {
            intersections[i++] = hi1;
        }
        if (hi2 != null) {
            intersections[i++] = hi2;
        }
        if (i == 0) {
            return p2;
        }
        if (i == 1) {
            return intersections[0];
        }
        double len = EdgeSceneGraph.lensq(p1, p2);
        Point2D nearestIntersection = null;
        double nearestLen = -1.0;
        int j = 0;
        while (j < i) {
            double l = EdgeSceneGraph.lensq(p1, intersections[j]);
            if (l <= len && l > nearestLen) {
                nearestIntersection = intersections[j];
                nearestLen = l;
            }
            ++j;
        }
        return nearestIntersection;
    }

    private static double lensq(Point2D p1, Point2D p2) {
        double dx = p1.getX();
        double dy = p1.getY();
        if (p2 != null) {
            dx = p2.getX() - dx;
            dy = p2.getY() - dy;
        }
        return dx * dx + dy * dy;
    }

    private static Point2D intersectWithHorizontalLine(Line2D l, double y) {
        double dx = l.getX2() - l.getX1();
        double dy = l.getY2() - l.getY1();
        if (Math.abs(dy) < 1.0E-5) {
            return null;
        }
        double a = dx / dy;
        return new Point2D.Double((y - l.getY1()) * a + l.getX1(), y);
    }

    private static Point2D intersectWithVerticalLine(Line2D l, double x) {
        double dx = l.getX2() - l.getX1();
        double dy = l.getY2() - l.getY1();
        if (Math.abs(dx) < 1.0E-5) {
            return null;
        }
        double a = dy / dx;
        return new Point2D.Double(x, a * (x - l.getX1()) + l.getY1());
    }
}

