/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.TooManyListenersException;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.dnd.DragPainter;
import org.simantics.g2d.dnd.IDragSourceParticipant;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.ui.ErrorLogger;

public class DragInteractor
extends AbstractCanvasParticipant
implements DragSourceListener {
    private final Component component;
    private IDragSourceParticipant dragParticipant;
    @DependencyReflection.Dependency
    MouseUtil mouseUtil;
    static DragSource DRAG_SOURCE = new DragSource();
    MyDragGestureRecognizer dgr;

    public DragInteractor(Component component) {
        this.component = component;
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.installDragSource();
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        DRAG_SOURCE.removeDragSourceListener(this);
        super.removedFromContext(ctx);
    }

    int getAllowedOps() {
        int result = 0;
        for (IDragSourceParticipant p : this.getDragParticipants()) {
            result |= p.getAllowedOps();
        }
        return result;
    }

    @EventHandlerReflection.EventHandler(priority=-1000)
    public boolean handleDrag(MouseEvent.MouseDragBegin me) {
        return this.dgr.handleDrag(me);
    }

    void installDragSource() {
        Integer actionMask = (Integer)this.getHint(Hints.KEY_ALLOWED_DRAG_ACTIONS);
        if (actionMask == null) {
            actionMask = 0x40000003;
        }
        this.dgr = new MyDragGestureRecognizer(DRAG_SOURCE, this.component, actionMask);
        try {
            this.dgr.addDragGestureListener(new DragGestureListener(){

                @Override
                public void dragGestureRecognized(DragGestureEvent e) {
                    try {
                        Transferable transferable = null;
                        IDragSourceParticipant activeParticipant = null;
                        for (IDragSourceParticipant p : DragInteractor.this.getDragParticipants()) {
                            transferable = p.dragStart(e);
                            if (transferable == null) continue;
                            activeParticipant = p;
                            break;
                        }
                        if (transferable == null) {
                            return;
                        }
                        DRAG_SOURCE.startDrag(e, null, transferable, DragInteractor.this);
                        DragInteractor.this.dragParticipant = activeParticipant;
                        MouseUtil.MouseInfo mi = DragInteractor.this.mouseUtil.getMouseInfo(0);
                        if (mi != null) {
                            long time = System.currentTimeMillis();
                            for (MouseUtil.ButtonInfo bi : mi.getButtonInfos()) {
                                if (!bi.down) continue;
                                MouseEvent.MouseButtonReleasedEvent mbre = new MouseEvent.MouseButtonReleasedEvent(null, time, mi.mouseId, mi.buttons, bi.stateMask, bi.button, time - bi.eventTime, mi.controlPosition, null);
                                DragInteractor.this.getContext().getEventQueue().queueEvent((Event)mbre);
                            }
                        }
                    }
                    catch (InvalidDnDOperationException idoe) {
                        ErrorLogger.defaultLogError((Throwable)idoe);
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        DRAG_SOURCE.addDragSourceListener(this);
    }

    protected Collection<IDragSourceParticipant> getDragParticipants() {
        return this.getContext().getItemsByClass(IDragSourceParticipant.class);
    }

    @Override
    public void dragEnter(final DragSourceDragEvent dsde) {
        if (this.dragParticipant == null) {
            return;
        }
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                if (DragInteractor.this.dragParticipant == null) {
                    return;
                }
                DragInteractor.this.dragParticipant.dragEnter(dsde);
            }
        });
    }

    @Override
    public void dragDropEnd(final DragSourceDropEvent dsde) {
        if (this.dragParticipant == null) {
            return;
        }
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                if (DragInteractor.this.dragParticipant == null) {
                    return;
                }
                DragInteractor.this.dragParticipant.dragDropEnd(dsde);
                DragInteractor.this.endDrag();
            }
        });
    }

    @Override
    public void dragExit(final DragSourceEvent dse) {
        if (this.dragParticipant == null) {
            return;
        }
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                if (DragInteractor.this.dragParticipant == null) {
                    return;
                }
                DragInteractor.this.dragParticipant.dragExit(dse);
                DragInteractor.this.endDrag();
            }
        });
    }

    @Override
    public void dragOver(final DragSourceDragEvent dsde) {
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                if (DragInteractor.this.dragParticipant == null) {
                    return;
                }
                DragInteractor.this.dragParticipant.dragOver(dsde);
            }
        });
    }

    public static Cursor getCursor(int action, int allowedOps) {
        boolean allowed;
        boolean bl = allowed = (action & allowedOps) != 0;
        if (action == 0x40000000) {
            return allowed ? DragSource.DefaultLinkDrop : DragSource.DefaultLinkNoDrop;
        }
        if (action == 1) {
            return allowed ? DragSource.DefaultCopyDrop : DragSource.DefaultCopyNoDrop;
        }
        if (action == 2) {
            return allowed ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop;
        }
        return DragSource.DefaultCopyNoDrop;
    }

    @Override
    public void dropActionChanged(final DragSourceDragEvent dsde) {
        if (this.dragParticipant == null) {
            return;
        }
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                if (DragInteractor.this.dragParticipant == null) {
                    return;
                }
                DragInteractor.this.dragParticipant.dropActionChanged(dsde);
            }
        });
    }

    public void endDrag() {
        Collection dragPainters = this.getContext().getItemsByClass(DragPainter.class);
        if (dragPainters.size() == 0) {
            return;
        }
        for (DragPainter dp : dragPainters) {
            dp.remove();
        }
        this.dragParticipant = null;
        this.getContext().getContentContext().setDirty();
    }

    class MyDragGestureRecognizer
    extends DragGestureRecognizer {
        private static final long serialVersionUID = 920532285869166322L;

        protected MyDragGestureRecognizer(DragSource ds, Component c, int actionMask) {
            super(ds, c, actionMask);
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }

        public boolean handleDrag(MouseEvent.MouseDragBegin me) {
            for (IDragSourceParticipant p : DragInteractor.this.getDragParticipants()) {
                int op = p.canDrag(me);
                if (op == 0) continue;
                int x = (int)me.controlPosition.getX();
                int y = (int)me.controlPosition.getY();
                MouseEvent awtie = new MouseEvent(this.component, 0, me.time, 0, x, y, 1, false);
                this.appendEvent(awtie);
                this.fireDragGestureRecognized(op, new Point(x, y));
                return true;
            }
            return false;
        }
    }
}

