/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.List;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class SubscriptionsQuery
extends ResourceRead<SubscriptionsResult> {
    public SubscriptionsQuery(Resource resource) {
        super(resource);
    }

    public SubscriptionsResult perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        SubscriptionsResult result = new SubscriptionsResult();
        result.init();
        for (Resource r : graph.getObjects(this.resource, L0.ConsistsOf)) {
            if (!graph.isInstanceOf(r, MOD.Subscription)) continue;
            String label = (String)graph.getPossibleRelatedValue(r, L0.HasLabel);
            result.resources.add(r);
            result.names.add(label == null ? "" : label);
        }
        return result;
    }

    public static class SubscriptionsResult
    extends Bean {
        public List<Resource> resources;
        public List<String> names;

        public String[] toNames() {
            return this.names.toArray(new String[this.names.size()]);
        }

        public String getName(Resource resource) {
            if (resource == null) {
                return null;
            }
            int i = 0;
            while (i < this.resources.size()) {
                if (resource.equals(this.resources.get(i))) {
                    return this.names.get(i);
                }
                ++i;
            }
            return null;
        }
    }
}

