/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.regexp;

import org.simantics.scl.compiler.parser.regexp.Namer;
import org.simantics.scl.compiler.parser.regexp.Regexp;
import org.simantics.scl.compiler.parser.regexp.automata.NFA;

public class ROp
extends Regexp {
    public final Regexp exp;
    public final char op;

    ROp(Regexp exp, char op) {
        this.exp = exp;
        this.op = op;
    }

    @Override
    public Regexp simplify() {
        Regexp exp = this.exp.simplify();
        if (exp instanceof ROp) {
            ROp other = (ROp)exp;
            if (other.op == this.op || other.op == '*') {
                return other;
            }
            return new ROp(other.exp, '*');
        }
        if (exp.isNullable()) {
            if (this.op == '?') {
                return exp;
            }
            if (this.op == '+') {
                return new ROp(exp, '*');
            }
        }
        if (exp == this.exp) {
            return this;
        }
        return new ROp(exp, this.op);
    }

    @Override
    protected void buildAutomaton(NFA aut, int inState, int outState) {
        switch (this.op) {
            case '?': {
                this.exp.buildAutomaton(aut, inState, outState);
                aut.addEpsilonTransition(inState, outState);
                break;
            }
            case '*': {
                int state = aut.newState();
                aut.addEpsilonTransition(inState, state);
                this.exp.buildAutomaton(aut, state, state);
                aut.addEpsilonTransition(state, outState);
                break;
            }
            case '+': {
                int state1 = aut.newState();
                int state2 = aut.newState();
                aut.addEpsilonTransition(inState, state1);
                this.exp.buildAutomaton(aut, state1, state2);
                aut.addEpsilonTransition(state2, state1);
                aut.addEpsilonTransition(state2, outState);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operation '" + this.op + "'.");
            }
        }
    }

    @Override
    protected void toString(StringBuilder b, int prec) {
        this.exp.toString(b, 3);
        b.append(this.op);
    }

    @Override
    public void toString(StringBuilder b, Namer grammar, int prec) {
        this.exp.toString(b, grammar, 3);
        b.append(this.op);
    }

    @Override
    protected int getTypeId() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ROp other = (ROp)obj;
        return this.op == other.op && this.exp.equals(other.exp);
    }

    public int hashCode() {
        return 31 * this.exp.hashCode() + this.op;
    }

    @Override
    public boolean isNullable() {
        return this.op != '+' || this.exp.isNullable();
    }
}

