/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ReflectionUtils {
    public static Class<?> getSingleParameterType(Class<?> clazz) {
        Type t = clazz.getGenericSuperclass();
        if (t instanceof Class) {
            throw new UnsupportedOperationException("Missing parameter type for input class '" + clazz.getCanonicalName() + "'");
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)t;
            Type argType = type.getActualTypeArguments()[0];
            if (argType instanceof Class) {
                return (Class)argType;
            }
            if (argType instanceof ParameterizedType) {
                ParameterizedType pargType = (ParameterizedType)argType;
                return (Class)pargType.getRawType();
            }
            throw new UnsupportedOperationException("Unsupported parameter type in class '" + clazz.getCanonicalName() + "': " + argType);
        }
        throw new UnsupportedOperationException("Unknown case in class '" + clazz.getCanonicalName() + "'");
    }

    public static <T> Class<T> getSingleParameterTypeExtending(Class<?> clazz) {
        Type t = clazz.getGenericSuperclass();
        while (t instanceof Class) {
            Class cl = (Class)t;
            if ((t = cl.getGenericSuperclass()) == null) break;
        }
        if (t instanceof Class) {
            throw new UnsupportedOperationException("Missing parameter type for input class '" + clazz.getCanonicalName() + "'");
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)t;
            Type argType = type.getActualTypeArguments()[0];
            if (argType instanceof Class) {
                return (Class)argType;
            }
            if (argType instanceof ParameterizedType) {
                ParameterizedType pargType = (ParameterizedType)argType;
                return (Class)pargType.getRawType();
            }
            throw new UnsupportedOperationException("Unsupported parameter type in class '" + clazz.getCanonicalName() + "': " + argType);
        }
        throw new UnsupportedOperationException("Unknown case in class '" + clazz.getCanonicalName() + "'");
    }
}

