/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.structure;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.ui.GraphvizComponent;
import org.simantics.sysdyn.ui.structure.ModuleStructureGraphRequest;
import org.simantics.utils.RunnableWithObject;
import org.simantics.utils.ui.ISelectionUtils;

public class ModuleStructure
extends CTabItem {
    private GraphvizComponent component;
    private GraphListener graphListener;

    public ModuleStructure(CTabFolder parent, int style) {
        super(parent, style);
        Composite moduleStructure = new Composite((Composite)parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)moduleStructure);
        GridLayoutFactory.fillDefaults().applyTo(moduleStructure);
        this.component = new GraphvizComponent(moduleStructure, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.component);
        this.setText("Model Hierarchy");
        this.setControl((Control)moduleStructure);
    }

    public void drawSelection(ISelection selection) {
        Object[] els;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (els = ((IStructuredSelection)selection).toArray()).length == 1) {
            Set ress = ISelectionUtils.filterSetSelection((Object)selection, Resource.class);
            if (ress.isEmpty()) {
                return;
            }
            Resource r = ress.toArray(Resource.NONE)[0];
            if (r != null) {
                if (this.graphListener != null) {
                    this.graphListener.dispose();
                }
                this.graphListener = new GraphListener();
                Simantics.getSession().asyncRequest((Read)new ModuleStructureGraphRequest(r), (Listener)this.graphListener);
            }
        }
    }

    private class GraphListener
    implements Listener<Graph> {
        private boolean disposed = false;

        private GraphListener() {
        }

        public void dispose() {
            this.disposed = true;
        }

        public void exception(Throwable e) {
            e.printStackTrace();
        }

        public void execute(final Graph graph) {
            Job job = new Job("Loading model structure graph"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!GraphListener.this.isDisposed()) {
                        ((GraphListener)GraphListener.this).ModuleStructure.this.component.getDisplay().asyncExec((Runnable)new RunnableWithObject(graph){

                            public void run() {
                                if (((GraphListener)(this).GraphListener.this).ModuleStructure.this.component.isDisposed()) {
                                    return;
                                }
                                ((GraphListener)(this).GraphListener.this).ModuleStructure.this.component.setGraph((Graph)this.getObject(), "dot");
                                ((GraphListener)(this).GraphListener.this).ModuleStructure.this.component.fit();
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

