/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Timer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.ui.properties.widgets.ExpressionTypes;
import org.simantics.sysdyn.ui.properties.widgets.expressions.AuxiliaryExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ConstantExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.DelayExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.EmptyExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionComposite;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.properties.widgets.expressions.IExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.LookupExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ParameterExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.StockExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.WithLookupExpression;
import org.simantics.sysdyn.ui.utils.ExpressionUtils;
import org.simantics.utils.ui.AdaptionUtils;

public class ExpressionWidget
implements Widget {
    private ExpressionWidgetInput input;
    private Resource expr;
    private Variable variable;
    private Composite parent;
    private Map<String, Object> data;
    private IExpression expression;
    private ModifyListener modifyListener;
    private FocusListener focusListener;
    private Table variableTable;
    private VerifyKeyListener verifyKeyListener;
    private Timer validationTimer;
    private static int VALIDATION_DELAY_TIME = 500;
    private final LocalResourceManager resourceManager;

    public ExpressionWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        this.parent = parent;
        if (parent instanceof ExpressionComposite) {
            ExpressionComposite expressionComposite = (ExpressionComposite)parent;
            expressionComposite.setExpressionWidget(this);
        }
        this.data = new HashMap<String, Object>();
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.parent);
        this.validationTimer = new Timer(VALIDATION_DELAY_TIME, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExpressionWidget.this.variableTable == null || ExpressionWidget.this.variableTable.isDisposed()) {
                    return;
                }
                ExpressionWidget.this.variableTable.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExpressionWidget.this.validateFields();
                    }
                });
            }
        });
        this.validationTimer.setRepeats(false);
    }

    public void setInput(ISessionContext context, Object input) {
        ExpressionWidgetInput i;
        this.input = i = (ExpressionWidgetInput)AdaptionUtils.adaptToSingle((Object)input, ExpressionWidgetInput.class);
        this.expr = i.expression;
        this.variable = i.variable;
        ExpressionTypes.ExpressionType et = ExpressionTypes.getExpressionType(this.expr);
        this.displayExpression(et.toString(), true);
    }

    public void displayExpression(String expressionType, boolean original) {
        if (expressionType == null || this.parent.isDisposed()) {
            return;
        }
        if (this.expression != null) {
            this.expression.updateData(this.data);
        }
        ExpressionTypes.ExpressionType et = ExpressionTypes.ExpressionType.valueOf(expressionType);
        IExpression exp = null;
        switch (et) {
            case Auxiliary: {
                exp = new AuxiliaryExpression(this.input);
                break;
            }
            case Parameter: {
                exp = new ParameterExpression(this.input);
                break;
            }
            case Constant: {
                exp = new ConstantExpression(this.input);
                break;
            }
            case Lookup: {
                exp = new LookupExpression();
                break;
            }
            case WithLookup: {
                exp = new WithLookupExpression(this.input);
                break;
            }
            case Stock: {
                exp = new StockExpression(this.input);
                break;
            }
            case Delay: {
                exp = new DelayExpression(this.input);
                break;
            }
            default: {
                exp = new EmptyExpression();
            }
        }
        if (exp != null) {
            Control[] controlArray = this.parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            if (original) {
                exp.readData(this.expr, this.data);
            }
            exp.createExpressionFields(this.parent, this.data, this.variableTable);
            if (this.modifyListener != null) {
                exp.addModifyListener(this.modifyListener);
            }
            if (this.focusListener != null) {
                exp.addFocusListener(this.focusListener);
            }
            if (this.verifyKeyListener != null) {
                exp.addVerifyKeyListener(this.verifyKeyListener);
            }
            this.expression = exp;
            this.parent.layout();
            this.validateFieldsTimed();
            this.save();
        }
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public void setVariableTable(Table table) {
        this.variableTable = table;
    }

    public void validateFieldsTimed() {
        this.validateFieldsTimed(VALIDATION_DELAY_TIME);
    }

    public void validateFieldsTimed(int delay) {
        this.validationTimer.setDelay(delay);
        if (!this.validationTimer.isRunning()) {
            this.validationTimer.start();
        } else {
            this.validationTimer.restart();
        }
    }

    public void validateFields() {
        if (this.variableTable == null) {
            return;
        }
        if (this.expr == null) {
            return;
        }
        try {
            Resource variable = (Resource)Simantics.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    return graph.getPossibleObject(ExpressionWidget.this.expr, l0.PartOf);
                }
            });
            if (variable != null) {
                ExpressionUtils.validateExpressionFields(variable, this.expression, this.variableTable, this.resourceManager);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListener = listener;
    }

    public void addVerifyKeyListener(VerifyKeyListener listener) {
        this.verifyKeyListener = listener;
    }

    public void addFocusListener(FocusListener listener) {
        this.focusListener = listener;
    }

    public void save() {
        if (this.expression != null) {
            this.expression.save(this.expr, this.data);
        }
    }
}

