/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.project;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.RuntimeValuations;
import org.simantics.db.layer0.adapter.TrendVariable;
import org.simantics.db.layer0.service.ActivationManager;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.common.IssueUtils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.services.CaseInsensitiveComponentNamingStrategy2;
import org.simantics.modeling.services.ComponentNamingStrategy;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.ExperimentManagerKeys;
import org.simantics.simulation.project.ExperimentManagerMode;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.editor.SysdynEditorNamingService;
import org.simantics.ui.workbench.IEditorNamingService;
import org.simantics.utils.ui.BundleUtils;

public class SysdynProject
extends AbstractProjectFeature {
    private static final String DEFAULT_PERSPECTIVE = "org.simantics.sysdyn.ui.perspective";

    public void configure() throws ProjectException {
        final IProject project = this.getProject();
        Session session = this.getSession();
        try {
            File base = BundleUtils.findFile((String)"org.simantics.sysdyn.ui", (String)"");
            File f = new File(base, "../org.simantics.sysdyn.tests/src/org/simantics/sysdyn/tests/scripts");
            if (f.exists()) {
                System.setProperty("scl.test.path", f.getAbsolutePath());
            }
        }
        catch (Exception base) {
            // empty catch block
        }
        this.getProjectElement().setHint(ProjectKeys.DEFAULT_PERSPECTIVE, (Object)DEFAULT_PERSPECTIVE);
        this.getProjectElement().setHint(ExperimentManagerKeys.EXPERIMENT_MANAGER_MODE, (Object)ExperimentManagerMode.MULTI_EXPERIMENT);
        this.getProjectElement().setHint(IEditorNamingService.KEY_EDITOR_NAMING_SERVICE, (Object)new SysdynEditorNamingService());
        GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)session.peekService(GraphChangeListenerSupport.class);
        if (changeSupport != null) {
            this.getProjectElement().setHint(ComponentNamingStrategy.PROJECT_KEY, (Object)new CaseInsensitiveComponentNamingStrategy2(changeSupport, "%s%d"));
        }
        try {
            Resource projectResource = (Resource)project.get();
            session.registerService(RuntimeValuations.class, (Object)new RuntimeValuations(){

                public boolean supports(String valuation) {
                    IExperimentManager expMan = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
                    IExperiment experiment = expMan.getExperiment(valuation);
                    return experiment != null;
                }

                public Accessor getAccessor(String variableIdentityPrefix, String valuation, String suffix) {
                    return null;
                }

                public TrendVariable getVariable(String variableIdentityPrefix, String valuation, String suffix) {
                    return null;
                }
            });
            ActivationManager activationManager = (ActivationManager)session.getService(ActivationManager.class);
            if (activationManager != null) {
                activationManager.activate((RequestProcessor)session, projectResource);
            }
            VirtualGraphSupport support = (VirtualGraphSupport)session.getService(VirtualGraphSupport.class);
            support.getWorkspacePersistent("experiments");
            support.getWorkspacePersistent("profiles");
            support.getWorkspacePersistent("preferences");
            support.getWorkspacePersistent("issues");
        }
        catch (DatabaseException e) {
            throw new ProjectException((Throwable)e);
        }
        this.cleanProjectFolder(session, (Resource)project.get());
        try {
            session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SysdynProject.this.onActivated(graph, SysdynProject.this.getProject());
                }
            });
        }
        catch (DatabaseException e) {
            throw new ProjectException((Throwable)e);
        }
    }

    public void deconfigure() throws ProjectException {
        ModelingUtils.untrackDependencies((RequestProcessor)this.getSession());
        this.getProjectElement().removeHint(ComponentNamingStrategy.PROJECT_KEY);
    }

    public void cleanProjectFolder(Session session, final Resource projectResource) throws ProjectException {
        String projectName = null;
        final HashMap resultPaths = new HashMap();
        try {
            projectName = (String)session.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    for (Resource model : graph.getObjects(projectResource, l0.ConsistsOf)) {
                        if (!graph.isInstanceOf(model, sr.SysdynModel)) continue;
                        for (Resource experiment : graph.getObjects(model, l0.ConsistsOf)) {
                            if (!graph.isInstanceOf(experiment, SIMU.Experiment)) continue;
                            for (Resource result : graph.getObjects(experiment, sr.Experiment_result)) {
                                if (graph.isInstanceOf(result, sr.HistoryDataset)) continue;
                                String resultFile = (String)graph.getPossibleRelatedValue(result, sr.Result_resultFile);
                                if (result == null) continue;
                                resultPaths.put(resultFile, result);
                            }
                            for (Resource resultSet : graph.getObjects(experiment, sr.Experiment_resultSet)) {
                                for (Resource result : graph.getObjects(resultSet, sr.Experiment_result)) {
                                    if (graph.isInstanceOf(result, sr.HistoryDataset)) continue;
                                    String resultFile = (String)graph.getPossibleRelatedValue(result, sr.Result_resultFile);
                                    if (result == null) continue;
                                    resultPaths.put(resultFile, result);
                                }
                            }
                        }
                    }
                    return (String)graph.getPossibleRelatedValue(projectResource, l0.HasName);
                }
            });
        }
        catch (DatabaseException e) {
            throw new ProjectException((Throwable)e);
        }
        if (projectName != null) {
            File[] files;
            File root = new File(Platform.getLocation().toOSString(), "www.simantics.org");
            if (!root.isDirectory()) {
                return;
            }
            File projectRoot = new File(root, projectName);
            if (!projectRoot.isDirectory()) {
                return;
            }
            File[] fileArray = files = projectRoot.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (resultPaths.get(file.getAbsolutePath()) == null) {
                    file.delete();
                } else {
                    resultPaths.remove(file.getAbsolutePath());
                }
                ++n2;
            }
            if (!resultPaths.keySet().isEmpty()) {
                session.asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        for (String key : resultPaths.keySet()) {
                            Resource result = (Resource)resultPaths.get(key);
                            graph.deny(result, l0.PartOf);
                            graph.deny(result, graph.getInverse(SysdynResource.getInstance((ReadGraph)graph).Experiment_result));
                        }
                    }
                });
            }
        }
    }

    public void onActivated(ReadGraph graph, IProject project) throws DatabaseException {
        IssueUtils.listenActiveProjectIssueSources((RequestProcessor)graph, (Resource)((Resource)project.get()));
        ModelingUtils.trackDependencies((RequestProcessor)graph);
    }
}

