/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.connections;

import java.awt.Shape;

public class Arcs {
    public static final double PI2 = Math.PI * 2;

    public static double normalizeAngle(double angle) {
        return Math.IEEEremainder(angle, Math.PI * 2);
    }

    public static boolean areClockwiseOrdered(double angle1, double angle2, double angle3) {
        return angle1 < angle2 ? angle2 < angle3 || angle3 < angle1 : angle2 < angle3 && angle3 < angle1;
    }

    public static double angleOfArc(double x0, double y0, double x1, double y1, double x2, double y2) {
        double dx0 = x1 - x0;
        double dy0 = y1 - y0;
        double dx1 = x1 - x2;
        double dy1 = y1 - y2;
        double dy = y2 - y0;
        double dx = x2 - x0;
        double dd = dx0 * dy - dy0 * dx;
        if (Math.abs(dd) < 1.0E-6) {
            return 0.0;
        }
        double offset = (dx0 * dx1 + dy0 * dy1) / dd;
        double angle = 1.5707963267948966 - Math.atan(offset);
        if (dd > 0.0) {
            angle -= Math.PI;
        }
        return angle;
    }

    private static double iterateAngle(double startX, double startY, double cx, double cy, double r, double curAngle, Shape endBounds, boolean dir, double move, int noOfIteration, boolean turn, boolean crossed) {
        double y_rad;
        double x_rad;
        if (noOfIteration > 16) {
            return Arcs.normalizeAngle(curAngle);
        }
        if (crossed) {
            move *= 0.5;
        }
        if (dir != turn) {
            x_rad = startX + move * Math.sin(curAngle);
            y_rad = startY + move * Math.cos(curAngle);
        } else {
            x_rad = startX - move * Math.sin(curAngle);
            y_rad = startY - move * Math.cos(curAngle);
        }
        curAngle = -Math.atan((y_rad - cy) / (x_rad - cx));
        if (x_rad - cx < 0.0) {
            curAngle += Math.PI;
        }
        curAngle = Arcs.normalizeAngle(curAngle);
        if (endBounds.contains(x_rad, y_rad)) {
            return Arcs.iterateAngle(x_rad, y_rad, cx, cy, r, curAngle, endBounds, dir, move, noOfIteration + 1, false, crossed);
        }
        return Arcs.iterateAngle(x_rad, y_rad, cx, cy, r, curAngle, endBounds, dir, move, noOfIteration + 1, true, true);
    }

    public static double nextIntersectingAngle(double cx, double cy, double r, double curAngle, Shape endBounds, boolean dir) {
        double move = 3.0;
        return Arcs.iterateAngle(endBounds.getBounds2D().getCenterX(), endBounds.getBounds2D().getCenterY(), cx, cy, r, curAngle, endBounds, dir, move, 0, false, false);
    }

    public static boolean hitTest(Shape beginBounds, Shape endBounds, double angle, double x, double y, double tolerance) {
        double ang;
        boolean clockWise = angle > 0.0;
        double x0 = beginBounds.getBounds2D().getCenterX();
        double y0 = beginBounds.getBounds2D().getCenterY();
        double x1 = endBounds.getBounds2D().getCenterX();
        double y1 = endBounds.getBounds2D().getCenterY();
        double offset = Math.abs(angle) < 1.0E-6 ? 1000.0 * Math.signum(angle) : Math.tan(1.5707963267948966 - angle) * 0.5;
        double cx = 0.5 * (x0 + x1) + offset * (y1 - y0);
        double cy = 0.5 * (y0 + y1) + offset * (x0 - x1);
        double dx0 = x0 - cx;
        double dy0 = y0 - cy;
        double dx1 = x1 - cx;
        double dy1 = y1 - cy;
        double r = Math.sqrt(dx0 * dx0 + dy0 * dy0);
        double angle0 = Arcs.nextIntersectingAngle(cx, cy, r, Math.atan2(-dy0, dx0), beginBounds, angle < 0.0);
        double angle1 = Arcs.nextIntersectingAngle(cx, cy, r, Math.atan2(-dy1, dx1), endBounds, angle > 0.0);
        double dx = x - cx;
        double dy = y - cy;
        double dist = dx * dx + dy * dy;
        double tolerance2 = tolerance * tolerance;
        return dist < (r + tolerance2) * (r + tolerance2) && dist > (r - tolerance2) * (r - tolerance2) && Arcs.areClockwiseOrdered(angle0, ang = Arcs.normalizeAngle(Math.atan2(-dy, dx)), angle1) == clockWise;
    }

    public static double getRadialDistance(Shape beginBounds, Shape endBounds, double angle, double x, double y) {
        boolean clockWise = angle > 0.0;
        double x0 = beginBounds.getBounds2D().getCenterX();
        double y0 = beginBounds.getBounds2D().getCenterY();
        double x1 = endBounds.getBounds2D().getCenterX();
        double y1 = endBounds.getBounds2D().getCenterY();
        double offset = Math.abs(angle) < 1.0E-6 ? 1000.0 * Math.signum(angle) : Math.tan(1.5707963267948966 - angle) * 0.5;
        double cx = 0.5 * (x0 + x1) + offset * (y1 - y0);
        double cy = 0.5 * (y0 + y1) + offset * (x0 - x1);
        double dx0 = x0 - cx;
        double dy0 = y0 - cy;
        double dx1 = x1 - cx;
        double dy1 = y1 - cy;
        double r = Math.sqrt(dx0 * dx0 + dy0 * dy0);
        double angle0 = Arcs.nextIntersectingAngle(cx, cy, r, Math.atan2(-dy0, dx0), beginBounds, angle < 0.0);
        double angle1 = Arcs.nextIntersectingAngle(cx, cy, r, Math.atan2(-dy1, dx1), endBounds, angle > 0.0);
        double dx = x - cx;
        double dy = y - cy;
        double dist2 = dx * dx + dy * dy;
        double ang = Arcs.normalizeAngle(Math.atan2(-dy, dx));
        if (!Arcs.areClockwiseOrdered(angle0, ang, angle1) == clockWise) {
            return Double.NaN;
        }
        return Math.abs(Math.sqrt(dist2) - r);
    }
}

