/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.synchronization;

import java.io.StringReader;
import java.util.ArrayList;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.ExternalRef;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.spreadsheet.solver.SpreadsheetCell;
import org.simantics.spreadsheet.solver.SpreadsheetFormula;
import org.simantics.spreadsheet.solver.SpreadsheetLine;
import org.simantics.spreadsheet.solver.SpreadsheetLines;
import org.simantics.spreadsheet.solver.SpreadsheetSCLConstant;
import org.simantics.spreadsheet.solver.formula.parser.SheetFormulaParser;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArrayFormulaReference;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;
import org.simantics.spreadsheet.synchronization.ExcelArrayFormula;
import org.simantics.spreadsheet.synchronization.ExcelFormula;
import org.simantics.spreadsheet.synchronization.LineContentBean;
import org.simantics.spreadsheet.synchronization.LineContentBeanCell;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.utils.Solver;

public class LineCommandBuilder
implements CommandBuilder {
    private String name;
    LineContentBean bean;

    public LineCommandBuilder(String name, boolean update) {
        this.name = name;
    }

    public void apply(Solver solver) {
        SpreadsheetBook book = (SpreadsheetBook)solver.getConcreteSolver();
        String path = this.name.substring(0, this.name.lastIndexOf("/"));
        String lineName = this.name.substring(this.name.lastIndexOf("/") + 1);
        int row = Integer.parseInt(lineName.substring(3));
        SpreadsheetLines node = (SpreadsheetLines)book.ensureSubprocess(path);
        SpreadsheetLine line = (SpreadsheetLine)node.lines.get(-row);
        if (line == null) {
            line = new SpreadsheetLine(node, row);
            node.lines.put(-row, (Object)line);
        }
        ArrayList<SpreadsheetCell> changes = new ArrayList<SpreadsheetCell>();
        int i = 0;
        while (i < this.bean.cells.length) {
            SpreadsheetCell currentCell;
            if (line.cells.size() > i) {
                currentCell = (SpreadsheetCell)line.cells.get(i);
            } else {
                currentCell = new SpreadsheetCell(line, i);
                line.cells.add((Object)currentCell);
            }
            LineContentBeanCell cell = this.bean.cells[i];
            try {
                Variant content = cell.getContent();
                if (content instanceof Variant) {
                    SpreadsheetFormula sformula;
                    AstValue v;
                    SheetFormulaParser p;
                    Object formula;
                    Variant cellVariant = content;
                    if (cellVariant == LineContentBeanCell.EMPTY) {
                        currentCell.setStyle(cell.getStyleId());
                        currentCell.setContent("");
                    } else if (ExcelFormula.BINDING.type().equals((Object)cellVariant.getBinding().type())) {
                        formula = (ExcelFormula)cellVariant.getValue(ExcelFormula.BINDING);
                        p = new SheetFormulaParser(new StringReader(((ExcelFormula)formula).expression));
                        v = p.relation();
                        currentCell.setStyle(cell.getStyleId());
                        sformula = new SpreadsheetFormula(v, ((ExcelFormula)formula).expression);
                        currentCell.setContent(sformula);
                    } else if (ExcelArrayFormula.BINDING.type().equals((Object)cellVariant.getBinding().type())) {
                        formula = (ExcelArrayFormula)cellVariant.getValue(ExcelArrayFormula.BINDING);
                        p = new SheetFormulaParser(new StringReader(((ExcelArrayFormula)formula).expression));
                        v = new AstArrayFormulaReference(((ExcelArrayFormula)formula).range, p.relation());
                        currentCell.setStyle(cell.getStyleId());
                        sformula = new SpreadsheetFormula(v, ((ExcelArrayFormula)formula).expression);
                        currentCell.setContent(sformula);
                    } else {
                        if (cellVariant.getValue() instanceof ExternalRef) {
                            throw new IllegalStateException();
                        }
                        currentCell.setStyle(cell.getStyleId());
                        currentCell.setContent(cellVariant.getValue());
                    }
                } else {
                    if (content instanceof ExternalRef) {
                        throw new IllegalStateException();
                    }
                    if (content instanceof SpreadsheetSCLConstant) {
                        currentCell.setStyle(cell.getStyleId());
                        currentCell.setContent(content);
                    }
                }
            }
            catch (Throwable e) {
                Variant content = cell.getContent();
                if (content instanceof Variant) {
                    Variant cellVariant = content;
                    currentCell.setStyle(cell.getStyleId());
                    currentCell.setContent(content);
                    try {
                        new Exception("failed: " + ((ExcelFormula)cellVariant.getValue((Binding)ExcelFormula.BINDING)).expression, e).printStackTrace();
                    }
                    catch (AdaptException e1) {
                        e1.printStackTrace();
                    }
                }
                currentCell.setStyle(cell.getStyleId());
                currentCell.setContent("LCB error happened");
            }
            changes.add(currentCell);
            ++i;
        }
        book.fireChanges(changes);
    }

    public <T> T getConcrete() {
        return (T)this;
    }
}

