/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.simantics.compressions.Compressions;
import org.simantics.db.exception.InternalException;
import org.simantics.db.procore.cluster.CompressionException;

public class LZ4 {
    private static final int InLength = 0x100000;

    public static DecompressStruct decompress(byte[] data) throws InternalException {
        assert (data.length > 12);
        SourceData sourceData = new SourceData(data);
        DecompressStruct struct = new DecompressStruct();
        int longSize = sourceData.readInt();
        int intSize = sourceData.readInt();
        int byteSize = sourceData.readInt();
        struct.longs = new long[longSize];
        try {
            LZ4.decompress(sourceData, struct.longs);
            struct.ints = new int[intSize];
            LZ4.decompress(sourceData, struct.ints);
            struct.bytes = new byte[byteSize];
            LZ4.decompress(sourceData, struct.bytes);
        }
        catch (CompressionException e) {
            throw new InternalException("Failed to decompress.", (Throwable)((Object)e));
        }
        return struct;
    }

    private static void decompress(SourceData sourceData, long[] longs) throws CompressionException {
        int length = longs.length * 8;
        ByteBuffer bytes = ByteBuffer.allocate(length);
        int size = LZ4.decompressRaw(sourceData, bytes.array());
        assert (size == length);
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < longs.length) {
            longs[i] = bytes.getLong();
            ++i;
        }
    }

    private static void decompress(SourceData sourceData, int[] ints) throws CompressionException {
        int length = ints.length * 4;
        ByteBuffer bytes = ByteBuffer.allocate(length);
        int size = LZ4.decompressRaw(sourceData, bytes.array());
        assert (size == length);
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < ints.length) {
            ints[i] = bytes.getInt();
            ++i;
        }
    }

    private static void decompress(SourceData sourceData, byte[] bytes) throws CompressionException {
        int size = LZ4.decompressRaw(sourceData, bytes);
        assert (size == bytes.length);
    }

    private static int decompressRaw(SourceData sourceData, byte[] bytes) throws CompressionException {
        int aDstSize = bytes.length;
        if (aDstSize < 1) {
            return aDstSize;
        }
        int dstOffset = 0;
        int dstSize = 0;
        while (true) {
            int dataLength = sourceData.readInt();
            assert (dataLength <= 0x100000);
            if (dataLength == 0) {
                return dstSize;
            }
            int inLength = sourceData.readInt();
            assert (aDstSize >= (dstSize += dataLength));
            assert (sourceData.left() >= inLength);
            assert (inLength > 0);
            assert (inLength <= 0x100000);
            assert (inLength <= dataLength);
            if (inLength < dataLength) {
                LZ4.decompress(sourceData.data, sourceData.offset, inLength, bytes, dstOffset, dataLength);
                sourceData.offset += inLength;
                dstOffset += dataLength;
                continue;
            }
            sourceData.readBytes(bytes, dstOffset, inLength);
            dstOffset += inLength;
        }
    }

    private static void decompress(byte[] in, int inOffset, int inLength, byte[] out, int outOffset, int outLength) throws CompressionException {
        ByteBuffer inBuffer = ByteBuffer.allocateDirect(inLength);
        inBuffer.put(in, inOffset, inLength);
        inBuffer.flip();
        ByteBuffer outBuffer = ByteBuffer.allocateDirect(outLength);
        int inflateSize = Compressions.get((String)"LZ4").decompressBuffer(inBuffer, 0, inLength, outBuffer, 0, outLength);
        if (inflateSize != outLength) {
            throw new RuntimeException("Decompression error.");
        }
        outBuffer.get(out, outOffset, outLength);
    }

    public static class DecompressStruct {
        public long[] longs;
        public int[] ints;
        public byte[] bytes;
    }

    static class SourceData {
        byte[] data;
        int offset;

        SourceData(byte[] data) {
            this.data = data;
            this.offset = 0;
        }

        int left() {
            return this.data.length - this.offset;
        }

        int readInt() {
            int inLength = 4;
            assert (this.left() >= inLength);
            ByteBuffer buffer = ByteBuffer.wrap(this.data, this.offset, inLength);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int t = buffer.getInt();
            this.offset += inLength;
            return t;
        }

        void readBytes(byte[] bytes, int aOffset, int inLength) {
            assert (this.left() >= inLength);
            System.arraycopy(this.data, this.offset, bytes, aOffset, inLength);
            this.offset += inLength;
        }
    }
}

