/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSets {
    static final Logger LOGGER = LoggerFactory.getLogger(ClusterSets.class);
    private File writeDirectory;
    private final String databaseId;
    private final HashMap<Long, Long> clusterSets;
    private final HashMap<Long, Long> reverseMap;
    private int refCount;
    private boolean modified;

    public void setWriteDirectory(File writeDirectory) {
        this.writeDirectory = writeDirectory;
    }

    private File getFile1(File directory) {
        return new File(directory, "clusterSets." + this.databaseId + ".dat");
    }

    private File getFile2(File directory) {
        return new File(directory, "clusterSets." + this.databaseId + ".dat.reverse");
    }

    public ClusterSets(File readDirectory, File writeDirectory, String databaseId) {
        try {
            PersistentData pd2;
            PersistentData pd;
            this.databaseId = databaseId;
            this.writeDirectory = writeDirectory;
            readDirectory.mkdirs();
            File file1 = this.getFile1(readDirectory);
            File file2 = this.getFile2(readDirectory);
            this.refCount = 1;
            try {
                pd = (PersistentData)Files.readFile((File)file1, (Binding)PersistentData.BINDING);
            }
            catch (IOException iOException) {
                pd = new PersistentData();
                pd.values = new HashMap();
                Files.writeFile((File)file1, (Binding)PersistentData.BINDING, (Object)pd);
            }
            try {
                pd2 = (PersistentData)Files.readFile((File)file2, (Binding)PersistentData.BINDING);
            }
            catch (IOException iOException) {
                pd2 = new PersistentData();
                pd2.values = new HashMap();
                Files.writeFile((File)file2, (Binding)PersistentData.BINDING, (Object)pd2);
            }
            this.clusterSets = pd.values;
            this.reverseMap = pd2.values;
            this.modified = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeDatabaseException("Failed to create ClusterSets.");
        }
    }

    public synchronized int inc() {
        return ++this.refCount;
    }

    public synchronized int dec() {
        return --this.refCount;
    }

    public void dispose() {
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeDatabaseException("Failed to save ClusterSets.");
        }
    }

    public synchronized boolean containsKey(long resourceId) {
        return this.clusterSets.containsKey(resourceId);
    }

    public synchronized Long get(Long resourceId) {
        return this.clusterSets.get(resourceId);
    }

    public synchronized void put(long resourceId, long clusterId) {
        this.clusterSets.put(resourceId, clusterId);
        this.reverseMap.put(clusterId, resourceId);
        this.modified = true;
    }

    public synchronized Long getClusterSet(Long clusterId) {
        return this.reverseMap.get(clusterId);
    }

    public void clear() {
        for (Long key : this.clusterSets.keySet()) {
            this.clusterSets.put(key, -1L);
        }
        this.touch();
    }

    public synchronized void touch() {
        this.modified = true;
    }

    public synchronized void save() throws IOException {
        if (!this.modified) {
            return;
        }
        this.writeDirectory.mkdirs();
        File file1 = this.getFile1(this.writeDirectory);
        File file2 = this.getFile2(this.writeDirectory);
        PersistentData pd = new PersistentData();
        pd.values = this.clusterSets;
        Files.writeFile((File)file1, (Binding)PersistentData.BINDING, (Object)pd);
        pd = new PersistentData();
        pd.values = this.reverseMap;
        Files.writeFile((File)file2, (Binding)PersistentData.BINDING, (Object)pd);
        this.modified = false;
    }

    public void validate(long[] ids) {
        TLongHashSet idSet = new TLongHashSet(ids);
        ArrayList<Long> clusterSetResourceIds = new ArrayList<Long>(this.clusterSets.keySet());
        for (long setResourceId : clusterSetResourceIds) {
            long setClusterId = ClusterTraitsBase.getClusterIdFromResourceId((long)setResourceId);
            if (!idSet.contains(setClusterId)) {
                this.clusterSets.remove(setResourceId);
                LOGGER.info("Remove cluster set mapping: cluster set has been removed " + setResourceId);
                continue;
            }
            long clusterId = this.clusterSets.get(setResourceId);
            if (clusterId == -1L || idSet.contains(clusterId)) continue;
            this.clusterSets.put(setResourceId, -1L);
            LOGGER.info("Reset cluster set mapping: active cluster set cluster has been removed " + setResourceId + " " + clusterId);
        }
        ArrayList<Long> setClusterIds = new ArrayList<Long>(this.reverseMap.keySet());
        for (Long clusterId : setClusterIds) {
            if (clusterId == -1L) continue;
            if (!idSet.contains(clusterId.longValue())) {
                this.reverseMap.remove(clusterId);
                LOGGER.info("Remove cluster set reverse mapping: cluster has been removed " + clusterId);
                continue;
            }
            Long setResourceId = this.reverseMap.get(clusterId);
            long setClusterId = ClusterTraitsBase.getClusterIdFromResourceId((long)setResourceId);
            if (idSet.contains(setClusterId)) continue;
            this.reverseMap.remove(clusterId);
            LOGGER.info("Remove cluster set reverse mapping: cluster set cluster has been removed " + setClusterId);
        }
    }

    public static class PersistentData {
        public static final Binding BINDING = Bindings.getBindingUnchecked(PersistentData.class);
        public HashMap<Long, Long> values;

        public static void main(String[] args) throws Exception {
            System.err.println(BINDING.type().toSingleLineString());
            PersistentData pd = new PersistentData();
            pd.values = new HashMap();
            long i = 0L;
            while (i < 10L) {
                pd.values.put(i, i);
                ++i;
            }
            BINDING.printValue((Object)pd, (Appendable)System.err, new DataValueRepository(), true);
        }
    }
}

