/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.simantics.db.ServerReference;
import org.simantics.db.common.utils.Logger;

public final class ProCoreServerReference
implements ServerReference {
    public final Path dbFolder;
    public final InetSocketAddress socketAddress;
    public final String dbid;

    public ProCoreServerReference() {
        this.dbFolder = Paths.get("/", new String[0]);
        this.dbid = "";
        this.socketAddress = InetSocketAddress.createUnresolved("127.0.0.0", 0);
    }

    public ProCoreServerReference(Path dbFolder) {
        if (dbFolder == null) {
            dbFolder = Paths.get("/", new String[0]);
        }
        this.dbFolder = dbFolder;
        this.dbid = "";
        this.socketAddress = InetSocketAddress.createUnresolved("127.0.0.0", 0);
    }

    public ProCoreServerReference(Path dbFolder, String hostAndPort) {
        this.dbFolder = dbFolder;
        String[] split = hostAndPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");
        }
        this.socketAddress = InetSocketAddress.createUnresolved(split[0], Integer.parseInt(split[1]));
        this.dbid = null;
    }

    public ProCoreServerReference(Path dbFolder, String host, int port) {
        this.dbFolder = dbFolder;
        this.socketAddress = new InetSocketAddress(host, port);
        this.dbid = null;
    }

    public ProCoreServerReference(Path dbFolder, String host, int port, String dbid) {
        this.dbFolder = dbFolder;
        this.socketAddress = InetSocketAddress.createUnresolved(host, port);
        this.dbid = dbid;
    }

    public ProCoreServerReference(Path dbFolder, InetSocketAddress socketAddress) {
        this.dbFolder = dbFolder;
        this.socketAddress = socketAddress;
        this.dbid = null;
    }

    public ProCoreServerReference(Path dbFolder, InetSocketAddress socketAddress, String dbid) {
        this.dbFolder = dbFolder;
        this.socketAddress = socketAddress;
        this.dbid = dbid;
    }

    public int hashCode() {
        return this.dbFolder.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        ProCoreServerReference r = (ProCoreServerReference)other;
        try {
            return Files.isSameFile(this.dbFolder, r.dbFolder);
        }
        catch (IOException e) {
            Logger.defaultLogError((String)("Failed to compare db folders. f1=" + this.dbFolder + " f2=" + r.dbFolder), (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return this.dbFolder.toString();
    }

    public Path getDBFolder() {
        return this.dbFolder;
    }
}

