/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TIntProcedure;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.ByteBufferReadable;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.ConsistsOfProcess;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.ExternalDownloadBean;
import org.simantics.db.layer0.util.TGValueModifier;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.Value;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelTransferableGraphSource
implements TransferableGraphSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelTransferableGraphSource.class);
    private final TransferableGraphConfiguration2 configuration;
    private final DomainProcessorState state;
    private final int externalBase;
    private final int resourceCount;
    private final File[] files;
    private final TGValueModifier valueModifier;
    private volatile boolean closed = false;
    TIntArrayList externalParents = new TIntArrayList();
    ArrayList<String> externalNames = new ArrayList();
    TreeMap<String, String> downloads = new TreeMap();
    int indent = 0;

    public ModelTransferableGraphSource(final ReadGraph graph, TransferableGraphConfiguration2 configuration, final DomainProcessorState state, File ... fs) throws DatabaseException {
        this.configuration = configuration;
        this.state = state;
        this.files = fs;
        this.valueModifier = state.valueModifier;
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        state.ids.put(ss.getTransientId(graph.getRootLibrary()), state.id++);
        for (TransferableGraphConfiguration2.SeedSpec spec : configuration.seeds) {
            if (!TransferableGraphConfiguration2.SeedSpec.SeedSpecType.SPECIAL_ROOT.equals((Object)spec.specType)) continue;
            int resourceId = ss.getTransientId(spec.resource);
            state.ids.put(resourceId, state.id++);
            state.externals.remove(resourceId);
        }
        this.externalBase = state.id;
        final HashSet<String> errors = new HashSet<String>();
        int[] externals = state.externals.toArray();
        int i = 0;
        while (i < externals.length) {
            this.getId(graph, externals[i], errors);
            ++i;
        }
        state.exportedPredicates.forEach(new TIntProcedure(){

            public boolean execute(int predicate) {
                try {
                    ModelTransferableGraphSource.this.getId(graph, predicate, errors);
                    int inverse = state.inverses.get(predicate);
                    if (inverse != 0) {
                        ModelTransferableGraphSource.this.getId(graph, inverse, errors);
                    }
                }
                catch (DatabaseException e) {
                    throw new RuntimeDatabaseException((Throwable)e);
                }
                return true;
            }
        });
        if (!errors.isEmpty()) {
            ArrayList<String> sorted = new ArrayList<String>(errors);
            Collections.sort(sorted);
            StringBuilder message = new StringBuilder();
            message.append("Errors in exported model:\n");
            for (String error : sorted) {
                message.append(error);
                message.append("\n");
            }
            throw new DatabaseException(message.toString());
        }
        this.resourceCount = state.id;
        state.extensions.put(ExternalDownloadBean.EXTENSION_KEY, new Variant(ExternalDownloadBean.BINDING, (Object)new ExternalDownloadBean(this.downloads)));
    }

    public boolean validateExternal(Resource ext) {
        SubgraphExtent.ExtentStatus status;
        if (this.configuration.validate && (status = this.configuration.preStatus.get(ext)) != null) {
            if (SubgraphExtent.ExtentStatus.INTERNAL.equals((Object)status)) {
                return false;
            }
            if (SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)status)) {
                return false;
            }
        }
        return true;
    }

    private Resource getResource(ReadGraph graph, int r) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return ss.getResource(r);
    }

    public final int getExistingId(ReadGraph graph, int r) throws DatabaseException {
        int ret = this.state.ids.get(r);
        if (ret != -1) {
            return ret;
        }
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        throw new DatabaseException("Id has not been created for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)ss.getResource(r)));
    }

    public int getId(ReadGraph graph, int r, Collection<String> errors) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (this.state.ids.containsKey(r)) {
            int ret = this.state.ids.get(r);
            if (ret == -1) {
                int i = 0;
                while (i <= this.indent) {
                    System.out.print("  ");
                    ++i;
                }
                System.out.println("Cycle!!!");
            }
            return ret;
        }
        Resource res = this.getResource(graph, r);
        if (!this.validateExternal(res)) {
            errors.add("Illegal reference to " + graph.getPossibleURI(this.getResource(graph, r)));
            return -2;
        }
        Collection parents = graph.getObjects(res, L0.PartOf);
        if (parents.size() != 1) {
            throw new ValidationException("Reference to external resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, r), (boolean)true) + " without unique uri (" + parents.size() + " parents).");
        }
        int pid = 0;
        for (Resource p : parents) {
            ++this.indent;
            pid = this.getId(graph, ss.getTransientId(p), errors);
            if (pid != -2) continue;
            errors.add("Illegal reference to " + graph.getPossibleURI(this.getResource(graph, r)));
            return -2;
        }
        --this.indent;
        String name = (String)graph.getRelatedValue(res, L0.HasName);
        this.externalParents.add(pid);
        this.externalNames.add(name);
        this.state.ids.put(r, this.state.id);
        this.state.externals.add(r);
        String download = (String)graph.getPossibleRelatedValue(res, L0.Ontology_download, (Binding)Bindings.STRING);
        if (download != null) {
            String uri = graph.getURI(res);
            this.downloads.put(uri, download);
        }
        return this.state.id++;
    }

    public DataContainer getHeader() throws Exception {
        return null;
    }

    public int getResourceCount() {
        return this.resourceCount;
    }

    private int countRootSeeds() {
        int result = 0;
        for (TransferableGraphConfiguration2.SeedSpec spec : this.configuration.seeds) {
            if (TransferableGraphConfiguration2.SeedSpec.SeedSpecType.INTERNAL.equals((Object)spec.specType)) continue;
            ++result;
        }
        return result;
    }

    public void init(ReadGraph graph) throws Exception {
    }

    public int getIdentityCount() {
        return this.countRootSeeds() + this.state.externals.size() + this.state.internalEntries.size() + 1;
    }

    public int getStatementCount() {
        return this.state.statementCount;
    }

    public int getValueCount() {
        return this.state.valueCount;
    }

    public void forStatements(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<int[]> procedure) throws Exception {
        int[] value = new int[4];
        long length = this.state.otherStatementsInput.length();
        this.state.otherStatementsInput.position(0L);
        while (this.state.otherStatementsInput.position() < length && !this.state.monitor.isCanceled()) {
            int s = this.state.otherStatementsInput.readInt();
            int subjectId = this.state.ids.get(s);
            boolean exclude = subjectId == -1;
            int size = this.state.otherStatementsInput.readInt();
            int i = 0;
            while (i < size) {
                int p = this.state.otherStatementsInput.readInt();
                int o = this.state.otherStatementsInput.readInt();
                if (!exclude) {
                    if (this.state.pending.contains(o)) {
                        System.err.println("excluding garbage statement " + s + " " + p + " " + o + ", object resource is garbage");
                    } else if (this.state.excludedShared.contains(o)) {
                        System.err.println("excluding shared " + s + " " + p + " " + o);
                    } else {
                        int objectId = this.getExistingId(graph, o);
                        if (objectId != -2) {
                            value[0] = subjectId;
                            value[1] = this.getExistingId(graph, p);
                            int inverse = this.state.inverses.get(p);
                            value[2] = inverse != 0 ? this.getExistingId(graph, inverse) : -1;
                            value[3] = objectId;
                            try {
                                procedure.execute((Object)value);
                            }
                            catch (Exception e) {
                                LOGGER.error("Error while processing a statement in transferable graph source", (Throwable)e);
                            }
                        } else {
                            System.err.println("Denied (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, s)) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, p)) + "," + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, o)) + ")");
                        }
                    }
                } else {
                    System.err.println("excluding shared " + s);
                }
                ++i;
            }
        }
    }

    public void forValues(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Value> procedure) throws Exception {
        Serializer variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
        ArrayList idContext = new ArrayList();
        long length = this.state.valueInput.length();
        this.state.valueInput.position(0L);
        block6: while (this.state.valueInput.position() < length && !this.state.monitor.isCanceled()) {
            int s = this.state.valueInput.readInt();
            byte valueType = this.state.valueInput.readByte();
            switch (valueType) {
                case 1: {
                    this.state.valueInput.readInt();
                }
                case 2: {
                    idContext.clear();
                    Variant variant = (Variant)variantSerializer.deserialize((DataInput)this.state.valueInput, idContext);
                    if (this.valueModifier.mayNeedModification(variant.type())) {
                        Object currentObject = variant.getValue();
                        Object newObject = this.valueModifier.modify(this.state, variant.getBinding(), currentObject);
                        if (newObject != currentObject) {
                            variant = new Variant(variant.getBinding(), newObject);
                        }
                    }
                    try {
                        procedure.execute((Object)new Value(this.state.ids.get(s), variant));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while processing a value in transferable graph source", (Throwable)e);
                    }
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized variant value type encountered: " + valueType);
                }
            }
        }
    }

    public void forValues2(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceValueProcedure procedure) throws Exception {
        Serializer datatypeSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked(Bindings.getBindingUnchecked(Datatype.class));
        ArrayList idContext = new ArrayList();
        long length = this.state.valueInput.length();
        this.state.valueInput.position(0L);
        block10: while (this.state.valueInput.position() < length && !this.state.monitor.isCanceled()) {
            int s = this.state.valueInput.readInt();
            byte valueType = this.state.valueInput.readByte();
            switch (valueType) {
                case 1: {
                    int variantLength = this.state.valueInput.readInt();
                    try {
                        procedure.rawCopy(this.state.ids.get(s), variantLength, (DataInput)this.state.valueInput);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while processing a raw value in transferable graph source", (Throwable)e);
                    }
                    continue block10;
                }
                case 2: {
                    idContext.clear();
                    Datatype type = (Datatype)datatypeSerializer.deserialize((DataInput)this.state.valueInput, idContext);
                    if (this.valueModifier.mayNeedModification(type)) {
                        Binding binding = Bindings.getBinding((Datatype)type);
                        Serializer serializer = Bindings.getSerializerUnchecked((Binding)binding);
                        Object value = serializer.deserialize((DataInput)this.state.valueInput);
                        value = this.valueModifier.modify(this.state, binding, value);
                        byte[] bytes = serializer.serialize(value);
                        try {
                            procedure.execute(this.state.ids.get(s), type, (DataInput)new ByteBufferReadable(bytes));
                        }
                        catch (Exception e) {
                            LOGGER.error("Error while processing a data type in transferable graph source", (Throwable)e);
                        }
                        continue block10;
                    }
                    try {
                        procedure.execute(this.state.ids.get(s), type, (DataInput)this.state.valueInput);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while processing a raw value in transferable graph source", (Throwable)e);
                    }
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized variant value type encountered: " + valueType);
                }
            }
        }
    }

    protected Identity getRootIdentity(DomainProcessorState state, SerialisationSupport support, Resource rootLibrary) throws DatabaseException {
        return new Identity(state.ids.get(support.getTransientId(rootLibrary)), (IdentityDefinition)new External(-1, ""));
    }

    public void forIdentities(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Identity> procedure) throws Exception {
        SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        try {
            procedure.execute((Object)this.getRootIdentity(this.state, support, graph.getRootLibrary()));
        }
        catch (Exception e) {
            LOGGER.error("Error while processing a root identity in transferable graph source", (Throwable)e);
        }
        TIntObjectHashMap internalMap = new TIntObjectHashMap(100, 0.5f, Integer.MIN_VALUE);
        for (TransferableGraphConfiguration2.SeedSpec r : this.configuration.seeds) {
            if (TransferableGraphConfiguration2.SeedSpec.SeedSpecType.INTERNAL.equals((Object)r.specType)) continue;
            String typeId = r.type;
            if (typeId == null) {
                Resource type = graph.getPossibleType(r.resource, L0.Entity);
                typeId = type != null ? graph.getURI(type) : "http://www.simantics.org/Layer0-1.1/Entity";
            }
            int id = this.state.ids.get(support.getTransientId(r.resource));
            Root root = new Root(r.name, typeId);
            Identity rootId = new Identity(id, (IdentityDefinition)root);
            internalMap.put(id, (Object)rootId);
            try {
                procedure.execute((Object)rootId);
            }
            catch (Exception e) {
                LOGGER.error("Error while processing a root in transferable graph source", (Throwable)e);
            }
        }
        int i = 0;
        while (i < this.state.externals.size()) {
            int parent = this.externalParents.get(i);
            String name = this.externalNames.get(i);
            try {
                procedure.execute((Object)new Identity(this.externalBase + i, (IdentityDefinition)new External(parent, name)));
            }
            catch (Exception e) {
                LOGGER.error("Error while processing a an external identity in transferable graph source", (Throwable)e);
            }
            ++i;
        }
        if (this.state.internalEntries != null) {
            for (ConsistsOfProcess.ConsistsOfProcessEntry ie : this.state.internalEntries) {
                if (ie.parent != null) {
                    if (ie.name == null) continue;
                    try {
                        procedure.execute((Object)this.resolveInternal(graph, support, ie, (TIntObjectMap<Identity>)internalMap));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while processing an internal identity in transferable graph source", (Throwable)e);
                    }
                    continue;
                }
                try {
                    procedure.execute((Object)this.resolveInternal(graph, support, ie, (TIntObjectMap<Identity>)internalMap));
                }
                catch (Exception e) {
                    LOGGER.error("Error while processing an internal identity in transferable graph source", (Throwable)e);
                }
            }
        }
    }

    private Identity resolveInternal(ReadGraph graph, SerialisationSupport ss, ConsistsOfProcess.ConsistsOfProcessEntry entry, TIntObjectMap<Identity> internalMap) throws DatabaseException {
        int id = this.state.ids.get(ss.getTransientId(entry.resource));
        Identity existing = (Identity)internalMap.get(id);
        if (existing != null) {
            return existing;
        }
        if (entry.parent == null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource possibleParent = graph.getPossibleObject(entry.resource, L0.PartOf);
            if (possibleParent == null) {
                throw new DatabaseException("Invalid root or internal parent path: " + entry.resource);
            }
            int externalId = this.state.ids.get(ss.getTransientId(possibleParent));
            Identity result = new Identity(id, (IdentityDefinition)new Internal(externalId, entry.name));
            internalMap.put(id, (Object)result);
            return result;
        }
        Identity parent = this.resolveInternal(graph, ss, entry.parent, internalMap);
        Identity result = new Identity(id, (IdentityDefinition)new Internal(parent.resource, entry.name));
        internalMap.put(id, (Object)result);
        return result;
    }

    public TreeMap<String, Variant> getExtensions() {
        return this.state.extensions;
    }

    public File[] getFiles() {
        return this.files;
    }

    private static <T> T tryClose(T c) throws IOException {
        if (c != null && c instanceof Closeable) {
            ((Closeable)c).close();
        }
        return null;
    }

    public void closeStreams() throws IOException {
        this.state.valueInput = ModelTransferableGraphSource.tryClose(this.state.valueInput);
        this.state.otherStatementsInput = ModelTransferableGraphSource.tryClose(this.state.otherStatementsInput);
        this.state.statementsOutput = ModelTransferableGraphSource.tryClose(this.state.statementsOutput);
        this.state.valueOutput = ModelTransferableGraphSource.tryClose(this.state.valueOutput);
    }

    public void reset() throws Exception {
        throw new UnsupportedOperationException();
    }

    public long[] getResourceArray(ReadGraph graph) throws DatabaseException {
        final SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        final long[] result = new long[this.state.ids.size()];
        this.state.ids.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int a, int b) {
                try {
                    Resource r = ss.getResource(a);
                    result[b] = r.getResourceId();
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
        return result;
    }

    public DomainProcessorState getState() {
        return this.state;
    }

    public void forResourceStatements(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<int[]> procedure) throws Exception {
        int[] value = new int[4];
        long length = this.state.otherStatementsInput.length();
        this.state.otherStatementsInput.position(0L);
        while (this.state.otherStatementsInput.position() < length) {
            int s = this.state.otherStatementsInput.readInt();
            int subjectId = this.state.ids.get(s);
            boolean exclude = subjectId == -1;
            int size = this.state.otherStatementsInput.readInt();
            int i = 0;
            while (i < size) {
                int p = this.state.otherStatementsInput.readInt();
                int o = this.state.otherStatementsInput.readInt();
                if (!exclude) {
                    if (this.state.excludedShared.contains(o)) {
                        System.err.println("excluding shared " + s + " " + p + " " + o);
                    } else {
                        int objectId = this.getExistingId(graph, o);
                        if (objectId != -2) {
                            value[0] = s;
                            value[1] = p;
                            int inverse = this.state.inverses.get(p);
                            value[2] = inverse != 0 ? inverse : -1;
                            value[3] = o;
                            try {
                                procedure.execute((Object)value);
                            }
                            catch (Exception e) {
                                LOGGER.error("Error while processing a statement in transferable graph source", (Throwable)e);
                            }
                        } else {
                            System.err.println("Denied (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, s)) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, p)) + "," + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.getResource(graph, o)) + ")");
                        }
                    }
                } else {
                    System.err.println("excluding shared " + s);
                }
                ++i;
            }
        }
    }

    public void forValueResources(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<int[]> procedure) throws Exception {
        int[] value = new int[1];
        long length = this.state.valueInput.length();
        while (this.state.valueInput.position() < length) {
            value[0] = this.state.valueInput.readInt();
            try {
                procedure.execute((Object)value);
            }
            catch (Exception e) {
                LOGGER.error("Error while processing a value in transferable graph source", (Throwable)e);
            }
        }
    }

    public TransferableGraphConfiguration2 getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ModelTransferableGraphSource modelTransferableGraphSource = this;
        synchronized (modelTransferableGraphSource) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.closeStreams();
        if (this.files != null) {
            File[] fileArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Files.deleteIfExists(f.toPath());
                ++n2;
            }
        }
    }
}

