/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.multimap.list.ListMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.DeferredBinaryFile;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbFunction;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainMigration.class);
    private static final int CHANGELOG_ENTRY_BYTE_SIZE = 40;
    private static final int CHANGELOG_IN_MEMORY_THRESHOLD_SIZE = 800000;
    private static final int CHANGELOG_BUFFER_SIZE = 65536;
    private static final Resource NULL = new SentinelResource();
    private static final Resource FAILED = new SentinelResource();
    private final boolean debug = LOGGER.isDebugEnabled();
    private final boolean trace = LOGGER.isTraceEnabled();
    private final WriteGraph graph;
    private final MigrationConfig config;
    private MigrationReportBuilder report;
    private Map<Resource, Resource> migrated;
    private Set<Resource> internalSet;
    private List<Tuple3> specsExt;
    private boolean migrationFailedForLastResource;

    private static Resource browse(ReadGraph graph, Resource r, String path) throws DatabaseException {
        int beginIndex = 0;
        int endIndex = path.indexOf(47, beginIndex);
        while (endIndex != -1) {
            if ((r = CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)r, (String)URIStringUtils.unescape((String)path.substring(beginIndex, endIndex)))) == null) {
                return null;
            }
            beginIndex = endIndex + 1;
            endIndex = path.indexOf(47, beginIndex);
        }
        return CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)r, (String)URIStringUtils.unescape((String)path.substring(beginIndex)));
    }

    private static Resource possibleMigratedResource(ReadGraph graph, String uri, Resource source, String sourceURI, List<Resource> targets) throws DatabaseException {
        if (sourceURI.equals(uri)) {
            return targets.get(0);
        }
        String path = uri.substring(sourceURI.length() + 1);
        for (Resource target : targets) {
            Resource ret = DomainMigration.browse(graph, target, path);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private DomainMigration(WriteGraph graph, MigrationConfig config) {
        this.graph = graph;
        this.config = config;
    }

    private Resource migrateResource(Resource r) throws DatabaseException {
        this.migrationFailedForLastResource = false;
        Resource alreadyMigrated = this.migrated.get(r);
        if (alreadyMigrated != null) {
            if (NULL == alreadyMigrated) {
                return null;
            }
            if (FAILED == alreadyMigrated) {
                this.migrationFailedForLastResource = true;
                return null;
            }
            return alreadyMigrated;
        }
        if (this.internalSet.contains(r)) {
            this.migrated.put(r, NULL);
            return null;
        }
        Resource result = null;
        String uri = (String)this.graph.syncRequest((Read)new ResourceToPossibleURI(r), (AsyncProcedure)TransientCacheAsyncListener.instance());
        if (uri != null) {
            boolean resourceInSomeMigratedSource = false;
            for (Tuple3 spec : this.specsExt) {
                String sourceContainerURI = (String)spec.c0;
                if (!uri.startsWith(sourceContainerURI)) continue;
                resourceInSomeMigratedSource = true;
                Resource sourceContainer = (Resource)spec.c1;
                List targetContainers = (List)spec.c2;
                result = DomainMigration.possibleMigratedResource((ReadGraph)this.graph, uri, sourceContainer, sourceContainerURI, targetContainers);
                if (result != null) break;
            }
            if (result == null && resourceInSomeMigratedSource) {
                this.migrationFailedForLastResource = true;
                this.migrated.put(r, FAILED);
                if (this.debug) {
                    LOGGER.debug("Failed to migrate external resource {}, no correspondence found in any target container", (Object)NameUtils.getURIOrSafeNameInternal((ReadGraph)this.graph, (Resource)r));
                }
                return null;
            }
        }
        if (result == null) {
            this.migrated.put(r, NULL);
            return null;
        }
        this.migrated.put(r, result);
        return result;
    }

    private MigrationReport migrateDomainSpec(Resource r, List<Tuple2> specs) throws DatabaseException {
        this.report = new MigrationReportBuilder(this.config, r, specs);
        try {
            boolean dryRun = this.config.dryRun;
            CollectionSupport cs = (CollectionSupport)this.graph.getService(CollectionSupport.class);
            DirectQuerySupport dqs = (DirectQuerySupport)this.graph.getService(DirectQuerySupport.class);
            Collection<Resource> internalList = Layer0Utils.domainResources((ReadGraph)this.graph, r);
            this.internalSet = cs.getResourceSet((ReadGraph)this.graph, internalList);
            this.migrated = (Map)cs.createMap(Resource.class);
            int count = internalList.size();
            int done = 0;
            ArrayList<Resource> temp = null;
            if (this.config.collectDetailedReportData) {
                temp = new ArrayList<Resource>();
                temp.add(null);
                temp.add(null);
            }
            byte[] changebuf = null;
            LongBuffer changebufl = null;
            if (this.report.changelog != null) {
                changebuf = new byte[40];
                changebufl = ByteBuffer.wrap(changebuf).asLongBuffer();
                changebufl.limit(5);
            }
            this.report.processedResources = count;
            this.specsExt = new ArrayList<Tuple3>();
            for (Tuple2 spec : specs) {
                this.specsExt.add(new Tuple3((Object)this.graph.getURI((Resource)spec.c0), spec.c0, spec.c1));
            }
            for (Resource internal : internalList) {
                DirectStatements ds = dqs.getDirectStatements((ReadGraph)this.graph, internal);
                for (Statement stm : ds) {
                    boolean objectMigrated;
                    Resource predicate = stm.getPredicate();
                    Resource object = stm.getObject();
                    Resource migratedPredicate = this.migrateResource(predicate);
                    boolean predicateFailed = this.migrationFailedForLastResource;
                    Resource migratedObject = this.migrateResource(object);
                    boolean objectFailed = this.migrationFailedForLastResource;
                    boolean predicateMigrated = migratedPredicate != null;
                    boolean bl = objectMigrated = migratedObject != null;
                    if (predicateMigrated || objectMigrated) {
                        if (migratedPredicate == null) {
                            migratedPredicate = predicate;
                        }
                        if (migratedObject == null) {
                            migratedObject = object;
                        }
                        if (this.config.collectDetailedReportData) {
                            temp.set(0, migratedPredicate);
                            temp.set(1, migratedObject);
                            if (predicateMigrated && objectMigrated) {
                                this.report.fullyChanged.putAll((Object)internal, temp);
                            } else if (predicateMigrated) {
                                this.report.changedPredicates.putAll((Object)internal, temp);
                            } else {
                                this.report.changedObjects.putAll((Object)internal, temp);
                            }
                        }
                        if (this.report.changelog != null) {
                            changebufl.rewind();
                            changebufl.put(internal.getResourceId());
                            changebufl.put(predicate.getResourceId());
                            changebufl.put(object.getResourceId());
                            changebufl.put(migratedPredicate.getResourceId());
                            changebufl.put(migratedObject.getResourceId());
                            try {
                                this.report.changelog.write(changebuf);
                            }
                            catch (IOException e) {
                                throw new DatabaseException("Failed to write migration change log contents to disk", (Throwable)e);
                            }
                        }
                        if (!dryRun) {
                            this.graph.deny(internal, predicate, object);
                            this.graph.claim(internal, migratedPredicate, migratedObject);
                            if (this.trace) {
                                LOGGER.trace("migrate: {} {} {}", new Object[]{NameUtils.getURIOrSafeNameInternal((ReadGraph)this.graph, (Resource)internal), NameUtils.getURIOrSafeNameInternal((ReadGraph)this.graph, (Resource)migratedPredicate), NameUtils.getURIOrSafeNameInternal((ReadGraph)this.graph, (Resource)migratedObject)});
                            }
                        }
                        ++this.report.migratedStatements;
                    } else if (predicateFailed || objectFailed) {
                        ++this.report.failures;
                        if (this.config.collectDetailedReportData) {
                            if (predicateFailed && objectFailed) {
                                this.report.failedStatements.put((Object)internal, (Object)stm);
                            } else if (predicateFailed) {
                                this.report.failedPredicates.put((Object)internal, (Object)stm);
                            } else {
                                this.report.failedObjects.put((Object)internal, (Object)stm);
                            }
                        }
                    }
                    ++this.report.processedStatements;
                }
                if (!this.trace || (long)(++done) % 1000L != 0L) continue;
                LOGGER.trace("processed {}/{}", (Object)done, (Object)count);
            }
            MigrationReport migrationReport = this.report.build();
            return migrationReport;
        }
        finally {
            try {
                this.report.changelog.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close collected changelog file", (Throwable)e);
            }
        }
    }

    public static MigrationReport migrateDomainWithSpecs(WriteGraph graph, MigrationConfig config, Resource r, List<Tuple2> specs) throws DatabaseException {
        return new DomainMigration(graph, config).migrateDomainSpec(r, specs);
    }

    public static MigrationReport migrateDomain(WriteGraph graph, MigrationConfig config, Resource r, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        return DomainMigration.migrateDomainWithSpecs(graph, config, r, Collections.singletonList(new Tuple2((Object)sourceContainer, Collections.singletonList(targetContainer))));
    }

    private static void dumpReportSmall(ReadGraph graph, MigrationReport r, PrintWriter out) throws DatabaseException {
        out.append("# Migration report for ").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)r.migratedResource()));
        if (r.config().dryRun) {
            out.println("# Dry-run mode - nothing changed");
        }
        out.println("Specifications:");
        for (Tuple2 t : r.specs()) {
            Resource src = (Resource)t.c0;
            List tgts = (List)t.c1;
            out.append("\t").append(graph.getPossibleURI(src)).append(" -> [");
            boolean first = true;
            for (Resource tgt : tgts) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(graph.getPossibleURI(tgt));
            }
            out.println("]");
        }
        out.append("Processed resources:  ").println(r.processedResources());
        out.append("Processed statements: ").println(r.processedStatements());
        out.append("Migrated statements:  ").println(r.migratedStatements());
        out.append("Failed migrations:    ").println(r.failures());
    }

    private static void reportChangedStatements(ReadGraph graph, ListMultimap<Resource, Resource> rs, PrintWriter out, IntConsumer header) throws DatabaseException {
        int rss = rs.size();
        if (rss > 0) {
            header.accept(rss);
            int sc = 0;
            for (Resource s : rs.keysView()) {
                ListIterable vs = rs.get((Object)s);
                int sz = vs.size();
                out.append("\t[" + sc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)s));
                int i = 0;
                while (i < sz) {
                    Resource mp = (Resource)vs.get(i);
                    Resource mo = (Resource)vs.get(i + 1);
                    out.append("\t\t[" + i / 2 + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)mp));
                    out.append("\t\t\t\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)mo));
                    i += 2;
                }
                ++sc;
            }
        }
    }

    private static void reportFailedStatements(ReadGraph graph, ListMultimap<Resource, Statement> rs, PrintWriter out, IntConsumer header) throws DatabaseException {
        int rss = rs.size();
        if (rss > 0) {
            header.accept(rss);
            int sc = 0;
            for (Resource s : rs.keysView()) {
                out.append("\t[" + sc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)s));
                int pc = 0;
                for (Statement stm : rs.get((Object)s)) {
                    out.append("\t\t[" + pc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)stm.getPredicate()));
                    out.append("\t\t\t\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)stm.getObject()));
                    ++pc;
                }
                ++sc;
            }
        }
    }

    public static void dumpReport(ReadGraph graph, MigrationReport r, PrintWriter out) throws DatabaseException {
        DomainMigration.dumpReportSmall(graph, r, out);
        DomainMigration.reportChangedStatements(graph, r.fullyChanged(), out, size -> out.println("Subjects with changed statements [" + size / 2 + "]:"));
        DomainMigration.reportChangedStatements(graph, r.changedPredicates(), out, size -> out.println("Subjects with changed predicates [" + size / 2 + "]:"));
        DomainMigration.reportChangedStatements(graph, r.changedObjects(), out, size -> out.println("Subjects with changed objects [" + size / 2 + "]:"));
        DomainMigration.reportFailedStatements(graph, r.failedStatements(), out, size -> out.println("Subjects with failed statement migrations [" + size + "]:"));
        DomainMigration.reportFailedStatements(graph, r.failedPredicates(), out, size -> out.println("Subjects with failed predicate migrations [" + size + "]:"));
        DomainMigration.reportFailedStatements(graph, r.failedObjects(), out, size -> out.println("Subjects with failed object migrations [" + size + "]:"));
    }

    private static <T> void forPairs(RichIterable<T> ri, BiConsumer<T, T> c) {
        Object r1 = null;
        for (Object r : ri) {
            if (r1 == null) {
                r1 = r;
                continue;
            }
            c.accept(r1, r);
            r1 = null;
        }
    }

    private static void forStatements(RichIterable<Statement> ri, BiConsumer<Resource, Resource> c) {
        ri.forEach((Procedure & Serializable)s -> c.accept(s.getPredicate(), s.getObject()));
    }

    private static List<Resource> sortedList(CollectionSupport cs, Collection<Resource> c) {
        return c.isEmpty() ? Collections.emptyList() : cs.asSortedList(c);
    }

    public static void dumpReport2(ReadGraph graph, MigrationReport r, PrintWriter out) throws DatabaseException {
        DomainMigration.dumpReportSmall(graph, r, out);
        if (!r.config().collectDetailedReportData) {
            return;
        }
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set subjects = cs.createSet(r.fullyChanged().size() + r.changedPredicates().size() + r.changedObjects().size());
        r.fullyChanged().forEachKey(subjects::add);
        r.changedPredicates().forEachKey(subjects::add);
        r.changedObjects().forEachKey(subjects::add);
        Set prs = cs.createSet();
        Set changedPredicate = cs.createSet();
        Set changedObject = cs.createSet();
        MutableSetMultimap po = Multimaps.mutable.set.empty();
        int ssz = subjects.size();
        if (ssz > 0) {
            out.println("Subjects with changed statements [" + subjects.size() + "]:");
            int sc = 0;
            for (Resource s : DomainMigration.sortedList(cs, subjects)) {
                out.append("S[" + sc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)s));
                po.clear();
                prs.clear();
                changedPredicate.clear();
                changedObject.clear();
                DomainMigration.forPairs(r.fullyChanged().get((Object)s), (p, o) -> {
                    po.put(p, o);
                    prs.add(p);
                    changedPredicate.add(p);
                    changedObject.add(o);
                });
                DomainMigration.forPairs(r.changedPredicates().get((Object)s), (p, o) -> {
                    po.put(p, o);
                    prs.add(p);
                    changedPredicate.add(p);
                });
                DomainMigration.forPairs(r.changedObjects().get((Object)s), (p, o) -> {
                    po.put(p, o);
                    prs.add(p);
                    changedObject.add(o);
                });
                int pc = 0;
                for (Resource p2 : DomainMigration.sortedList(cs, prs)) {
                    out.append('\t').append(changedPredicate.contains(p2) ? "* " : "  ").append("P[" + pc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)p2));
                    int oc = 0;
                    for (Resource o2 : DomainMigration.sortedList(cs, (Collection<Resource>)po.get((Object)p2))) {
                        out.append("\t\t").append(changedObject.contains(o2) ? "* " : "  ").append("O[" + oc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)o2));
                        ++oc;
                    }
                    ++pc;
                }
                ++sc;
            }
        }
        subjects.clear();
        r.failedStatements().forEachKey(subjects::add);
        r.failedPredicates().forEachKey(subjects::add);
        r.failedObjects().forEachKey(subjects::add);
        ssz = subjects.size();
        if (ssz > 0) {
            out.println("Subjects with statements that failed migration [" + subjects.size() + "]:");
            int sc = 0;
            for (Resource s : DomainMigration.sortedList(cs, subjects)) {
                out.append("F S[" + sc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)s));
                po.clear();
                prs.clear();
                changedPredicate.clear();
                changedObject.clear();
                DomainMigration.forStatements((RichIterable<Statement>)r.failedStatements().get((Object)s), (p, o) -> {
                    po.put(p, o);
                    prs.add(p);
                    changedPredicate.add(p);
                    changedObject.add(o);
                });
                DomainMigration.forStatements((RichIterable<Statement>)r.failedPredicates().get((Object)s), (p, o) -> {
                    po.put(p, o);
                    prs.add(p);
                    changedPredicate.add(p);
                });
                DomainMigration.forStatements((RichIterable<Statement>)r.failedObjects().get((Object)s), (p, o) -> {
                    po.put(p, o);
                    prs.add(p);
                    changedObject.add(o);
                });
                int pc = 0;
                for (Resource p3 : DomainMigration.sortedList(cs, prs)) {
                    out.append('\t').append(changedPredicate.contains(p3) ? "F " : "  ").append("P[" + pc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)p3));
                    int oc = 0;
                    for (Resource o3 : DomainMigration.sortedList(cs, (Collection<Resource>)po.get((Object)p3))) {
                        out.append("\t\t").append(changedObject.contains(o3) ? "F " : "  ").append("O[" + oc + "]\t").println(NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)o3));
                        ++oc;
                    }
                    ++pc;
                }
                ++sc;
            }
        }
    }

    public static String dumpReport(ReadGraph graph, MigrationReport r) throws DatabaseException {
        StringWriter sw = new StringWriter(65536);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter out = new PrintWriter(sw);){
            DomainMigration.dumpReport(graph, r, out);
            return sw.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String dumpReport2(ReadGraph graph, MigrationReport r) throws DatabaseException {
        StringWriter sw = new StringWriter(65536);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter out = new PrintWriter(sw);){
            DomainMigration.dumpReport2(graph, r, out);
            return sw.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void applyChanges(WriteGraph graph, MigrationReport report) throws DatabaseException {
        MigrationReportSmall r = (MigrationReportSmall)report;
        if (r.changelog == null) {
            throw new IllegalArgumentException("Migration report was not created with MigrationConfig.collectApplicableChanges set to true or the migrations have already been applied.");
        }
        HashMap inverseMap = new HashMap();
        DbFunction inverseFunction = p -> {
            Resource inv = (Resource)inverseMap.get(p);
            if (inv != null) {
                return inv != NULL ? inv : null;
            }
            inv = graph.getPossibleInverse(p);
            inverseMap.put(p, inv != null ? inv : NULL);
            return inv;
        };
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        File clogFile = null;
        RandomAccessBinary rab = null;
        long dataLength = 0L;
        try {
            try {
                if (r.changelog.isInMemory()) {
                    rab = r.changelog.getMemory();
                    dataLength = rab.position();
                    rab.position(0L);
                } else {
                    clogFile = r.changelog.getFile();
                    rab = new BinaryFile(clogFile, 65536);
                    dataLength = rab.length();
                }
                long changes = dataLength / 40L;
                Throwable throwable = null;
                Object var13_13 = null;
                try (RandomAccessBinary _rab = rab;){
                    int i = 0;
                    while ((long)i < changes) {
                        long s = rab.readLong();
                        long p2 = rab.readLong();
                        long o = rab.readLong();
                        long mp = rab.readLong();
                        long mo = rab.readLong();
                        Resource sr = ss.getResource(s);
                        Resource pr = ss.getResource(p2);
                        Resource or = ss.getResource(o);
                        Resource mpr = mp == p2 ? pr : ss.getResource(mp);
                        Resource mor = mo == o ? or : ss.getResource(mo);
                        Resource prinv = (Resource)inverseFunction.apply((Object)pr);
                        Resource mprinv = mp == p2 ? prinv : (Resource)inverseFunction.apply((Object)mpr);
                        graph.deny(sr, pr, prinv, or);
                        graph.claim(sr, mpr, mprinv, mor);
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                r.changelog = null;
            }
            catch (IOException e) {
                throw new DatabaseException("Failed to read migration change log file during its application", (Throwable)e);
            }
        }
        finally {
            try {
                if (r.changelog != null && r.changelog.isInMemory()) {
                    r.changelog.position(dataLength);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to reset original memory buffer position", (Object)dataLength, (Object)e);
            }
            if (clogFile != null) {
                try {
                    Files.delete(clogFile.toPath());
                }
                catch (IOException e) {
                    LOGGER.error("Failed to delete temporary file {}", (Object)clogFile, (Object)e);
                }
            }
        }
    }

    public static class MigrationConfig {
        public final boolean dryRun;
        public final boolean collectDetailedReportData;
        public final boolean collectApplicableChanges;

        public MigrationConfig(boolean dryRun, boolean collectDetailedReportData, boolean collectApplicableChanges) {
            this.dryRun = dryRun;
            this.collectDetailedReportData = collectDetailedReportData;
            this.collectApplicableChanges = collectApplicableChanges;
        }

        public String toString() {
            return String.format("MigrationConfig [dryRun=%b, collectDetailedReportData=%b, collectApplicableChanges=%b]", this.dryRun, this.collectDetailedReportData, this.collectApplicableChanges);
        }
    }

    public static interface MigrationReport {
        public MigrationConfig config();

        public List<Tuple2> specs();

        public Resource migratedResource();

        public int processedResources();

        public int processedStatements();

        public int migratedStatements();

        public int failures();

        default public ListMultimap<Resource, Resource> fullyChanged() {
            return Multimaps.immutable.list.empty();
        }

        default public ListMultimap<Resource, Resource> changedPredicates() {
            return Multimaps.immutable.list.empty();
        }

        default public ListMultimap<Resource, Resource> changedObjects() {
            return Multimaps.immutable.list.empty();
        }

        default public ListMultimap<Resource, Statement> failedStatements() {
            return Multimaps.immutable.list.empty();
        }

        default public ListMultimap<Resource, Statement> failedPredicates() {
            return Multimaps.immutable.list.empty();
        }

        default public ListMultimap<Resource, Statement> failedObjects() {
            return Multimaps.immutable.list.empty();
        }
    }

    private static class MigrationReportBuilder {
        final MigrationConfig config;
        final List<Tuple2> specs;
        final Resource migratedResource;
        int processedResources;
        int processedStatements;
        int migratedStatements;
        int failures;
        MutableListMultimap<Resource, Resource> fullyChanged;
        MutableListMultimap<Resource, Resource> changedPredicates;
        MutableListMultimap<Resource, Resource> changedObjects;
        MutableListMultimap<Resource, Statement> failedStatements;
        MutableListMultimap<Resource, Statement> failedPredicates;
        MutableListMultimap<Resource, Statement> failedObjects;
        DeferredBinaryFile changelog;

        MigrationReportBuilder(MigrationConfig config, Resource migratedResource, List<Tuple2> specs) {
            this.config = config;
            this.migratedResource = migratedResource;
            this.specs = specs;
            if (config.collectDetailedReportData) {
                Multimaps.MutableMultimaps.MutableListMultimapFactory f = Multimaps.mutable.list;
                this.fullyChanged = f.empty();
                this.changedPredicates = f.empty();
                this.changedObjects = f.empty();
                this.failedStatements = f.empty();
                this.failedPredicates = f.empty();
                this.failedObjects = f.empty();
            }
            if (config.collectApplicableChanges && !config.dryRun) {
                DeferredBinaryFile.FileSupplier fileSupplier = () -> {
                    File tmp = SimanticsInternal.getTemporaryDirectory();
                    return File.createTempFile("domain-migration-", ".clog", tmp);
                };
                this.changelog = new DeferredBinaryFile(fileSupplier, 800000, 65536);
            }
        }

        MigrationReportSmall build0() {
            if (this.config.collectDetailedReportData) {
                return new MigrationReportDetailed(this.config, this.specs, this.migratedResource, this.processedResources, this.processedStatements, this.migratedStatements, this.failures, (ListMultimap<Resource, Resource>)this.fullyChanged, (ListMultimap<Resource, Resource>)this.changedPredicates, (ListMultimap<Resource, Resource>)this.changedObjects, (ListMultimap<Resource, Statement>)this.failedStatements, (ListMultimap<Resource, Statement>)this.failedPredicates, (ListMultimap<Resource, Statement>)this.failedObjects);
            }
            return new MigrationReportSmall(this.config, this.specs, this.migratedResource, this.processedResources, this.processedStatements, this.migratedStatements, this.failures);
        }

        MigrationReport build() {
            MigrationReportSmall r = this.build0();
            if (this.changelog != null) {
                r.changelog = this.changelog;
            }
            return r;
        }
    }

    private static class MigrationReportDetailed
    extends MigrationReportSmall {
        private final ListMultimap<Resource, Resource> fullyChanged;
        private final ListMultimap<Resource, Resource> changedPredicates;
        private final ListMultimap<Resource, Resource> changedObjects;
        private final ListMultimap<Resource, Statement> failedStatements;
        private final ListMultimap<Resource, Statement> failedPredicates;
        private final ListMultimap<Resource, Statement> failedObjects;

        MigrationReportDetailed(MigrationConfig config, List<Tuple2> specs, Resource migratedResource, int processedResources, int processedStatements, int migratedStatements, int failures, ListMultimap<Resource, Resource> fullyChanged, ListMultimap<Resource, Resource> changedPredicates, ListMultimap<Resource, Resource> changedObjects, ListMultimap<Resource, Statement> failedStatements, ListMultimap<Resource, Statement> failedPredicates, ListMultimap<Resource, Statement> failedObjects) {
            super(config, specs, migratedResource, processedResources, processedStatements, migratedStatements, failures);
            this.fullyChanged = fullyChanged;
            this.changedPredicates = changedPredicates;
            this.changedObjects = changedObjects;
            this.failedStatements = failedStatements;
            this.failedPredicates = failedPredicates;
            this.failedObjects = failedObjects;
        }

        @Override
        public ListMultimap<Resource, Resource> fullyChanged() {
            return this.fullyChanged;
        }

        @Override
        public ListMultimap<Resource, Resource> changedPredicates() {
            return this.changedPredicates;
        }

        @Override
        public ListMultimap<Resource, Resource> changedObjects() {
            return this.changedObjects;
        }

        @Override
        public ListMultimap<Resource, Statement> failedStatements() {
            return this.failedStatements;
        }

        @Override
        public ListMultimap<Resource, Statement> failedPredicates() {
            return this.failedPredicates;
        }

        @Override
        public ListMultimap<Resource, Statement> failedObjects() {
            return this.failedObjects;
        }
    }

    private static class MigrationReportSmall
    implements MigrationReport {
        private final MigrationConfig config;
        private final List<Tuple2> specs;
        private final Resource migratedResource;
        private final int processedResources;
        private final int processedStatements;
        private final int migratedStatements;
        private final int failures;
        private DeferredBinaryFile changelog;

        protected MigrationReportSmall(MigrationConfig config, List<Tuple2> specs, Resource migratedResource, int processedResources, int processedStatements, int migratedStatements, int failures) {
            this.config = config;
            this.specs = specs;
            this.migratedResource = migratedResource;
            this.processedResources = processedResources;
            this.processedStatements = processedStatements;
            this.migratedStatements = migratedStatements;
            this.failures = failures;
        }

        @Override
        public MigrationConfig config() {
            return this.config;
        }

        @Override
        public List<Tuple2> specs() {
            return this.specs;
        }

        @Override
        public Resource migratedResource() {
            return this.migratedResource;
        }

        @Override
        public int processedResources() {
            return this.processedResources;
        }

        @Override
        public int processedStatements() {
            return this.processedStatements;
        }

        @Override
        public int migratedStatements() {
            return this.migratedStatements;
        }

        @Override
        public int failures() {
            return this.failures;
        }
    }

    private static final class SentinelResource
    implements Resource {
        private SentinelResource() {
        }

        public Resource get() {
            return this;
        }

        public int compareTo(Resource o) {
            return 0;
        }

        public long getResourceId() {
            return 0L;
        }

        public int getThreadHash() {
            return 0;
        }

        public boolean isPersistent() {
            return false;
        }

        public boolean equalsResource(Resource other) {
            return false;
        }
    }
}

