/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;

public class TGRemover
extends AbstractRemover {
    private IProgressMonitor monitor;
    private ArrayList<Resource> roots = new ArrayList();

    public TGRemover(Resource resource) {
        super(resource);
    }

    public TGRemover(IProgressMonitor monitor, Resource resource) {
        super(resource);
        this.monitor = monitor;
    }

    public List<Resource> getRoots() {
        return this.roots;
    }

    @Override
    public void remove(final WriteGraph graph) throws DatabaseException {
        final Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2((ReadGraph)graph, this.resource);
        conf.values = false;
        final SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ModelTransferableGraphSource source = (ModelTransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));){
                final long[] rev = source.getResourceArray((ReadGraph)graph);
                source.forIdentities((ReadGraph)graph, new TransferableGraphSource.TransferableGraphSourceProcedure<Identity>(){

                    public void execute(Identity value) throws Exception {
                        if (value.definition instanceof Internal) {
                            long res = rev[value.resource];
                            Resource r = ss.getResource(res);
                            Resource name = graph.getPossibleObject(r, L0.HasName);
                            if (name != null) {
                                graph.deny(r, L0.HasName, L0.NameOf, name);
                                graph.denyValue(name);
                                for (Statement stm : dqs.getDirectPersistentStatements((ReadGraph)graph, name)) {
                                    graph.deny(name, stm.getPredicate(), stm.getObject());
                                }
                            }
                        } else if (value.definition instanceof Root) {
                            long res = rev[value.resource];
                            Resource r = ss.getResource(res);
                            TGRemover.this.roots.add(r);
                        }
                    }
                });
                source.forResourceStatements((ReadGraph)graph, new TransferableGraphSource.TransferableGraphSourceProcedure<int[]>(){

                    public void execute(int[] value) throws Exception {
                        Resource s = ss.getResource(value[0]);
                        Resource p = ss.getResource(value[1]);
                        Resource i = null;
                        if (value[2] != -1) {
                            i = ss.getResource(value[2]);
                        }
                        Resource o = ss.getResource(value[3]);
                        graph.deny(s, p, i, o);
                    }
                });
                source.forValueResources((ReadGraph)graph, new TransferableGraphSource.TransferableGraphSourceProcedure<int[]>(){

                    public void execute(int[] value) throws Exception {
                        graph.denyValue(ss.getResource(value[0]));
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

