/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.AsyncRead;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.scl.SCLScripts;
import org.simantics.modeling.ui.Activator;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class RunSCLScriptActionFactory
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        return () -> RunSCLScriptActionFactory.runScript((Resource)target);
    }

    public static void runScript(Resource resource) {
        try {
            IStatusLineManager status;
            Session s = Simantics.getSession();
            Layer0 L0 = Layer0.getInstance((RequestProcessor)s);
            String error = SCLScripts.canRunScript((RequestProcessor)s, (Resource)resource);
            IWorkbenchPart part = WorkbenchUtils.getActiveWorkbenchPart();
            IStatusLineManager iStatusLineManager = status = part != null ? WorkbenchUtils.getStatusLine((IWorkbenchPart)part) : null;
            if (error == null) {
                String scriptName = (String)s.syncRequest((AsyncRead)new RelatedValue(resource, L0.HasName, (Binding)Bindings.STRING));
                String text = (String)s.syncRequest((AsyncRead)new RelatedValue(resource, L0.SCLScript_definition, (Binding)Bindings.STRING));
                Pair p = SCLScripts.getOrCreateConsoleCommandSession();
                SCLScripts.runScriptWithProgress((String)scriptName, (String)text, (CommandSession)((CommandSession)p.first), (SCLReportingHandler)((SCLReportingHandler)p.second));
                status.setErrorMessage(null);
            } else if (status != null) {
                status.setErrorMessage(error);
            }
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Failed to run SCL script.", (Throwable)e));
            return;
        }
    }
}

