/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.runtime.DiagramSelectionUpdater;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.modeling.flags.MergeFlags;
import org.simantics.modeling.ui.actions.FlagOperationHandler;
import org.simantics.modeling.ui.actions.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeFlagsHandler
extends FlagOperationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeFlagsHandler.class);

    @Override
    protected void perform(IProgressMonitor monitor, WriteGraph graph, List<Resource> flags, ICanvasContext canvasContext) throws DatabaseException {
        monitor.beginTask(Messages.MergeFlagsHandler_MonitorMergeSelectedFlags, -1);
        MergeFlagsHandler.performMerge(graph, flags, canvasContext);
    }

    public static void performMerge(WriteGraph graph, List<Resource> flags, ICanvasContext canvasContext) throws DatabaseException {
        final String text = MergeFlags.validateForMerge((ReadGraph)graph, flags);
        if (text != null) {
            LOGGER.error(text);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(text);
                }
            });
        } else {
            String result = MergeFlags.merge((WriteGraph)graph, flags);
            if (result != null && !result.isEmpty()) {
                LOGGER.error(result);
            } else if (canvasContext != null) {
                new DiagramSelectionUpdater(canvasContext).setNewSelection(0, Collections.singleton(flags.get(0))).setOneshot(true).track();
            }
        }
    }
}

