/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class TransformedRectangle
implements Shape,
Serializable {
    private static final long serialVersionUID = 5160199078645323706L;
    Rectangle2D rect = new Rectangle2D.Double();
    AffineTransform transform = new AffineTransform();
    AffineTransform inv = new AffineTransform();
    boolean isIdentity = true;
    transient Rectangle2D bounds = null;

    public TransformedRectangle() {
    }

    public TransformedRectangle(Rectangle2D rect) {
        if (rect != null) {
            this.setUntransformedRectangle(rect);
        }
    }

    public TransformedRectangle(Rectangle2D rect, AffineTransform transform) {
        if (rect != null) {
            this.setUntransformedRectangle(rect);
        }
        if (transform != null) {
            this.setTransform(transform);
        }
    }

    public TransformedRectangle(TransformedRectangle src) {
        this.setUntransformedRectangle(src.rect);
        this.setTransform(src.transform);
    }

    public Rectangle2D getUntransformedRectangle() {
        return this.rect;
    }

    public void setUntransformedRectangle(Rectangle2D rect) {
        this.rect.setFrame(rect);
        this.bounds = null;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform.setTransform(transform);
        this.bounds = null;
        this.isIdentity = transform.isIdentity();
        try {
            this.inv = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }

    public void concatenate(AffineTransform transform) {
        this.transform.concatenate(transform);
        this.bounds = null;
        try {
            this.inv = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean contains(Point2D p) {
        if (this.isIdentity) {
            return this.rect.contains(p);
        }
        Point2D newP = this.inv.transform(p, new Point2D.Double());
        return this.rect.contains(newP);
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.isIdentity) {
            return this.rect.contains(x, y);
        }
        Point2D.Double p = new Point2D.Double(x, y);
        this.inv.transform(p, p);
        return this.rect.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        if (this.isIdentity) {
            return this.rect.contains(r);
        }
        Point2D.Double p1 = new Point2D.Double(r.getMinX(), r.getMinY());
        Point2D.Double p2 = new Point2D.Double(r.getMaxX(), r.getMinY());
        Point2D.Double p3 = new Point2D.Double(r.getMaxX(), r.getMaxY());
        Point2D.Double p4 = new Point2D.Double(r.getMinX(), r.getMaxY());
        this.inv.transform(p1, p1);
        this.inv.transform(p2, p2);
        this.inv.transform(p3, p3);
        this.inv.transform(p4, p4);
        return this.rect.contains(p1) && this.rect.contains(p2) && this.rect.contains(p3) && this.rect.contains(p4);
    }

    public boolean contains(TransformedRectangle r) {
        if (this.isIdentity) {
            return r.intersects(this.rect);
        }
        Point2D.Double p1 = new Point2D.Double(r.rect.getMinX(), r.rect.getMinY());
        Point2D.Double p2 = new Point2D.Double(r.rect.getMaxX(), r.rect.getMinY());
        Point2D.Double p3 = new Point2D.Double(r.rect.getMaxX(), r.rect.getMaxY());
        Point2D.Double p4 = new Point2D.Double(r.rect.getMinX(), r.rect.getMaxY());
        r.transform.transform(p1, p1);
        r.transform.transform(p2, p2);
        r.transform.transform(p3, p3);
        r.transform.transform(p4, p4);
        this.inv.transform(p1, p1);
        this.inv.transform(p2, p2);
        this.inv.transform(p3, p3);
        this.inv.transform(p4, p4);
        return this.rect.contains(p1) && this.rect.contains(p2) && this.rect.contains(p3) && this.rect.contains(p4);
    }

    public boolean contains(Shape s) {
        return this.contains(s, Double.MAX_VALUE);
    }

    public boolean contains(Shape s, double flatness) {
        if (s instanceof Rectangle2D) {
            return this.contains((Rectangle2D)s);
        }
        if (s instanceof TransformedRectangle) {
            return this.contains((TransformedRectangle)s);
        }
        PathIterator pi = s.getPathIterator(this.inv, flatness);
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (!(type != 0 && type != 1 || this.rect.contains(coords[0], coords[1]))) {
                return false;
            }
            assert (type != 3 && type != 2);
            pi.next();
        }
        return true;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (this.isIdentity) {
            return this.rect.contains(x, y, w, h);
        }
        return this.contains(new Rectangle2D.Double(x, y, w, h));
    }

    public boolean intersects(Shape s) {
        return this.intersects(s, Double.MAX_VALUE);
    }

    public boolean intersects(Shape s, double flatness) {
        if (s instanceof Rectangle2D) {
            return this.intersects((Rectangle2D)s);
        }
        if (s instanceof TransformedRectangle) {
            return this.intersects((TransformedRectangle)s);
        }
        PathIterator pi = s.getPathIterator(this.inv, flatness);
        double[] pos = new double[2];
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (type == 0) {
                pos[0] = coords[0];
                pos[1] = coords[1];
            }
            assert (type != 3 && type != 2);
            pi.next();
        }
        return true;
    }

    public boolean intersects(TransformedRectangle r) {
        if (this.isIdentity) {
            return r.intersects(this.rect);
        }
        Point2D.Double p1 = new Point2D.Double(this.rect.getMinX(), this.rect.getMinY());
        Point2D.Double p2 = new Point2D.Double(this.rect.getMaxX(), this.rect.getMinY());
        Point2D.Double p3 = new Point2D.Double(this.rect.getMaxX(), this.rect.getMaxY());
        Point2D.Double p4 = new Point2D.Double(this.rect.getMinX(), this.rect.getMaxY());
        AffineTransform at = new AffineTransform(this.transform);
        at.concatenate(r.inv);
        at.transform(p1, p1);
        at.transform(p2, p2);
        at.transform(p3, p3);
        at.transform(p4, p4);
        if (r.rect.contains(p1) && r.rect.contains(p2) && r.rect.contains(p3) && r.rect.contains(p4)) {
            return true;
        }
        if (r.rect.intersectsLine(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX(), ((Point2D)p2).getY()) || r.rect.intersectsLine(((Point2D)p2).getX(), ((Point2D)p2).getY(), ((Point2D)p3).getX(), ((Point2D)p3).getY()) || r.rect.intersectsLine(((Point2D)p3).getX(), ((Point2D)p3).getY(), ((Point2D)p4).getX(), ((Point2D)p4).getY()) || r.rect.intersectsLine(((Point2D)p4).getX(), ((Point2D)p4).getY(), ((Point2D)p1).getX(), ((Point2D)p1).getY())) {
            return true;
        }
        p1 = new Point2D.Double(r.rect.getMinX(), r.rect.getMinY());
        p2 = new Point2D.Double(r.rect.getMaxX(), r.rect.getMinY());
        p3 = new Point2D.Double(r.rect.getMaxX(), r.rect.getMaxY());
        p4 = new Point2D.Double(r.rect.getMinX(), r.rect.getMaxY());
        at = new AffineTransform(r.transform);
        at.concatenate(this.inv);
        at.transform(p1, p1);
        at.transform(p2, p2);
        at.transform(p3, p3);
        at.transform(p4, p4);
        return this.rect.contains(p1) && this.rect.contains(p2) && this.rect.contains(p3) && this.rect.contains(p4);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        if (this.isIdentity) {
            return this.rect.intersects(r);
        }
        Point2D.Double p1 = new Point2D.Double(r.getMinX(), r.getMinY());
        Point2D.Double p2 = new Point2D.Double(r.getMaxX(), r.getMinY());
        Point2D.Double p3 = new Point2D.Double(r.getMaxX(), r.getMaxY());
        Point2D.Double p4 = new Point2D.Double(r.getMinX(), r.getMaxY());
        this.inv.transform(p1, p1);
        this.inv.transform(p2, p2);
        this.inv.transform(p3, p3);
        this.inv.transform(p4, p4);
        if (this.rect.contains(p1) || this.rect.contains(p2) || this.rect.contains(p3) || this.rect.contains(p4)) {
            return true;
        }
        if (this.rect.intersectsLine(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX(), ((Point2D)p2).getY()) || this.rect.intersectsLine(((Point2D)p2).getX(), ((Point2D)p2).getY(), ((Point2D)p3).getX(), ((Point2D)p3).getY()) || this.rect.intersectsLine(((Point2D)p3).getX(), ((Point2D)p3).getY(), ((Point2D)p4).getX(), ((Point2D)p4).getY()) || this.rect.intersectsLine(((Point2D)p4).getX(), ((Point2D)p4).getY(), ((Point2D)p1).getX(), ((Point2D)p1).getY())) {
            return true;
        }
        p1 = new Point2D.Double(this.rect.getMinX(), this.rect.getMinY());
        p2 = new Point2D.Double(this.rect.getMaxX(), this.rect.getMinY());
        p3 = new Point2D.Double(this.rect.getMaxX(), this.rect.getMaxY());
        p4 = new Point2D.Double(this.rect.getMinX(), this.rect.getMaxY());
        this.transform.transform(p1, p1);
        this.transform.transform(p2, p2);
        this.transform.transform(p3, p3);
        this.transform.transform(p4, p4);
        return r.contains(p1) || r.contains(p2) || r.contains(p3) || r.contains(p4);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (this.isIdentity) {
            return this.rect.intersects(x, y, w, h);
        }
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public Rectangle getBounds() {
        if (this.isIdentity) {
            return this.rect.getBounds();
        }
        Rectangle2D b = this.getOrCreateBounds();
        return new Rectangle((int)Math.floor(b.getMinX()), (int)Math.floor(b.getMinY()), (int)Math.ceil(b.getWidth()), (int)Math.ceil(b.getHeight()));
    }

    @Override
    public Rectangle2D getBounds2D() {
        if (this.isIdentity) {
            return this.rect;
        }
        return this.getOrCreateBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        if (this.isIdentity) {
            return this.rect.getPathIterator(at);
        }
        if (at == null || at.isIdentity()) {
            return this.rect.getPathIterator(this.transform);
        }
        AffineTransform con = new AffineTransform(this.transform);
        con.preConcatenate(at);
        return this.rect.getPathIterator(con);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        if (this.isIdentity) {
            return this.rect.getPathIterator(at, flatness);
        }
        if (at == null || at.isIdentity()) {
            return this.rect.getPathIterator(this.transform, flatness);
        }
        AffineTransform con = new AffineTransform(this.transform);
        con.concatenate(at);
        return this.rect.getPathIterator(con, flatness);
    }

    Rectangle2D getOrCreateBounds() {
        if (this.bounds == null) {
            this.bounds = TransformedRectangle.transformRectangle(this.transform, this.rect);
        }
        return this.bounds;
    }

    static Rectangle2D transformRectangle(AffineTransform transform, Rectangle2D rect) {
        double Y1;
        double Y0;
        double X1;
        double X0;
        double x0 = rect.getMinX();
        double y0 = rect.getMinY();
        double x1 = rect.getMaxX();
        double y1 = rect.getMaxY();
        double m00 = transform.getScaleX();
        double m10 = transform.getShearY();
        double m01 = transform.getShearX();
        double m11 = transform.getScaleY();
        if (m00 > 0.0) {
            X0 = m00 * x0;
            X1 = m00 * x1;
        } else {
            X1 = m00 * x0;
            X0 = m00 * x1;
        }
        if (m01 > 0.0) {
            X0 += m01 * y0;
            X1 += m01 * y1;
        } else {
            X1 += m01 * y0;
            X0 += m01 * y1;
        }
        if (m10 > 0.0) {
            Y0 = m10 * x0;
            Y1 = m10 * x1;
        } else {
            Y1 = m10 * x0;
            Y0 = m10 * x1;
        }
        if (m11 > 0.0) {
            Y0 += m11 * y0;
            Y1 += m11 * y1;
        } else {
            Y1 += m11 * y0;
            Y0 += m11 * y1;
        }
        return new Rectangle2D.Double(X0 + transform.getTranslateX(), Y0 + transform.getTranslateY(), X1 - X0, Y1 - Y0);
    }

    public String toString() {
        Point2D.Double p1 = new Point2D.Double(this.rect.getMinX(), this.rect.getMinY());
        Point2D.Double p2 = new Point2D.Double(this.rect.getMaxX(), this.rect.getMinY());
        Point2D.Double p3 = new Point2D.Double(this.rect.getMaxX(), this.rect.getMaxY());
        Point2D.Double p4 = new Point2D.Double(this.rect.getMinX(), this.rect.getMaxY());
        this.transform.transform(p1, p1);
        this.transform.transform(p2, p2);
        this.transform.transform(p3, p3);
        this.transform.transform(p4, p4);
        StringBuilder sb = new StringBuilder();
        sb.append(p1 + "\n");
        sb.append(p2 + "\n");
        sb.append(p3 + "\n");
        sb.append(p4);
        return sb.toString();
    }

    public static void main(String[] args) {
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        AffineTransform at = new AffineTransform();
        at.setToRotation(0.7853981633974483);
        TransformedRectangle tr = new TransformedRectangle(rect, at);
        Rectangle2D.Double t1 = new Rectangle2D.Double(5.0, 5.0, 5.0, 5.0);
        Rectangle2D.Double t2 = new Rectangle2D.Double(-2.0, 4.0, 3.0, 2.0);
        Rectangle2D.Double t3 = new Rectangle2D.Double(9.0, 9.0, 5.0, 5.0);
        Rectangle2D.Double t4 = new Rectangle2D.Double(-100.0, -100.0, 200.0, 200.0);
        assert (!tr.contains(t1));
        assert (tr.contains(t2));
        assert (!tr.contains(t3));
        assert (!tr.contains(t4));
        assert (tr.intersects(t1));
        assert (tr.intersects(t2));
        assert (!tr.intersects(t3));
        assert (tr.intersects(t4));
        Ellipse2D.Double e = new Ellipse2D.Double(-5.0, 0.0, 10.0, 10.0);
        assert (tr.intersects(e));
        assert (!tr.contains(e));
        TransformedRectangle tr1 = new TransformedRectangle(t4, at);
        TransformedRectangle tr2 = new TransformedRectangle(new Rectangle2D.Double(3.0, 3.0, 2.0, 2.0), at);
        TransformedRectangle tr3 = new TransformedRectangle(new Rectangle2D.Double(-20.0, 3.0, 40.0, 3.0), at);
        TransformedRectangle tr4 = new TransformedRectangle(new Rectangle2D.Double(8.0, -6.0, 4.0, 8.0), at);
        TransformedRectangle tr5 = new TransformedRectangle(new Rectangle2D.Double(2.0, 12.0, 7.0, 7.0), at);
        assert (!tr.contains(tr1));
        assert (tr.contains(tr2));
        assert (!tr.contains(tr3));
        assert (!tr.contains(tr4));
        assert (!tr.contains(tr5));
        assert (tr1.contains(tr));
        assert (!tr2.contains(tr));
        assert (!tr3.contains(tr));
        assert (!tr4.contains(tr));
        assert (!tr5.contains(tr));
        assert (tr.intersects(tr1));
        assert (tr.intersects(tr2));
        assert (tr.intersects(tr3));
        assert (tr.intersects(tr4));
        assert (!tr.intersects(tr5));
        assert (false);
    }
}

