/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.simantics.scenegraph.IDynamicSelectionPainterNode;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.GridNode;
import org.simantics.scenegraph.g2d.nodes.IPathListener;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.PathNodeStyle;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class PathNode
extends G2DNode
implements IDynamicSelectionPainterNode {
    private static final long serialVersionUID = 8508750881358776559L;
    private static final Double PICK_DISTANCE = 5.0;
    private BasicStroke stroke;
    private Path2D path = new Path2D.Double();
    private boolean dirtyPath = true;
    private ArrayList<Point2D> points;
    private IPathListener pathListener;
    private Point2D dragKeyPoint = null;
    private Point2D selectedKeyPoint = null;
    private Point2D hoverKeyPoint = null;
    private Point2D pressKeyPoint = null;
    private Integer pressSegment = null;
    private double mouseX;
    private double mouseY;
    private boolean closed;
    private boolean align = false;
    private Color fill;
    private Color color;

    public void init(ArrayList<Point2D> points, boolean closed) {
        if (!points.equals(this.points) || closed != this.closed) {
            this.points = points;
            this.closed = closed;
            if (points.isEmpty()) {
                points.add(new Point2D.Double(0.0, 0.0));
            }
            if (points.size() == 1) {
                this.closed = false;
            }
            this.resetEditingState();
            this.dirtyPath = true;
            this.repaint();
        }
    }

    public void setStyle(PathNodeStyle style) {
        float[] color = style.getColor();
        this.color = new Color(color[0], color[1], color[2], color[3]);
        float[] fill = style.getFillColor();
        this.fill = new Color(fill[0], fill[1], fill[2], fill[3]);
        this.stroke = new BasicStroke(style.getStrokeWidth(), 2, 0, 5.0f, null, 0.0f);
        this.repaint();
    }

    private void resetEditingState() {
        this.dragKeyPoint = null;
        this.selectedKeyPoint = null;
        this.hoverKeyPoint = null;
        this.pressKeyPoint = null;
        this.pressSegment = null;
    }

    public void setPathListener(IPathListener pathListener) {
        this.pathListener = pathListener;
    }

    private void flushChanges() {
        if (this.pathListener != null) {
            this.pathListener.pathChanged(this.points, this.closed);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Shape getShape() {
        return this.path;
    }

    private void updatePath() {
        this.dirtyPath = false;
        this.path.reset();
        Iterator<Point2D> it = this.points.iterator();
        if (!it.hasNext()) {
            this.path.moveTo(0.0, 0.0);
            return;
        }
        Point2D first = it.next();
        this.path.moveTo(first.getX(), first.getY());
        while (it.hasNext()) {
            Point2D lineTo = it.next();
            this.path.lineTo(lineTo.getX(), lineTo.getY());
        }
        if (this.closed) {
            this.path.closePath();
        }
    }

    private double calculateScale() {
        NavigationNode nn = NodeUtil.findNearestParentNode(this, NavigationNode.class);
        double scale = 1.0;
        if (nn != null) {
            AffineTransform copy = (AffineTransform)this.transform.clone();
            copy.concatenate(nn.getTransform());
            scale = GeometryUtils.getScale(copy);
        }
        return scale;
    }

    private void resolveTransformation(INode n, AffineTransform T) {
        ParentNode<?> p = n.getParent();
        if (!(p instanceof NavigationNode) && p != null) {
            this.resolveTransformation(p, T);
        }
        if (n instanceof G2DParentNode) {
            T.concatenate(((G2DParentNode)n).getTransform());
        }
    }

    private Point2D snap(Point2D point) {
        GridNode grid = this.lookupNode("grid", GridNode.class);
        if (this.align) {
            Point2D ref = null;
            if (this.selectedKeyPoint != null) {
                ref = this.selectedKeyPoint;
            } else if (this.points.size() > 1) {
                if (this.dragKeyPoint == this.points.get(0) && !this.closed) {
                    ref = this.points.get(1);
                } else if (this.dragKeyPoint == this.points.get(this.points.size() - 1) && !this.closed) {
                    ref = this.points.get(this.points.size() - 2);
                } else if (this.points.size() > 2) {
                    int i = this.points.indexOf(this.dragKeyPoint);
                    point = this.snap2(point, this.points.get(Math.floorMod(i - 1, this.points.size())), this.points.get((i + 1) % this.points.size()));
                }
            }
            if (ref != null) {
                double angle = Math.atan2(point.getY() - ref.getY(), point.getX() - ref.getX());
                double distance = ref.distance(point);
                angle = (double)Math.round(angle / 0.7853981633974483) * 0.7853981633974483;
                point.setLocation(ref.getX() + distance * Math.cos(angle), ref.getY() + distance * Math.sin(angle));
            }
        }
        if (grid != null) {
            ISnapAdvisor snapAdvisor = grid.getSnapAdvisor();
            AffineTransform t = this.transform;
            this.resolveTransformation(this, this.transform);
            Point2D p = t.transform(point, null);
            snapAdvisor.snap(p);
            try {
                return t.inverseTransform(p, null);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return point;
            }
        }
        return point;
    }

    private Point2D snap2(Point2D point, Point2D ref1, Point2D ref2) {
        double minDistanceSq = Double.MAX_VALUE;
        Point2D.Double result = new Point2D.Double();
        int a1 = 0;
        while (a1 < 8) {
            int a2 = 0;
            while (a2 < 8) {
                if (a1 % 4 != a2 % 4) {
                    double y;
                    double denom;
                    double x1 = ref1.getX();
                    double y1 = ref1.getY();
                    double x2 = x1 + Math.cos((double)a1 * Math.PI / 4.0);
                    double y2 = y1 + Math.sin((double)a1 * Math.PI / 4.0);
                    double x3 = ref2.getX();
                    double y3 = ref2.getY();
                    double x4 = x3 + Math.cos((double)a2 * Math.PI / 4.0);
                    double y4 = y3 + Math.sin((double)a2 * Math.PI / 4.0);
                    double t = ((x1 - x3) * (y3 - y4) - (y1 - y3) * (x3 - x4)) / (denom = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
                    double x = x1 + t * (x2 - x1);
                    double distanceSq = point.distanceSq(x, y = y1 + t * (y2 - y1));
                    if (distanceSq < minDistanceSq) {
                        minDistanceSq = distanceSq;
                        ((Point2D)result).setLocation(x, y);
                    }
                }
                ++a2;
            }
            ++a1;
        }
        return result;
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.dirtyPath) {
            this.updatePath();
        }
        AffineTransform ot = g2d.getTransform();
        g2d.transform(this.transform);
        g2d.setStroke(this.stroke);
        if (this.closed) {
            g2d.setColor(this.fill);
            g2d.fill(this.path);
        }
        g2d.setColor(this.color);
        g2d.draw(this.path);
        if (this.selectedKeyPoint != null) {
            g2d.setColor(Color.RED);
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(this.selectedKeyPoint.getX(), this.selectedKeyPoint.getY());
            Point2D mouse = this.snap(new Point2D.Double(this.mouseX, this.mouseY));
            ((Path2D)path).lineTo(mouse.getX(), mouse.getY());
            g2d.draw(path);
        }
        if (NodeUtil.isSelected(this, 1) || this.points.size() == 1) {
            this.drawKeyPoints(g2d, this.path, this.points.size() > 1 || NodeUtil.isSelected(this, 1) ? Color.BLUE : Color.BLACK);
        }
        g2d.setTransform(ot);
    }

    private Point2D pickKeyPoint(double x, double y, double tolerance) {
        Point2D best = null;
        double minDistanceSq = Double.MAX_VALUE;
        double toleranceSq = tolerance * tolerance;
        int i = 0;
        while (i < this.points.size()) {
            Point2D point = this.points.get(i);
            double distanceSq = point.distanceSq(x, y);
            if (distanceSq < toleranceSq && distanceSq < minDistanceSq) {
                minDistanceSq = distanceSq;
                best = point;
            }
            ++i;
        }
        return best;
    }

    public boolean intersectsOutline(AffineTransform t, Rectangle2D rect) {
        if (this.points.size() > 1) {
            int i = 0;
            while (i < this.points.size() - (this.closed ? 0 : 1)) {
                Point2D point1 = this.points.get(i);
                Point2D point2 = this.points.get((i + 1) % this.points.size());
                Line2D.Double line = new Line2D.Double(t.transform(point1, null), t.transform(point2, null));
                if (line.intersects(rect)) {
                    return true;
                }
                ++i;
            }
        } else {
            Point2D point1 = t.transform(this.points.get(0), null);
            return rect.contains(point1);
        }
        return false;
    }

    private Integer pickSegment(double x, double y, double tolerance) {
        Integer best = null;
        double minDistanceSq = Double.MAX_VALUE;
        double toleranceSq = tolerance * tolerance;
        int i = 0;
        while (i < this.points.size() - (this.closed ? 0 : 1)) {
            Point2D point1 = this.points.get(i);
            Point2D point2 = this.points.get((i + 1) % this.points.size());
            double distanceSq = Line2D.ptSegDistSq(point1.getX(), point1.getY(), point2.getX(), point2.getY(), x, y);
            if (distanceSq < toleranceSq && distanceSq < minDistanceSq) {
                minDistanceSq = distanceSq;
                best = i;
            }
            ++i;
        }
        return best;
    }

    private Point2D addKeyPoint(int pos, double x, double y) {
        Point2D point = this.snap(new Point2D.Double(x, y));
        this.points.add(pos, point);
        this.dirtyPath = true;
        this.flushChanges();
        return point;
    }

    private void removeKeyPoint(Path2D path, Point2D point) {
        if (this.points.remove(point)) {
            if (this.closed && this.points.size() == 1) {
                this.closed = false;
            }
            this.dirtyPath = true;
            this.flushChanges();
        }
    }

    private void moveKeyPoint(Point2D point, double x, double y) {
        Point2D target = this.snap(new Point2D.Double(x, y));
        point.setLocation(target.getX(), target.getY());
        this.dirtyPath = true;
    }

    private void drawKeyPoints(Graphics2D g2d, Path2D path, Color color) {
        double scale = this.calculateScale();
        double r = PICK_DISTANCE / scale;
        g2d.setStroke(new BasicStroke((float)(2.0 / scale), 2, 0, 10.0f, null, 0.0f));
        for (Point2D point : this.points) {
            g2d.setColor(point == this.selectedKeyPoint ? Color.RED : color);
            Ellipse2D.Double e = new Ellipse2D.Double(point.getX() - r, point.getY() - r, r * 2.0, r * 2.0);
            g2d.draw(e);
            if (this.hoverKeyPoint != point) continue;
            g2d.fill(e);
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.dirtyPath) {
            this.updatePath();
        }
        if (this.path == null) {
            return null;
        }
        return this.path.getBounds2D();
    }

    @Override
    protected boolean mouseDoubleClicked(MouseEvent.MouseDoubleClickedEvent event) {
        double y;
        if (event.button != 1) {
            return false;
        }
        Point2D localPos = this.getMousePosition(event);
        double x = localPos.getX();
        Point2D point = this.pickKeyPoint(x, y = localPos.getY(), PICK_DISTANCE / this.calculateScale());
        if (point != null) {
            if (this.points.size() > 1) {
                if (point == this.selectedKeyPoint) {
                    this.selectedKeyPoint = null;
                }
                this.removeKeyPoint(this.path, point);
                this.repaint();
            }
            return true;
        }
        return false;
    }

    private Point2D getPosition(Point2D controlPosition) {
        Point2D localPos = NodeUtil.worldToLocal(this, controlPosition, new Point2D.Double());
        Point2D.Double result = new Point2D.Double();
        try {
            this.transform.createInverse().transform(localPos, result);
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    private Point2D getMousePosition(MouseEvent e) {
        return this.getPosition(e.controlPosition);
    }

    @Override
    protected boolean mouseDragged(MouseEvent.MouseDragBegin event) {
        if (!NodeUtil.isSelected(this, 1)) {
            return false;
        }
        if (this.selectedKeyPoint != null) {
            return true;
        }
        if (event.button != 1) {
            return false;
        }
        if (event.button == 1 && this.selectedKeyPoint != null) {
            return true;
        }
        Point2D localPos = this.getMousePosition(event);
        double x = localPos.getX();
        double y = localPos.getY();
        this.dragKeyPoint = this.pickKeyPoint(x, y, PICK_DISTANCE / this.calculateScale());
        return this.dragKeyPoint != null;
    }

    @Override
    protected boolean mouseMoved(MouseEvent.MouseMovedEvent event) {
        if (!NodeUtil.isSelected(this, 1)) {
            return false;
        }
        this.align = event.isControlDown();
        if (this.dragKeyPoint != null) {
            Point2D localPos = this.snap(this.getMousePosition(event));
            double x = localPos.getX();
            double y = localPos.getY();
            this.moveKeyPoint(this.dragKeyPoint, x, y);
            this.repaint();
            return true;
        }
        Point2D localPos = this.getMousePosition(event);
        this.mouseX = localPos.getX();
        this.mouseY = localPos.getY();
        Point2D pick = this.pickKeyPoint(this.mouseX, this.mouseY, PICK_DISTANCE / this.calculateScale());
        if (this.selectedKeyPoint == null || pick == this.points.get(0) || pick == this.points.get(this.points.size() - 1)) {
            if (this.hoverKeyPoint != pick) {
                this.hoverKeyPoint = pick;
                this.repaint();
            }
        } else if (this.hoverKeyPoint != null) {
            this.hoverKeyPoint = null;
            this.repaint();
        }
        if (this.selectedKeyPoint != null) {
            this.repaint();
        }
        return false;
    }

    @Override
    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent event) {
        Point2D localPos = this.getMousePosition(event);
        double x = localPos.getX();
        double y = localPos.getY();
        this.pressKeyPoint = this.pickKeyPoint(x, y, PICK_DISTANCE / this.calculateScale());
        this.pressSegment = this.pickSegment(x, y, PICK_DISTANCE / this.calculateScale());
        return this.pressKeyPoint != null || this.pressSegment != null;
    }

    @Override
    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent event) {
        Integer segment;
        double y;
        if (!NodeUtil.isSelected(this, 1)) {
            return false;
        }
        if (this.dragKeyPoint != null) {
            this.dragKeyPoint = null;
            this.flushChanges();
            return true;
        }
        if (event.button == 2) {
            if (this.selectedKeyPoint != null) {
                this.selectedKeyPoint = null;
                this.repaint();
            }
            return false;
        }
        if (event.button == 3) {
            return false;
        }
        Point2D localPos = this.getMousePosition(event);
        double x = localPos.getX();
        Point2D pick = this.pickKeyPoint(x, y = localPos.getY(), PICK_DISTANCE / this.calculateScale());
        if (pick != null && pick == this.selectedKeyPoint) {
            this.selectedKeyPoint = null;
            this.repaint();
            return true;
        }
        if (pick != null && (pick == this.points.get(0) || pick == this.points.get(this.points.size() - 1)) && pick != this.selectedKeyPoint && this.selectedKeyPoint != null) {
            this.selectedKeyPoint = null;
            this.closed = true;
            this.flushChanges();
            this.dirtyPath = true;
            this.repaint();
            return true;
        }
        if (!(this.closed || pick == null || pick != this.points.get(0) && pick != this.points.get(this.points.size() - 1))) {
            this.selectedKeyPoint = pick;
            this.repaint();
            return true;
        }
        if (this.selectedKeyPoint != null) {
            this.selectedKeyPoint = this.selectedKeyPoint == this.points.get(this.points.size() - 1) ? this.addKeyPoint(this.points.size(), x, y) : this.addKeyPoint(0, x, y);
            this.repaint();
            return true;
        }
        if (pick == null && this.pressKeyPoint == null && (segment = this.pickSegment(x, y, PICK_DISTANCE / this.calculateScale())) != null && segment == this.pressSegment) {
            this.addKeyPoint(segment + 1, x, y);
        }
        return false;
    }

    @Override
    protected boolean mouseClicked(MouseEvent.MouseClickEvent event) {
        if (!NodeUtil.isSelected(this, 1)) {
            return false;
        }
        return this.selectedKeyPoint != null || this.dragKeyPoint != null || this.pressKeyPoint != null || this.pressSegment != null;
    }

    @Override
    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        if (!NodeUtil.isSelected(this, 1)) {
            return false;
        }
        if (e.keyCode == 27 && (this.dragKeyPoint != null || this.selectedKeyPoint != null)) {
            if (this.dragKeyPoint != null) {
                this.dragKeyPoint = null;
                this.flushChanges();
            }
            if (this.selectedKeyPoint != null) {
                this.selectedKeyPoint = null;
                this.repaint();
            }
            return true;
        }
        return false;
    }

    @Override
    public int getEventMask() {
        return EventTypes.KeyPressedMask | EventTypes.MouseMovedMask | EventTypes.MouseButtonPressedMask | EventTypes.MouseButtonReleasedMask | EventTypes.MouseClickMask | EventTypes.MouseDoubleClickMask | EventTypes.MouseDragBeginMask;
    }

    @Override
    public void init() {
        super.init();
        this.addEventHandler(this);
    }

    @Override
    public void cleanup() {
        this.removeEventHandler(this);
        super.cleanup();
    }

    @Override
    public boolean showsSelection() {
        return true;
    }
}

