/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class BoxSelectionNode
extends G2DNode {
    private static final long serialVersionUID = 8508750881358776559L;
    protected Stroke stroke = new BasicStroke(2.0f);
    protected Color color = Color.BLACK;
    protected boolean scaleStroke = false;
    protected int mouseButton = 0;
    protected Point2D start = new Point2D.Double(0.0, 0.0);
    protected Point2D end = new Point2D.Double(0.0, 0.0);
    protected SelectionListener listener = null;

    @Override
    public void init() {
        super.init();
        this.addEventHandler(this);
    }

    @Override
    public void cleanup() {
        this.removeEventHandler(this);
        super.cleanup();
    }

    @INode.SyncField(value={"stroke"})
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
    }

    @INode.SyncField(value={"scaleStroke"})
    public void setScaleStroke(boolean scaleStroke) {
        this.scaleStroke = scaleStroke;
    }

    @INode.SyncField(value={"start"})
    public void setStart(Point2D start) {
        this.start = start;
    }

    @INode.SyncField(value={"end"})
    public void setEnd(Point2D end) {
        this.end = end;
    }

    @INode.SyncField(value={"mouseButton"})
    public void setMouseButton(int mouseButton) {
        this.mouseButton = mouseButton;
    }

    @Override
    public void render(Graphics2D g2d) {
        Rectangle2D bounds = this.getBoundsInLocal();
        if (bounds == null || bounds.isEmpty()) {
            return;
        }
        if (this.color != null) {
            g2d.setColor(this.color);
        }
        if (this.stroke != null) {
            if (this.scaleStroke && this.stroke instanceof BasicStroke) {
                BasicStroke bs = GeometryUtils.scaleStroke(this.stroke, (float)(1.0 / GeometryUtils.getScale(g2d.getTransform())));
                g2d.setStroke(bs);
            } else {
                g2d.setStroke(this.stroke);
            }
        }
        g2d.draw(bounds);
    }

    public void setSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    @INode.ServerSide
    private void onSelect(Rectangle2D selection, int modifiers) {
        if (this.listener != null) {
            this.listener.onSelect(selection, modifiers);
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.start == null || this.end == null) {
            return new Rectangle2D.Double();
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(Math.min(this.start.getX(), this.end.getX()), Math.min(this.start.getY(), this.end.getY()), Math.max(this.start.getX(), this.end.getX()) - Math.min(this.start.getX(), this.end.getX()), Math.max(this.start.getY(), this.end.getY()) - Math.min(this.start.getY(), this.end.getY()));
        return rect;
    }

    @Override
    public int getEventMask() {
        return EventTypes.MouseButtonReleasedMask | EventTypes.MouseDragBeginMask | EventTypes.MouseMovedMask;
    }

    @Override
    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        if (e.button == this.mouseButton) {
            this.onSelect(this.getBoundsInLocal(), e.stateMask);
            this.start = null;
            this.end = null;
        }
        return false;
    }

    @Override
    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        if (this.end != null) {
            NodeUtil.worldToLocal(this, e.controlPosition, this.end);
            this.repaint();
        }
        return true;
    }

    public static interface SelectionListener {
        public void onSelect(Rectangle2D var1, int var2);
    }
}

