/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbollibrary.ui;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.diagram.internal.Activator;
import org.simantics.diagram.symbollibrary.IModifiableSymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolGroupListener;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.diagram.symbollibrary.ISymbolManager;
import org.simantics.diagram.symbollibrary.ui.FilterArea;
import org.simantics.diagram.symbollibrary.ui.FilterConfiguration;
import org.simantics.diagram.symbollibrary.ui.FilterDialog;
import org.simantics.diagram.symbollibrary.ui.GroupFilter;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.diagram.synchronization.LogErrorHandler;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.layout.FlowLayout;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.dnd.IDragSourceParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.gallery.GalleryViewer;
import org.simantics.g2d.gallery.ILabelProvider;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ImageProxy;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.HintTracker;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.StringMemento;

public class SymbolLibraryView
extends ViewPart {
    private static final String SYMBOL_LIBRARY_CONTEXT = "org.simantics.diagram.symbolLibrary";
    private static final String PREF_FILTERS = "filters";
    private static final String TAG_FILTER_MODE = "filterMode";
    private static final String TAG_FILTER = "filter";
    private static final String ATTR_ACTIVE = "active";
    private static final String ATTR_FILTER_TEXT = "filterText";
    private static final String ATTR_NAME = "name";
    private static final int FILTER_DELAY = 500;
    private static final String KEY_VIEWER_INITIALIZED = "viewer.initialized";
    private static final String KEY_USER_EXPANDED = "userExpanded";
    private static final String KEY_GROUP_FILTERED = "groupFiltered";
    ScrolledComposite sc;
    Composite c;
    ISessionContextProvider sessionCtxProvider;
    IThreadWorkQueue swtThread;
    boolean defaultExpanded = false;
    AtomicInteger loadCount = new AtomicInteger();
    Map<ISymbolGroup, PGroup> groups = new HashMap<ISymbolGroup, PGroup>();
    Map<ISymbolGroup, GalleryViewer> groupViewers = new HashMap<ISymbolGroup, GalleryViewer>();
    LocalResourceManager resourceManager;
    FilterArea filter;
    ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Symbol Library Loader");
            t.setDaemon(false);
            t.setPriority(5);
            return t;
        }
    };
    Semaphore loaderSemaphore = new Semaphore(1);
    ExecutorService loaderExecutor = Executors.newCachedThreadPool(this.threadFactory);
    Map<ISymbolItem, SoftReference<ImageProxy>> imageCache = new WeakHashMap<ISymbolItem, SoftReference<ImageProxy>>();
    static final Pattern ANY = Pattern.compile(".*");
    Pattern currentFilterPattern = ANY;
    FilterConfiguration config = new FilterConfiguration();
    IFilter currentGroupFilter = AcceptAllFilter.getInstance();
    ErrorHandler errorHandler = LogErrorHandler.INSTANCE;
    Comparator<GroupDescriptor> groupComparator = new Comparator<GroupDescriptor>(){

        @Override
        public int compare(GroupDescriptor o1, GroupDescriptor o2) {
            return o1.label.compareToIgnoreCase(o2.label);
        }
    };
    static final EnumSet<Image.Feature> VOLATILE = EnumSet.of(Image.Feature.Volatile);
    ProjectTracker projectTracker = new ProjectTracker();
    SessionContextTracker sessionContextTracker = new SessionContextTracker();
    ExpandListener groupExpandListener = new ExpandListener(){

        public void itemCollapsed(ExpandEvent e) {
            PGroup group = (PGroup)e.widget;
            group.setData(SymbolLibraryView.KEY_USER_EXPANDED, (Object)Boolean.FALSE);
            SymbolLibraryView.this.refreshScrolledComposite();
        }

        public void itemExpanded(ExpandEvent e) {
            PGroup group = (PGroup)e.widget;
            group.setData(SymbolLibraryView.KEY_USER_EXPANDED, (Object)Boolean.TRUE);
            final GalleryViewer viewer = SymbolLibraryView.this.initializeGroup(group);
            if (viewer == null) {
                return;
            }
            ThreadUtils.asyncExec((IThreadWorkQueue)SymbolLibraryView.this.swtThread, (Runnable)new Runnable(){

                @Override
                public void run() {
                    viewer.refresh();
                    SymbolLibraryView.this.refreshScrolledComposite();
                }
            });
        }
    };
    Runnable filterActivator = new Runnable(){

        @Override
        public void run() {
            SymbolLibraryView.this.filter.focus();
        }
    };
    Listener filterActivationListener = new Listener(){

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            SymbolLibraryView.this.filterActivator.run();
        }
    };
    ISymbolGroupListener groupListener = new ISymbolGroupListener(){

        @Override
        public void itemsChanged(ISymbolGroup group) {
            GalleryViewer viewer = SymbolLibraryView.this.groupViewers.get(group);
            if (viewer != null) {
                ISymbolItem[] input = group.getItems();
                viewer.setInput((Object)input);
            }
        }
    };

    void attachToSession() {
        this.sessionCtxProvider = SimanticsUI.getSessionContextProvider((Object)this.getViewSite().getWorkbenchWindow());
        this.sessionCtxProvider.addContextChangedListener((ISessionContextChangedListener)this.sessionContextTracker);
        this.sessionContextTracker.track((IHintContext)this.sessionCtxProvider.getSessionContext());
    }

    public void readPreferences() {
        FilterConfiguration config = new FilterConfiguration();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.simantics.diagram");
        String filters = prefs.get(PREF_FILTERS, null);
        if (filters != null) {
            StringMemento memento = new StringMemento(filters);
            IMemento[] iMementoArray = memento.getChildren(TAG_FILTER);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String name = child.getString(ATTR_NAME);
                String filterText = child.getString(ATTR_FILTER_TEXT);
                boolean active = Boolean.TRUE.equals(child.getBoolean(ATTR_ACTIVE));
                if (name != null && !name.trim().isEmpty() && filterText != null && !filterText.isEmpty()) {
                    config.getFilters().add(new GroupFilter(name, filterText, active));
                }
                ++n2;
            }
            Collections.sort(config.getFilters());
            String filterMode = memento.getString(TAG_FILTER_MODE);
            if (filterMode != null) {
                try {
                    FilterConfiguration.Mode mode = FilterConfiguration.Mode.valueOf(filterMode);
                    config.setMode(mode);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        this.updateFilterConfiguration(config);
    }

    void savePreferences() throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.simantics.diagram");
        StringMemento memento = new StringMemento();
        for (GroupFilter f : this.config.getFilters()) {
            IMemento child = memento.createChild(TAG_FILTER);
            child.putString(ATTR_NAME, f.getName());
            child.putString(ATTR_FILTER_TEXT, f.getFilterText());
            child.putBoolean(ATTR_ACTIVE, f.isActive());
        }
        memento.putString(TAG_FILTER_MODE, this.config.getMode().toString());
        prefs.put(PREF_FILTERS, memento.toString());
        prefs.flush();
    }

    public void createPartControl(Composite parent) {
        DefaultImages.HOURGLASS.get();
        this.readPreferences();
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)parent);
        this.swtThread = SWTThread.getThreadAccess((Widget)parent);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        this.filter = new FilterArea(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filter);
        this.filter.getText().addModifyListener(new ModifyListener(){
            int modCount = 0;

            public void modifyText(ModifyEvent e) {
                this.scheduleDelayedFilter(500L, TimeUnit.MILLISECONDS);
            }

            private void scheduleDelayedFilter(long filterDelay, TimeUnit delayUnit) {
                final String text = SymbolLibraryView.this.filter.getText().getText();
                final int count = ++this.modCount;
                ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        int newCount = modCount;
                        if (newCount != count) {
                            return;
                        }
                        ThreadUtils.asyncExec((IThreadWorkQueue)(this).SymbolLibraryView.this.swtThread, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (((this).this).SymbolLibraryView.this.sc.isDisposed()) {
                                    return;
                                }
                                if (!SymbolLibraryView.this.filterGroups(text)) {
                                    this.scheduleDelayedFilter(100L, TimeUnit.MILLISECONDS);
                                }
                            }
                        });
                    }
                }, filterDelay, delayUnit);
            }
        });
        this.sc = new ScrolledComposite(parent, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        this.sc.setAlwaysShowScrollBars(false);
        this.sc.setExpandHorizontal(false);
        this.sc.setExpandVertical(false);
        this.sc.getVerticalBar().setIncrement(30);
        this.sc.getVerticalBar().setPageIncrement(200);
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SymbolLibraryView.this.refreshScrolledComposite();
            }
        });
        this.c = new Composite((Composite)this.sc, 0);
        this.c.setVisible(false);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.c);
        this.sc.setContent((Control)this.c);
        this.c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SymbolLibraryView.this.sessionContextTracker.untrack();
                SymbolLibraryView.this.projectTracker.untrack();
                SymbolLibraryView.this.loaderExecutor.shutdown();
            }
        });
        this.contributeActions();
        this.attachToSession();
        IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
        cs.activateContext(SYMBOL_LIBRARY_CONTEXT);
    }

    public void dispose() {
        if (this.sessionCtxProvider != null) {
            this.sessionCtxProvider.removeContextChangedListener((ISessionContextChangedListener)this.sessionContextTracker);
            this.sessionCtxProvider = null;
        }
    }

    void refreshScrolledComposite() {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SymbolLibraryView.this.sc.isDisposed()) {
                    return;
                }
                SymbolLibraryView.this.syncRefreshScrolledComposite();
            }
        });
    }

    void syncRefreshScrolledComposite() {
        Rectangle r = this.sc.getClientArea();
        Point contentSize = this.c.computeSize(r.width, -1);
        this.c.setSize(contentSize);
    }

    void load(Collection<ISymbolGroup> _libraries) {
        if (_libraries == null) {
            _libraries = Collections.emptyList();
        }
        final Collection<ISymbolGroup> libraries = _libraries;
        this.loaderExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Integer loadId = SymbolLibraryView.this.loadCount.incrementAndGet();
                try {
                    SymbolLibraryView.this.loaderSemaphore.acquire();
                    this.beginPopulate(loadId);
                }
                catch (InterruptedException e) {
                    ExceptionUtils.logError((Throwable)e);
                }
                catch (RuntimeException e) {
                    SymbolLibraryView.this.loaderSemaphore.release();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
                catch (Error e) {
                    SymbolLibraryView.this.loaderSemaphore.release();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void beginPopulate(Integer loadId) {
                Map<ISymbolGroup, PGroup> map = SymbolLibraryView.this.groups;
                synchronized (map) {
                    Iterator<Map.Entry<ISymbolGroup, PGroup>> it = SymbolLibraryView.this.groups.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<ISymbolGroup, PGroup> entry = it.next();
                        if (libraries.contains(entry.getKey())) continue;
                        PGroup group = entry.getValue();
                        it.remove();
                        SymbolLibraryView.this.groupViewers.remove(entry.getKey());
                        if (group == null || group.isDisposed()) continue;
                        ThreadUtils.asyncExec((IThreadWorkQueue)SymbolLibraryView.this.swtThread, (Runnable)SymbolLibraryView.this.disposer((Widget)group));
                    }
                    TreeSet<GroupDescriptor> groupDescs = new TreeSet<GroupDescriptor>(SymbolLibraryView.this.groupComparator);
                    for (ISymbolGroup lib : libraries) {
                        PGroup group = SymbolLibraryView.this.groups.get(lib);
                        String label = lib.getName();
                        groupDescs.add(new GroupDescriptor(lib, label, group));
                    }
                    IFilter groupFilter = SymbolLibraryView.this.currentGroupFilter;
                    SymbolLibraryView.this.populateGroups(SymbolLibraryView.this.loaderExecutor, null, groupDescs.iterator(), groupFilter, loadId, new Runnable(){

                        @Override
                        public void run() {
                            (this).SymbolLibraryView.this.loaderSemaphore.release();
                        }
                    });
                }
            }
        });
    }

    void populateGroups(final ExecutorService exec, final Control lastGroup, final Iterator<GroupDescriptor> iter, final IFilter groupFilter, final Integer loadId, final Runnable loadComplete) {
        int currentLoadId = this.loadCount.get();
        if (currentLoadId != loadId) {
            loadComplete.run();
            return;
        }
        if (!iter.hasNext()) {
            ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SymbolLibraryView.this.filter.isDisposed() || SymbolLibraryView.this.c.isDisposed()) {
                        return;
                    }
                    SymbolLibraryView.this.filter.focus();
                    SymbolLibraryView.this.c.setVisible(true);
                }
            });
            loadComplete.run();
            return;
        }
        final GroupDescriptor desc = iter.next();
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    this.populateGroup();
                }
                catch (RuntimeException e) {
                    loadComplete.run();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
                catch (Error e) {
                    loadComplete.run();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }

            public void populateGroup() {
                if (SymbolLibraryView.this.c.isDisposed()) {
                    SymbolLibraryView.this.loaderSemaphore.release();
                    return;
                }
                PGroup group = desc.group;
                if (group == null || group.isDisposed()) {
                    group = new PGroup(SymbolLibraryView.this.c, 0);
                    if (lastGroup != null) {
                        group.moveBelow(lastGroup);
                    } else {
                        group.moveAbove(null);
                    }
                    SymbolLibraryView.this.groups.put(desc.lib, group);
                    group.setData("group", (Object)desc.lib);
                    group.setData(SymbolLibraryView.KEY_USER_EXPANDED, (Object)SymbolLibraryView.this.defaultExpanded);
                    group.setExpanded(SymbolLibraryView.this.defaultExpanded);
                    group.setFont(SymbolLibraryView.this.resourceManager.createFont(FontDescriptor.createFrom((Font)group.getFont()).setStyle(0).increaseHeight(-1)));
                    GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)group);
                    GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)group);
                    group.addExpandListener(SymbolLibraryView.this.groupExpandListener);
                    if (desc.lib instanceof IModifiableSymbolGroup) {
                        IModifiableSymbolGroup mod = (IModifiableSymbolGroup)desc.lib;
                        mod.addListener(SymbolLibraryView.this.groupListener);
                    }
                }
                group.setText(desc.label);
                group.setToolTipText(desc.label);
                boolean groupFiltered = !groupFilter.select((Object)desc.label);
                group.setData(SymbolLibraryView.KEY_GROUP_FILTERED, (Object)groupFiltered);
                if (groupFiltered) {
                    SymbolLibraryView.this.setGroupVisible(group, false);
                }
                SymbolLibraryView.this.syncRefreshScrolledComposite();
                final PGroup group_ = group;
                exec.execute(new Runnable(){

                    @Override
                    public void run() {
                        SymbolLibraryView.this.populateGroups(exec, (Control)group_, iter, groupFilter, loadId, loadComplete);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GalleryViewer initializeGroup(PGroup group) {
        if (group.isDisposed()) {
            return null;
        }
        PGroup pGroup = group;
        synchronized (pGroup) {
            if (group.getData(KEY_VIEWER_INITIALIZED) != null) {
                return (GalleryViewer)group.getData("gallery");
            }
            group.setData(KEY_VIEWER_INITIALIZED, (Object)Boolean.TRUE);
        }
        GalleryViewer viewer = new GalleryViewer((Composite)group);
        ISymbolGroup input = (ISymbolGroup)group.getData("group");
        this.initializeViewer(group, input, viewer);
        this.groupViewers.put(input, viewer);
        group.setData("gallery", (Object)viewer);
        return viewer;
    }

    void initializeViewer(final PGroup group, ISymbolGroup input, final GalleryViewer viewer) {
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo(viewer.getControl());
        viewer.addDragSupport((IDragSourceParticipant)new DragSourceParticipant());
        viewer.setAlign(FlowLayout.Align.Left);
        viewer.getDiagram().setHint(SynchronizationHints.ERROR_HANDLER, (Object)this.errorHandler);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                return ((ISymbolGroup)inputElement).getItems();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)input);
        viewer.getCanvasContext().getEventHandlerStack().add((Object)new IEventHandler(){

            public int getEventMask() {
                return EventTypes.MouseDoubleClickMask;
            }

            public boolean handleEvent(Event e) {
                if (e instanceof MouseEvent.MouseDoubleClickedEvent) {
                    PickRequest req = new PickRequest(((MouseEvent.MouseDoubleClickedEvent)e).controlPosition);
                    ArrayList result = new ArrayList();
                    DiagramUtils.pick((IDiagram)viewer.getDiagram(), (PickRequest)req, result);
                    if (!result.isEmpty()) {
                        return false;
                    }
                    if (group.isDisposed()) {
                        return false;
                    }
                    group.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (group.isDisposed()) {
                                return;
                            }
                            boolean exp = !group.getExpanded();
                            group.setData(SymbolLibraryView.KEY_USER_EXPANDED, (Object)exp);
                            SymbolLibraryView.this.setGroupExpandedWithoutNotification(group, exp);
                            SymbolLibraryView.this.refreshScrolledComposite();
                        }
                    });
                    return true;
                }
                return false;
            }
        }, 0);
    }

    static String toPatternString(String filter) {
        if (!filter.isEmpty()) {
            String regExFilter = (filter = filter.toLowerCase()).replace("\\", "\\\\").replace(".", "\\.").replace("*", ".*").replace("?", ".").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("^", "\\^").replace("$", "\\$").replace("|", ".*|").replace("&&", "\\&&");
            if (!regExFilter.startsWith(".*")) {
                regExFilter = ".*" + regExFilter;
            }
            if (!regExFilter.endsWith(".*")) {
                regExFilter = String.valueOf(regExFilter) + ".*";
            }
            return regExFilter;
        }
        return null;
    }

    static Pattern toPattern(String filterText) {
        String regExFilter = SymbolLibraryView.toPatternString(filterText);
        Pattern pattern = regExFilter != null ? Pattern.compile(regExFilter) : ANY;
        return pattern;
    }

    static IFilter composeFilter(FilterConfiguration config) {
        final FilterConfiguration.Mode mode = config.getMode();
        final ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (GroupFilter f : config.getFilters()) {
            if (!f.isActive()) continue;
            patterns.add(SymbolLibraryView.toPattern(f.getFilterText()));
        }
        return new IFilter(){

            public boolean select(Object toTest) {
                if (patterns.isEmpty()) {
                    return true;
                }
                String s = (String)toTest;
                switch (mode) {
                    case AND: {
                        for (Pattern pat : patterns) {
                            Matcher m = pat.matcher(s.toLowerCase());
                            if (m.matches()) continue;
                            return false;
                        }
                        return true;
                    }
                    case OR: {
                        for (Pattern pat : patterns) {
                            Matcher m = pat.matcher(s.toLowerCase());
                            if (!m.matches()) continue;
                            return true;
                        }
                        return false;
                    }
                }
                throw new Error("Shouldn't happen");
            }
        };
    }

    void updateFilterConfiguration(FilterConfiguration config) {
        IFilter filter;
        this.config = config;
        this.currentGroupFilter = filter = SymbolLibraryView.composeFilter(config);
    }

    void applyGroupFilters() {
        Control[] grps;
        IFilter groupFilter = this.currentGroupFilter;
        final boolean[] changed = new boolean[1];
        Control[] controlArray = grps = this.c.getChildren();
        int n = grps.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            PGroup grp = (PGroup)ctrl;
            boolean visible = grp.getVisible();
            boolean shouldBeVisible = groupFilter.select((Object)grp.getText());
            boolean change = visible ^ shouldBeVisible;
            changed[0] = changed[0] | change;
            grp.setData(KEY_GROUP_FILTERED, (Object)(!shouldBeVisible ? 1 : 0));
            if (change) {
                this.setGroupVisible(grp, shouldBeVisible);
            }
            ++n2;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SymbolLibraryView.this.c.isDisposed()) {
                    return;
                }
                if (changed[0]) {
                    SymbolLibraryView.this.c.layout(true);
                    SymbolLibraryView.this.syncRefreshScrolledComposite();
                }
            }
        });
    }

    boolean filterGroups(String text) {
        Control[] grps;
        Pattern pattern;
        String regExFilter = SymbolLibraryView.toPatternString(text);
        this.currentFilterPattern = pattern = regExFilter != null ? Pattern.compile(regExFilter) : ANY;
        final boolean[] changed = new boolean[1];
        boolean filteringComplete = true;
        SymbolItemFilter filter = null;
        if (regExFilter != null) {
            filter = new SymbolItemFilter(regExFilter, pattern);
        }
        Control[] controlArray = grps = this.c.getChildren();
        int n = grps.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            PGroup grp = (PGroup)ctrl;
            if (!grp.isDisposed()) {
                Boolean contentsChanged = this.filterGroup(grp, filter);
                if (contentsChanged == null) {
                    filteringComplete = false;
                } else {
                    changed[0] = contentsChanged;
                }
            }
            ++n2;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SymbolLibraryView.this.c.isDisposed()) {
                    return;
                }
                if (changed[0]) {
                    SymbolLibraryView.this.c.layout(true);
                    SymbolLibraryView.this.syncRefreshScrolledComposite();
                }
            }
        });
        return filteringComplete;
    }

    static boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private Boolean filterGroup(PGroup grp, ViewerFilter filter) {
        boolean shouldBeExpanded;
        boolean changed = false;
        GalleryViewer viewer = this.initializeGroup(grp);
        if (viewer == null) {
            return null;
        }
        ViewerFilter lastFilter = viewer.getFilter();
        boolean groupFiltered = Boolean.TRUE.equals(grp.getData(KEY_GROUP_FILTERED));
        boolean userExpanded = Boolean.TRUE.equals(grp.getData(KEY_USER_EXPANDED));
        boolean expanded = grp.getExpanded();
        boolean visible = grp.getVisible();
        boolean filterChanged = !SymbolLibraryView.objectEquals(filter, lastFilter);
        viewer.setFilter(filter);
        Object[] elements = viewer.getFilteredElements();
        boolean shouldBeVisible = !groupFiltered && elements.length > 0;
        boolean bl = shouldBeExpanded = shouldBeVisible && (filter != null || userExpanded);
        if (filterChanged || visible != shouldBeVisible || expanded != shouldBeExpanded) {
            changed = true;
            if (shouldBeVisible == userExpanded) {
                if (expanded != shouldBeExpanded) {
                    this.setGroupExpandedWithoutNotification(grp, shouldBeExpanded);
                }
                this.setGroupVisible(grp, shouldBeVisible);
            } else if (filter != null) {
                if (shouldBeVisible) {
                    this.setGroupExpandedWithoutNotification(grp, true);
                    this.setGroupVisible(grp, true);
                } else {
                    this.setGroupExpandedWithoutNotification(grp, true);
                    this.setGroupVisible(grp, false);
                }
            } else {
                if (expanded != userExpanded) {
                    this.setGroupExpandedWithoutNotification(grp, userExpanded);
                }
                if (!visible) {
                    this.setGroupVisible(grp, true);
                }
            }
            if (shouldBeExpanded) {
                viewer.refreshWithContent(elements);
            }
        }
        return changed;
    }

    void setGroupExpandedWithoutNotification(PGroup grp, boolean expanded) {
        grp.setExpanded(expanded);
    }

    void setGroupVisible(PGroup group, boolean visible) {
        GridData gd = (GridData)group.getLayoutData();
        gd.exclude = !visible;
        group.setVisible(visible);
    }

    boolean isGroupFiltered(String label) {
        return !this.currentFilterPattern.matcher(label.toLowerCase()).matches();
    }

    public void setFocus() {
        this.c.setFocus();
    }

    public boolean isDefaultExpanded() {
        return this.defaultExpanded;
    }

    public void setDefaultExpanded(boolean defaultExpanded) {
        this.defaultExpanded = defaultExpanded;
    }

    Runnable disposer(final Widget w) {
        return new Runnable(){

            @Override
            public void run() {
                if (w.isDisposed()) {
                    return;
                }
                w.dispose();
            }
        };
    }

    void contributeActions() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)new Action("Collapse All", BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.diagram", (String)"icons/collapseall.gif")){

            public void run() {
                SymbolLibraryView.this.setAllExpandedStates(false);
            }
        });
        toolbar.add((IAction)new Action("Expand All", BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.diagram", (String)"icons/expandall.gif")){

            public void run() {
                SymbolLibraryView.this.setAllExpandedStates(true);
            }
        });
        toolbar.add((IAction)new Action("Configure Filters", BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.diagram", (String)"icons/filter_ps.gif")){

            public void run() {
                FilterConfiguration clone = new FilterConfiguration(SymbolLibraryView.this.config);
                FilterDialog fd = new FilterDialog(SymbolLibraryView.this.getViewSite().getShell(), Activator.getDefault().getDialogSettings(), clone);
                int result = fd.open();
                if (result != 0) {
                    return;
                }
                SymbolLibraryView.this.updateFilterConfiguration(clone);
                SymbolLibraryView.this.applyGroupFilters();
                try {
                    SymbolLibraryView.this.savePreferences();
                }
                catch (BackingStoreException e) {
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }
        });
    }

    void setAllExpandedStates(boolean targetState) {
        Control[] grps;
        Boolean targetStateObj = targetState;
        boolean changed = false;
        this.setDefaultExpanded(targetState);
        Control[] controlArray = grps = this.c.getChildren();
        int n = grps.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            final PGroup grp = (PGroup)control;
            grp.setData(KEY_USER_EXPANDED, (Object)targetStateObj);
            if (!grp.isDisposed() && grp.getExpanded() != targetState && grp.getVisible()) {
                final GalleryViewer viewer = this.initializeGroup(grp);
                this.setGroupExpandedWithoutNotification(grp, targetState);
                ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!grp.isDisposed()) {
                            if (viewer != null) {
                                viewer.refresh();
                            }
                            SymbolLibraryView.this.refreshScrolledComposite();
                        }
                    }
                });
                changed = true;
            }
            ++n2;
        }
        if (changed) {
            this.refreshScrolledComposite();
        }
    }

    public FilterArea getFilterArea() {
        return this.filter;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == INode[].class) {
            ArrayList<G2DSceneGraph> result = new ArrayList<G2DSceneGraph>(this.groupViewers.size());
            for (GalleryViewer viewer : this.groupViewers.values()) {
                result.add(viewer.getCanvasContext().getSceneGraph());
            }
            return result.toArray(new INode[result.size()]);
        }
        return super.getAdapter(adapter);
    }

    class DragSourceParticipant
    extends AbstractDiagramParticipant
    implements IDragSourceParticipant {
        @DependencyReflection.Reference
        Selection selection;
        @DependencyReflection.Dependency
        PointerInteractor pi;
        @DependencyReflection.Dependency
        TransformUtil util;
        @DependencyReflection.Dependency
        PickContext pickContext;

        DragSourceParticipant() {
        }

        public int canDrag(MouseEvent.MouseDragBegin me) {
            if (me.button != 1) {
                return 0;
            }
            if (this.getHint(Hints.KEY_TOOL) != Hints.POINTERTOOL) {
                return 0;
            }
            this.assertDependencies();
            PickRequest req = new PickRequest(me.startCanvasPos);
            req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
            ArrayList picks = new ArrayList();
            this.pickContext.pick(this.diagram, req, picks);
            Set sel = this.selection.getSelection(me.mouseId);
            if (Collections.disjoint(sel, picks)) {
                return 0;
            }
            return 0x40000000;
        }

        public Transferable dragStart(DragGestureEvent e) {
            AWTChassis chassis = (AWTChassis)e.getComponent();
            ICanvasContext cc = chassis.getCanvasContext();
            Selection sel = (Selection)cc.getSingleItem(Selection.class);
            Set ss = sel.getSelection(0);
            if (ss.isEmpty()) {
                return null;
            }
            Object[] res = new Object[ss.size()];
            int index = 0;
            for (IElement ee : ss) {
                res[index++] = ee.getHint(ElementHints.KEY_OBJECT);
            }
            StructuredSelection object = new StructuredSelection(res);
            return new LocalObjectTransferable((Object)object);
        }

        public int getAllowedOps() {
            return 1;
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            LocalObjectTransfer.getTransfer().clear();
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dse) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    static class GroupDescriptor {
        public final ISymbolGroup lib;
        public final String label;
        public final PGroup group;

        public GroupDescriptor(ISymbolGroup lib, String label, PGroup group) {
            assert (lib != null);
            assert (label != null);
            this.lib = lib;
            this.label = label;
            this.group = group;
        }
    }

    class ImageLoader
    implements Runnable {
        private final ImageProxy imageProxy;
        private final ISymbolItem item;

        public ImageLoader(ImageProxy imageProxy, ISymbolItem item) {
            this.imageProxy = imageProxy;
            this.item = item;
        }

        @Override
        public void run() {
            ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ImageLoader.this.runBlocking();
                }
            });
        }

        private void runBlocking() {
            try {
                IDiagram hints = null;
                ISymbolGroup group = this.item.getGroup();
                if (group == null) {
                    throw new ProvisionException("No ISymbolGroup available for ISymbolItem " + this.item);
                }
                GalleryViewer viewer = SymbolLibraryView.this.groupViewers.get(group);
                if (viewer == null) {
                    this.imageProxy.setSource((Image)DefaultImages.UNKNOWN2.get());
                    return;
                }
                hints = viewer.getDiagram();
                if (hints == null) {
                    throw new ProvisionException("No diagram available for GalleryViewer of group " + group);
                }
                ElementClass ec = this.item.getElementClass((IHintObservable)hints);
                StaticSymbol ss = (StaticSymbol)ec.getSingleItem(StaticSymbol.class);
                Image source = ss == null ? (Image)DefaultImages.UNKNOWN2.get() : ss.getImage();
                this.imageProxy.setSource(source);
            }
            catch (ProvisionException e) {
                ExceptionUtils.logWarning((String)("Failed to provide element class for symbol item " + this.item), (Throwable)e);
                this.imageProxy.setSource((Image)DefaultImages.ERROR_DECORATOR.get());
            }
            catch (Exception e) {
                ExceptionUtils.logError((Throwable)e);
                this.imageProxy.setSource((Image)DefaultImages.ERROR_DECORATOR.get());
            }
        }
    }

    class LabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        LabelProvider() {
        }

        public Image getImage(Object element) {
            ISymbolItem item = (ISymbolItem)element;
            ImageProxy proxy = null;
            SoftReference<ImageProxy> proxyRef = SymbolLibraryView.this.imageCache.get(item);
            if (proxyRef != null) {
                proxy = proxyRef.get();
            }
            if (proxy == null) {
                proxy = new PendingImage((Image)DefaultImages.HOURGLASS.get(), VOLATILE);
                SymbolLibraryView.this.imageCache.put(item, new SoftReference<ImageProxy>(proxy));
                ThreadUtils.getNonBlockingWorkExecutor().schedule(new ImageLoader(proxy, item), 100L, TimeUnit.MILLISECONDS);
            }
            return proxy;
        }

        public String getText(Object element) {
            return ((ISymbolItem)element).getName();
        }

        public String getToolTipText(Object element) {
            String desc;
            ISymbolItem item = (ISymbolItem)element;
            String name = item.getName();
            return name.equals(desc = item.getDescription()) ? name : String.valueOf(name) + " - " + desc;
        }

        public java.awt.Image getToolTipImage(Object object) {
            return null;
        }

        public Color getToolTipBackgroundColor(Object object) {
            return null;
        }

        public Color getToolTipForegroundColor(Object object) {
            return null;
        }
    }

    static class PendingImage
    extends ImageProxy {
        EnumSet<Image.Feature> features;

        PendingImage(Image source, EnumSet<Image.Feature> features) {
            super(source);
            this.features = features;
        }

        public EnumSet<Image.Feature> getFeatures() {
            return this.features;
        }
    }

    public class ProjectTracker
    extends HintTracker {
        public ProjectTracker() {
            HintListenerAdapter symbolGroupListener = new HintListenerAdapter(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    Collection groups = (Collection)newValue;
                    SymbolLibraryView.this.load(groups);
                }
            };
            this.addKeyHintListener(ISymbolManager.KEY_SYMBOL_GROUPS, (IHintListener)symbolGroupListener);
        }
    }

    public class SessionContextTracker
    extends HintTracker
    implements ISessionContextChangedListener {
        public SessionContextTracker() {
            HintListenerAdapter activeProjectListener = new HintListenerAdapter(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    ((SessionContextTracker)SessionContextTracker.this).SymbolLibraryView.this.projectTracker.track((IHintContext)((IProject)newValue));
                }
            };
            this.addKeyHintListener(ProjectKeys.KEY_PROJECT, (IHintListener)activeProjectListener);
        }

        public void sessionContextChanged(SessionContextChangedEvent event) {
            this.track((IHintContext)event.getNewValue());
        }
    }

    static class SymbolItemFilter
    extends ViewerFilter {
        private final String string;
        private final Pattern pattern;

        public SymbolItemFilter(String string, Pattern pattern) {
            this.string = string;
            this.pattern = pattern;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ISymbolItem item = (ISymbolItem)element;
            String name = item.getName();
            Matcher m = this.pattern.matcher(name.toLowerCase());
            return m.matches();
        }

        public int hashCode() {
            return this.string == null ? 0 : this.string.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SymbolItemFilter other = (SymbolItemFilter)((Object)obj);
            return !(this.string == null ? other.string != null : !this.string.equals(other.string));
        }
    }
}

