/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ErrorLogger;

public class ClaimAction
extends Action {
    protected final String virtualGraphId;
    protected final Resource subject;
    protected final String relationURI;
    protected final Resource object;

    public ClaimAction(String label, ImageDescriptor image, String virtualGraphId, Resource subject, String relationURI, Resource object) {
        super(label, image);
        this.virtualGraphId = virtualGraphId;
        this.subject = subject;
        this.relationURI = relationURI;
        this.object = object;
    }

    public void run() {
        Session session = Simantics.peekSession();
        if (session != null) {
            VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
            session.asyncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    ClaimAction.this.claim(graph);
                }
            }, e -> {
                if (e != null) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            });
        }
    }

    public void claim(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource relation = graph.getResource(this.relationURI);
        boolean functional = graph.isInstanceOf(relation, L0.FunctionalRelation);
        if (functional) {
            graph.deny(this.subject, relation);
        }
        graph.claim(this.subject, graph.getResource(this.relationURI), this.object);
    }
}

