/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.unitParser.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.sysdyn.unitParser.Token;
import org.simantics.sysdyn.unitParser.UnitCheckingException;
import org.simantics.sysdyn.unitParser.UnitCheckingNode;
import org.simantics.sysdyn.unitParser.nodes.Power;
import org.simantics.sysdyn.unitParser.nodes.UnitResult;
import org.simantics.sysdyn.utils.Function;

public class Factor
extends UnitCheckingNode {
    public Factor(int id) {
        super(id);
    }

    @Override
    public UnitResult getUnits(HashMap<String, String> units, ArrayList<Function> functions, boolean allowEquivalents) throws UnitCheckingException {
        UnitResult result = new UnitResult(allowEquivalents);
        UnitCheckingNode current = null;
        UnitCheckingNode operator = null;
        UnitCheckingNode base = null;
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            current = (UnitCheckingNode)this.jjtGetChild(i);
            UnitResult currentUnits = current.getUnits(units, functions, allowEquivalents);
            if (currentUnits.getUnitType() == UnitResult.UnitType.ANY) {
                result = new UnitResult(allowEquivalents);
                result.setUnitType(UnitResult.UnitType.ANY);
                return result;
            }
            if (currentUnits.getUnitType() != UnitResult.UnitType.OPERATOR) {
                if (base == null) {
                    base = current;
                } else {
                    UnitResult.UnitType unitType;
                    operator = (UnitCheckingNode)this.jjtGetChild(i - 1);
                    if (operator instanceof Power && (unitType = currentUnits.getUnitType()) == UnitResult.UnitType.SCALAR) {
                        int exponent;
                        UnitResult baseUnits = base.getUnits(units, functions, allowEquivalents);
                        try {
                            exponent = Integer.valueOf(currentUnits.getFullUnit());
                        }
                        catch (NumberFormatException e) {
                            exponent = 1;
                        }
                        if (exponent < 0) {
                            int j = 0;
                            while (j > exponent) {
                                result.addAllDividers(baseUnits.getDividents());
                                result.addAllDividents(baseUnits.getDividers());
                                result.append(operator.printNode());
                                result.append(baseUnits.getFullUnit());
                                --j;
                            }
                            result.setUnitType(baseUnits.getUnitType());
                        } else if (exponent > 0) {
                            result.appendResult(baseUnits);
                            int j = 1;
                            while (j < exponent) {
                                result.addAllDividents(baseUnits.getDividents());
                                result.addAllDividers(baseUnits.getDividers());
                                result.append(operator.printNode());
                                result.append(baseUnits.getFullUnit());
                                ++j;
                            }
                            result.setUnitType(baseUnits.getUnitType());
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public String printNode() {
        StringBuilder sb = new StringBuilder();
        Token token = this.jjtGetFirstToken();
        sb.append(token.image);
        Token prevToken = null;
        while (token != null && !token.equals(this.jjtGetLastToken())) {
            prevToken = token;
            token = token.next;
            if (!(token.image.equals("[") || token.image.equals("]") || prevToken.image.equals("[") || prevToken.image.equals("]") || token.image.equals(".") || prevToken.image.equals("."))) {
                sb.append(" ");
            }
            sb.append(token.image);
        }
        return sb.toString();
    }
}

