/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.annotations.RelatedElement;
import org.simantics.objmap.annotations.RelatedListElements;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.sysdyn.representation.Book;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.expressions.IExpression;

public abstract class Variable
implements IElement {
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/Variable/type")
    protected String type;
    @RelatedValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    protected String name;
    @RelatedElement(value="http://www.simantics.org/Layer0-1.1/PartOf")
    protected Object parent;
    @RelatedListElements(value="http://www.simantics.org/Sysdyn-1.1/Variable/arrayIndexesList")
    protected ArrayList<Enumeration> arrayIndexes = new ArrayList();
    @RelatedListElements(value="http://www.simantics.org/Sysdyn-1.1/Variable/expressionList")
    protected ArrayList<IExpression> expressions = new ArrayList();
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/Variable/variability")
    protected String variability;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/Variable/unit")
    protected String unit;
    @RelatedValue(value="http://www.simantics.org/Layer0-1.1/HasDescription")
    protected String description;
    @RelatedElement(value="http://www.simantics.org/Sysdyn-1.1/IsOutput")
    protected IElement isOutput;

    public String getVariability() {
        return this.variability;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getModelicaName() {
        if (this.name == null) {
            return null;
        }
        return this.name.replace(' ', '_');
    }

    public Configuration getParentConfiguration() {
        if (this.parent instanceof Configuration) {
            return (Configuration)this.parent;
        }
        if (this.parent instanceof Book) {
            return ((Book)this.parent).getParentConfiguration();
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public ArrayList<Enumeration> getArrayIndexes() {
        return this.arrayIndexes;
    }

    public int[] getDimensionArray() {
        if (this.arrayIndexes == null) {
            return null;
        }
        int[] dimensions = new int[this.arrayIndexes.size()];
        int i = 0;
        while (i < this.arrayIndexes.size()) {
            dimensions[i] = this.arrayIndexes.get(i).getEnumerationIndexes().size();
            ++i;
        }
        return dimensions;
    }

    public ArrayList<IExpression> getExpressions() {
        return this.expressions;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public boolean isOutput() {
        return this.isOutput != null;
    }

    public String getDocumentationDefinition(ReadGraph graph) throws DatabaseException {
        if (this.isOutput()) {
            return "<br />Is output";
        }
        return "";
    }
}

