/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelImport.model.Connection;
import org.simantics.sysdyn.modelImport.model.Dependency;
import org.simantics.sysdyn.modelImport.model.Flow;
import org.simantics.sysdyn.modelImport.model.IWriteableObject;
import org.simantics.sysdyn.modelImport.model.Shadow;
import org.simantics.sysdyn.modelImport.model.Symbol;
import org.simantics.sysdyn.modelImport.model.Variable;
import org.simantics.sysdyn.modelImport.model.WriteContext;
import org.simantics.sysdyn.modelImport.model.support.Enumeration;
import org.simantics.sysdyn.modelImport.model.support.Function;
import org.simantics.sysdyn.utils.ModelUtils;

public class Model
implements IWriteableObject {
    private String name;
    private Double start;
    private Double stop;
    private Double step;
    private String unit;
    private Map<String, Variable> variables;
    private Map<String, Enumeration> enumerations;
    private Map<String, Function> functions;
    private List<Symbol> symbols;
    private List<Shadow> shadows;
    private List<Connection> connections;
    private Resource model;

    public Model(String name) {
        this.name = name;
        this.variables = new HashMap<String, Variable>();
        this.enumerations = new HashMap<String, Enumeration>();
        this.functions = new HashMap<String, Function>();
        this.symbols = new ArrayList<Symbol>();
        this.shadows = new ArrayList<Shadow>();
        this.connections = new ArrayList<Connection>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getStartTime() {
        return this.start;
    }

    public void setStartTime(double start) {
        this.start = start;
    }

    public double getStopTime() {
        return this.stop;
    }

    public void setStopTime(double stop) {
        this.stop = stop;
    }

    public double getTimeStep() {
        return this.step;
    }

    public void setTimeStep(double step) {
        this.step = step;
    }

    public String getTimeUnit() {
        return this.unit;
    }

    public void setTimeUnit(String unit) {
        this.unit = unit;
    }

    public void addVariable(Variable variable) {
        if (this.variables.get(variable.getName()) != null) {
            System.err.println("variable " + variable.getName() + " already defined");
            return;
        }
        this.variables.put(variable.getName(), variable);
        this.symbols.add(variable);
    }

    public Variable getVariable(String name) {
        return this.variables.get(name);
    }

    public Collection<Variable> getVariables() {
        return this.variables.values();
    }

    public void addShadow(Shadow shadow) {
        this.shadows.add(shadow);
    }

    public void addSymbol(Symbol element) {
        this.symbols.add(element);
    }

    public void addConnection(Connection connection) {
        this.connections.add(connection);
    }

    public List<Flow> getInFlows(Variable variable) {
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (Connection connection : this.connections) {
            if (!(connection instanceof Flow) || !connection.getHead().equals(variable)) continue;
            flows.add((Flow)connection);
        }
        return flows;
    }

    public List<Flow> getOutFlows(Variable variable) {
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (Connection connection : this.connections) {
            if (!(connection instanceof Flow) || !connection.getTail().equals(variable)) continue;
            flows.add((Flow)connection);
        }
        return flows;
    }

    public List<Dependency> getInDependencies(Variable variable) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (Connection connection : this.connections) {
            if (!(connection instanceof Dependency) || !connection.getHead().equals(variable)) continue;
            deps.add((Dependency)connection);
        }
        return deps;
    }

    public List<Dependency> getOutDependencies(Variable variable) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (Connection connection : this.connections) {
            if (!(connection instanceof Dependency) || !connection.getTail().equals(variable)) continue;
            deps.add((Dependency)connection);
        }
        return deps;
    }

    public void addEnumeration(Enumeration enumeration) {
        if (this.enumerations.get(enumeration.getName()) != null) {
            System.err.println("enumeration " + enumeration.getName() + " already defined");
            return;
        }
        this.enumerations.put(enumeration.getName(), enumeration);
    }

    public Enumeration getEnumeration(String name) {
        return this.enumerations.get(name);
    }

    public Collection<Enumeration> getEnumerations() {
        return this.enumerations.values();
    }

    public void addFunction(Function function) {
        if (this.functions.get(function.getName()) != null) {
            System.err.println("function " + function.getName() + " already defined");
            return;
        }
        this.functions.put(function.getName(), function);
    }

    public Function getEFunction(String name) {
        return this.functions.get(name);
    }

    public Collection<Function> getFunctions() {
        return this.functions.values();
    }

    public Resource write(WriteGraph graph, Resource project) throws DatabaseException {
        return this.write(graph, project, new WriteContext());
    }

    @Override
    public Resource write(WriteGraph graph, Resource parent, WriteContext context) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        SimulationResource sim = SimulationResource.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        this.model = ModelUtils.createModel(graph);
        Resource container = graph.getSingleObject(this.model, l0.PartOf);
        String freshName = NameUtils.findFreshName((ReadGraph)graph, (String)this.name, (Resource)container, (Resource)l0.ConsistsOf, (String)"%s%d");
        graph.claimLiteral(this.model, l0.HasName, (Object)freshName, (Binding)Bindings.STRING);
        if (this.start != null) {
            graph.claimLiteral(this.model, sr.SysdynModel_startTime, (Object)this.start, (Binding)Bindings.DOUBLE);
        }
        if (this.stop != null) {
            graph.claimLiteral(this.model, sr.SysdynModel_stopTime, (Object)this.stop, (Binding)Bindings.DOUBLE);
        }
        if (this.step != null) {
            graph.claimLiteral(this.model, sr.SysdynModel_simulationStepLength, (Object)this.step, (Binding)Bindings.DOUBLE);
        }
        if (this.unit != null) {
            graph.claimLiteral(this.model, sr.SysdynModel_timeUnit, (Object)this.unit, (Binding)Bindings.STRING);
        }
        Resource configuration = graph.getSingleObject(this.model, sim.HasConfiguration);
        for (Enumeration enumeration : this.getEnumerations()) {
            enumeration.write(graph, configuration, context);
        }
        for (Function function : this.getFunctions()) {
            function.write(graph, this.model, context);
        }
        for (Symbol symbol : this.symbols) {
            symbol.write(graph, configuration, context);
        }
        for (Shadow shadow : this.shadows) {
            shadow.write(graph, configuration, context);
        }
        for (Connection connection : this.connections) {
            connection.write(graph, configuration, context);
        }
        Resource resource = graph.getSingleObject(configuration, mr.CompositeToDiagram);
        graph.claimLiteral(resource, dr.HasModCount, (Object)context.getObjectCount(), (Binding)Bindings.LONG);
        return this.model;
    }

    @Override
    public Resource getResource() {
        return this.model;
    }
}

