/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modelica.ModelicaException;
import org.simantics.modelica.ModelicaKeys;
import org.simantics.modelica.ModelicaManager;
import org.simantics.modelica.SimulationLocation;
import org.simantics.modelica.data.CSVSimulationResult;
import org.simantics.modelica.data.MatSimulationResult;
import org.simantics.modelica.data.SimulationResult;
import org.simantics.modelica.preferences.OpenModelicaPreferences;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.Activator;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.FunctionUtils;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.SaveResultJob;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynResult;
import org.simantics.sysdyn.modelica.ModelicaWriter;
import org.simantics.sysdyn.nodemanager.SysdynVariableSessionManager;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.simulation.SimulationScheduler;

public abstract class OldSysdynExperiment
extends SysdynExperiment {
    protected HashMap<String, String> defaultParameters;
    private File simulationDir;
    protected static String omcVersion = null;
    protected static String omcHome = null;
    public static OldSysdynExperiment INSTANCE;
    boolean publishResults = true;
    private PublishExternalRead publishRead = new PublishExternalRead(this);
    volatile long previousVariableUpdateTime = 0L;
    volatile boolean skippedVariableUpdate = true;

    public OldSysdynExperiment(Resource experiment, Resource model, String identifier) {
        super(experiment, model, identifier);
        INSTANCE = this;
    }

    public static OldSysdynExperiment getInstance() {
        return INSTANCE;
    }

    public int getPublishCounter(ReadGraph graph) throws DatabaseException {
        return (Integer)graph.syncRequest((ExternalRead)this.publishRead);
    }

    @Override
    public SysdynResult getCurrentResult() {
        if (this.result == null) {
            this.result = new MemoryResult(null, null);
        }
        return this.result;
    }

    @Override
    public Collection<SysdynResult> getActiveResults() {
        ArrayList<SysdynResult> result = new ArrayList<SysdynResult>();
        if (this.getCurrentResult() != null) {
            result.add(this.getCurrentResult());
        }
        result.addAll(this.sysdynModel.getDisplayedResults());
        return result;
    }

    @Override
    public void saveState() {
        if (this.result == null || !(this.result instanceof MemoryResult)) {
            return;
        }
        SaveResultJob saveResultJob = new SaveResultJob(this, this.session, (MemoryResult)this.result);
        saveResultJob.schedule();
    }

    @Override
    protected Thread getSaveThread(final SysdynResult result, final File file, final IProgressMonitor progressMonitor) {
        return new Thread(){

            @Override
            public void run() {
                if (!OldSysdynExperiment.this.canceled) {
                    result.saveToFile(file, progressMonitor);
                }
            }
        };
    }

    @Override
    public void simulate(boolean enabled) {
        if (enabled && this.sysdynModel != null) {
            if (!ExperimentState.RUNNING.equals((Object)this.getState())) {
                this.changeState(ExperimentState.RUNNING);
                this.startSimulationJob();
            }
        } else if (!this.toggled) {
            this.changeState(ExperimentState.STOPPED);
        }
    }

    protected void startSimulationJob() {
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                SimulationScheduler.start(OldSysdynExperiment.this.sysdynModel, OldSysdynExperiment.this);
            }
        });
    }

    protected String getModelicaCode(IModelicaMonitor monitor, boolean isGame, String modelicaVersion) {
        String modelText = null;
        try {
            Model representation = this.sysdynModel.getConfiguration().getModel();
            double start = representation.getStartTime();
            double stop = representation.getStopTime();
            double step = representation.getSimulationStepLength();
            modelText = ModelicaWriter.write(this.sysdynModel.getModules(), start, stop, step, isGame, modelicaVersion);
        }
        catch (Exception e) {
            this.simulate(false);
            monitor.showConsole();
            monitor.message("Error when writing Modelica code.");
        }
        return modelText;
    }

    protected HashMap<String, String> getExperimentParameters(IModelicaMonitor monitor) {
        String variableFilter;
        Configuration configuration = this.sysdynModel.getConfiguration();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Model model = configuration.getModel();
        Double startTime = model.getStartTime();
        Double stopTime = model.getStopTime();
        parameters.put(ModelicaKeys.START_VALUE, startTime.toString());
        parameters.put(ModelicaKeys.STOP_VALUE, stopTime.toString());
        String outputFormat = "mat";
        parameters.put(ModelicaKeys.OUTPUT_FORMAT, outputFormat);
        Double simulationStepLength = model.getSimulationStepLength();
        parameters.put(ModelicaKeys.STEP_VALUE, simulationStepLength.toString());
        parameters.put(ModelicaKeys.NUMBER_OF_INTERVALS, Integer.toString((int)((stopTime - startTime) / simulationStepLength)));
        Double outputInterval = model.getOutputInterval();
        parameters.put(ModelicaKeys.OUTPUT_INTERVAL, outputInterval.toString());
        String method = "\"" + model.getSolver() + "\"";
        parameters.put(ModelicaKeys.METHOD, method);
        if (model.getTolerance() != null) {
            parameters.put(ModelicaKeys.TOLERANCE, model.getTolerance().toString());
        }
        if ((variableFilter = model.getVariableFilter()) != null && !variableFilter.isEmpty()) {
            parameters.put(ModelicaKeys.VARIABLE_FILTER, variableFilter);
        }
        return parameters;
    }

    protected void buildModel(SimulationLocation simulationLocation, IModelicaMonitor monitor) {
        try {
            simulationLocation.executableFile.delete();
            ModelicaManager.buildModel((SimulationLocation)simulationLocation, (IModelicaMonitor)monitor);
        }
        catch (ModelicaException e) {
            if (e.getMessage() != null) {
                monitor.message(e.getMessage());
            }
            monitor.showConsole();
            this.canceled = true;
            this.defaultParameters = null;
        }
    }

    protected void runModelica(SimulationLocation simulationLocation, IModelicaMonitor monitor, IProgressMonitor progressMonitor, HashMap<String, String> experimentParameters, HashMap<String, String> parameterChanges) throws IOException {
        progressMonitor.subTask("Simulate model");
        this.process = ModelicaManager.runModelica((SimulationLocation)simulationLocation, (IModelicaMonitor)monitor, experimentParameters, parameterChanges);
        ModelicaManager.printProcessOutput((Process)this.process, (IModelicaMonitor)monitor);
        Thread resultThread = this.getResultThread(simulationLocation, experimentParameters, monitor, progressMonitor);
        resultThread.run();
        this.process = null;
    }

    protected Thread getResultThread(final SimulationLocation simulationLocation, final HashMap<String, String> experimentParameters, final IModelicaMonitor monitor, final IProgressMonitor progressMonitor) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    OldSysdynExperiment.this.process.waitFor();
                    if (!OldSysdynExperiment.this.canceled) {
                        int maxIntervalInt;
                        Double outInterval;
                        progressMonitor.worked(1);
                        progressMonitor.subTask("Read results");
                        Object result = simulationLocation.resultFile.getName().endsWith(".csv") ? new CSVSimulationResult() : (simulationLocation.resultFile.getName().endsWith(".plt") ? new SimulationResult() : new MatSimulationResult());
                        String startTime = (String)experimentParameters.get(ModelicaKeys.START_VALUE);
                        String stopTime = (String)experimentParameters.get(ModelicaKeys.STOP_VALUE);
                        String stepTime = (String)experimentParameters.get(ModelicaKeys.STEP_VALUE);
                        Double start = Double.parseDouble(startTime);
                        Double stop = Double.parseDouble(stopTime);
                        Double step = Double.parseDouble(stepTime);
                        int outIntervalInt = 1;
                        String outputInterval = (String)experimentParameters.get(ModelicaKeys.OUTPUT_INTERVAL);
                        if (outputInterval != null && (outIntervalInt = (int)OldSysdynExperiment.getInterval(outInterval = Double.valueOf(Double.parseDouble(outputInterval)), step)) > (maxIntervalInt = (int)Math.round((stop - start) / step))) {
                            outIntervalInt = maxIntervalInt;
                        }
                        result.initRead(simulationLocation.resultFile);
                        result.readTime(simulationLocation.resultFile, outIntervalInt);
                        result.filter();
                        ((MemoryResult)OldSysdynExperiment.this.getCurrentResult()).setResult((SimulationResult)result);
                        ((MemoryResult)OldSysdynExperiment.this.getCurrentResult()).setResultFile(simulationLocation.resultFile);
                        ((MemoryResult)OldSysdynExperiment.this.getCurrentResult()).setFilter(start, stop, step);
                        progressMonitor.worked(1);
                        OldSysdynExperiment.this.resultsChanged();
                        OldSysdynExperiment.this.simulate(false);
                        String errorString = result.getResultReadErrors();
                        if (errorString != null && !errorString.isEmpty()) {
                            monitor.message(errorString);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected static long getInterval(double outputLength, double stepLength) {
        double interval = outputLength / stepLength;
        if (interval <= 1.0) {
            return 1L;
        }
        return Math.round(interval);
    }

    protected SimulationLocation createSimulationFiles(SysdynModel sysdynModel, String modelText, HashMap<String, String> inits, String additionalScript, boolean fmu) throws IOException {
        File simulationDir = this.getExperimentDir();
        FunctionUtils.updateFunctionFilesForExperiment(this);
        SimulationLocation location = ModelicaManager.createSimulationLocation((File)simulationDir, (String)sysdynModel.getConfiguration().getLabel(), (String)modelText);
        if (fmu) {
            ModelicaManager.createFMUSimulationScripts((SimulationLocation)location, inits, (String)additionalScript);
        } else {
            ModelicaManager.createSimulationScripts((SimulationLocation)location, inits, (String)additionalScript);
        }
        return location;
    }

    @Override
    public File getExperimentDir() {
        if (this.simulationDir == null) {
            File modelsDir = Activator.getBundleContext().getDataFile("models");
            String experimentName = this.experimentName;
            List<String> files = Arrays.asList(modelsDir.list());
            if (files.contains(experimentName)) {
                int i = 2;
                while (files.contains(String.valueOf(experimentName) + "_" + i)) {
                    ++i;
                }
                experimentName = String.valueOf(experimentName) + "_" + i;
            }
            this.simulationDir = Activator.getBundleContext().getDataFile("models/" + experimentName);
            if (!this.simulationDir.exists()) {
                this.simulationDir.mkdir();
            }
        }
        return this.simulationDir;
    }

    protected String getAdditionalScripts() {
        StringBuilder functionscript = new StringBuilder();
        boolean useModelicaLibraries = false;
        try {
            useModelicaLibraries = (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
                    Resource configuration = graph.getPossibleObject(OldSysdynExperiment.this.model, SIM.HasConfiguration);
                    return graph.hasStatement(configuration, SR.SysdynModel_useModelicaLibraries);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        if (useModelicaLibraries) {
            functionscript.append("loadModel(Modelica);\n");
        }
        for (String path : FunctionUtils.getLibraryPathsForModelica(this)) {
            functionscript.append("loadFile(\"" + path + "\");\n");
        }
        return functionscript.toString();
    }

    public synchronized void simulate(IModelicaMonitor monitor, IProgressMonitor progressMonitor, String modelName) throws IOException {
        this.canceled = false;
        progressMonitor.subTask("Write modelica classes");
        omcVersion = ModelicaManager.getDefaultOMVersion();
        monitor.message("Simulate " + modelName + " using OpenModelica " + omcVersion);
        String modelText = this.getModelicaCode(monitor, false, omcVersion);
        if (modelText == null) {
            return;
        }
        progressMonitor.worked(1);
        progressMonitor.subTask("Write simulation files");
        HashMap<String, String> experimentParameters = this.getExperimentParameters(monitor);
        String additionalScript = this.getAdditionalScripts();
        SimulationLocation simulationLocation = this.createSimulationFiles(this.sysdynModel, modelText, experimentParameters, additionalScript, false);
        progressMonitor.worked(1);
        String flatModelText = ModelicaManager.getFlatModelText((SimulationLocation)simulationLocation, (IModelicaMonitor)monitor, FunctionUtils.getLibraryPathsForModelica(this));
        boolean structureChanged = this.sysdynModel.isStructureModified();
        if (!simulationLocation.executableFile.isFile() || structureChanged) {
            progressMonitor.subTask("Build model");
            this.defaultParameters = ModelicaManager.getModelParameters((String)flatModelText);
            this.buildModel(simulationLocation, monitor);
        }
        HashMap<String, String> parameterChanges = new HashMap<String, String>();
        if (!structureChanged && this.defaultParameters != null) {
            HashMap currentParameters = ModelicaManager.getModelParameters((String)flatModelText);
            for (String key : this.defaultParameters.keySet()) {
                if (this.defaultParameters.get(key).equals(currentParameters.get(key))) continue;
                parameterChanges.put(key, (String)currentParameters.get(key));
            }
        }
        progressMonitor.worked(1);
        if (simulationLocation != null && !this.canceled) {
            this.runModelica(simulationLocation, monitor, progressMonitor, experimentParameters, parameterChanges);
        }
        if (this.canceled) {
            this.simulate(false);
        }
        this.process = null;
    }

    protected String getOpenModelicaVersion() {
        File omHomeDir;
        String omVersion = null;
        IScopeContext context = DefaultScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.simantics.modelica");
        String omHome = node.get(OpenModelicaPreferences.OM_HOME, null);
        if (omHome != null && (omHomeDir = new File(omHome)) != null && omHomeDir.isDirectory()) {
            omVersion = ModelicaManager.getOMVersion((File)omHomeDir);
        }
        if (omVersion == null) {
            omVersion = ModelicaManager.getDefaultOMVersion();
        }
        return omVersion;
    }

    @Override
    public void cancelSimulation() {
        this.canceled = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    @Override
    public void toggleSimulation(boolean enabled) {
        if (enabled) {
            this.toggled = true;
            this.changeState(ExperimentState.RUNNING);
            if (this.modificationListener == null) {
                this.modificationListener = new Runnable(){

                    @Override
                    public void run() {
                        OldSysdynExperiment.this.session.asyncRequest((Read)new ReadRequest(){

                            public void run(ReadGraph graph) throws DatabaseException {
                                if (OldSysdynExperiment.this.getState() == ExperimentState.RUNNING) {
                                    SimulationScheduler.start((this).OldSysdynExperiment.this.sysdynModel, OldSysdynExperiment.this);
                                }
                            }
                        });
                    }
                };
                this.sysdynModel.addModificationListener(this.modificationListener);
            }
        } else {
            this.changeState(ExperimentState.STOPPED);
            this.toggled = false;
        }
    }

    @Override
    protected void localStateChange() {
        this.setSysdynExperimentState(this.getState());
        switch (this.state) {
            case DISPOSED: {
                this.onExperimentDisposed();
                break;
            }
        }
    }

    @Override
    public ExperimentState getSysdynExperimentState() {
        return this.sysdynExperimentState;
    }

    @Override
    protected void setSysdynExperimentState(final ExperimentState state) {
        this.sysdynExperimentState = state;
        VirtualGraphSupport support = (VirtualGraphSupport)this.session.getService(VirtualGraphSupport.class);
        this.session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("experiments")){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SimulationResource SR = SimulationResource.getInstance((ReadGraph)graph);
                graph.deny(OldSysdynExperiment.this.model, SR.HasExperimentState);
                graph.deny(OldSysdynExperiment.this.experiment, SR.HasExperimentState);
                Resource st = graph.newResource();
                switch (state) {
                    case INITIALIZING: {
                        graph.claim(st, L0.InstanceOf, SR.ExperimentState_Initializing);
                        break;
                    }
                    case RUNNING: {
                        graph.claim(st, L0.InstanceOf, SR.ExperimentState_Running);
                        break;
                    }
                    case STOPPED: {
                        graph.claim(st, L0.InstanceOf, SR.ExperimentState_Stopped);
                        break;
                    }
                    case DISPOSED: {
                        graph.claim(st, L0.InstanceOf, SR.ExperimentState_Disposed);
                    }
                }
                graph.claim(OldSysdynExperiment.this.model, SR.HasExperimentState, st);
                graph.claim(OldSysdynExperiment.this.experiment, SR.HasExperimentState, st);
            }
        });
    }

    @Override
    protected void onExperimentDisposed() {
        this.cancelSimulation();
        this.sysdynModel.removeModificationListener(this.modificationListener);
        this.modificationListener = null;
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                OldSysdynExperiment.this.toggleActivation(graph, false);
            }
        });
    }

    @Override
    protected void toggleActivation(ReadGraph graph, final boolean activate) {
        VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        final Session session = graph.getSession();
        session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("experiments")){

            public void perform(WriteGraph graph) throws DatabaseException {
                VirtualGraph runtime = (VirtualGraph)graph.getService(VirtualGraph.class);
                session.asyncRequest((Write)new WriteRequest(runtime){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                        if (activate) {
                            graph.claim(OldSysdynExperiment.this.experiment, SIMU.IsActive, OldSysdynExperiment.this.experiment);
                        } else {
                            graph.denyStatement(OldSysdynExperiment.this.experiment, SIMU.IsActive, OldSysdynExperiment.this.experiment);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void resultsChanged() {
        this.resultsChanged(false);
    }

    protected void onPublishResults() {
        this.resultsChanged(true);
    }

    public void setPublishResults(boolean value) {
        this.publishResults = value;
        if (this.publishResults) {
            this.onPublishResults();
        }
    }

    public void resultsChanged(boolean force) {
        long time = System.nanoTime();
        long sinceLast = time - this.previousVariableUpdateTime;
        if (sinceLast > 100000000L || force) {
            this.updateSubscriptions();
            this.previousVariableUpdateTime = time;
        } else {
            this.skippedVariableUpdate = true;
        }
    }

    @Override
    public void updateSubscriptions() {
        if (this.publishResults) {
            this.publishRead.fire();
        }
        this.skippedVariableUpdate = false;
        SysdynVariableSessionManager.refreshVariablesByExperiment(this.getIdentifier());
    }

    public int numberOfSimulationRunSteps() {
        return 5;
    }

    @Override
    public Lock getDatasourceLock() {
        return null;
    }

    @Override
    public Datasource getDatasource() {
        return null;
    }

    @Override
    public void simulateDuration(double duration) {
    }

    @Override
    public void rewindTo(double time) {
    }

    public class PublishExternalRead
    extends ParametrizedPrimitiveRead<OldSysdynExperiment, Integer> {
        private int value;
        private Listener<Integer> listener;

        public PublishExternalRead(OldSysdynExperiment parameter) {
            super((Object)parameter);
            this.value = 0;
            this.listener = null;
        }

        public void register(ReadGraph graph, Listener<Integer> procedure) {
            procedure.execute((Object)this.value);
            if (procedure.isDisposed()) {
                return;
            }
            if (this.listener != null) {
                throw new RuntimeDatabaseException("Internal error");
            }
            this.listener = procedure;
        }

        public void unregistered() {
            this.listener = null;
        }

        public void fire() {
            ++this.value;
            if (this.listener != null) {
                this.listener.execute((Object)this.value);
            }
        }
    }
}

