/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn;

import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.ActiveDatasets;
import org.simantics.sysdyn.adapter.ValueIndexVariableI;
import org.simantics.sysdyn.adapter.ValueIndexVariableN;
import org.simantics.sysdyn.nodemanager.SysdynValueData;

public class Functions {
    public static String VALUE = "value";
    public static String VALUES = "values";
    public static String TIME = "time";
    public static String ACTIVE_DATASETS = "activeDatasets";
    public static String VALUE_DATA = "valueData";
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor valuePropertyValue = new ValueAccessor(){

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return context.getPropertyValue(graph, "");
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            return context.getPropertyValue(graph, "", binding);
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            throw new IllegalStateException();
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            throw new IllegalStateException();
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return All.getDatatypeFromValue((ReadGraph)graph, (Variable)context);
        }
    };
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor equationPropertyValue = new ValueAccessor(){

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return this.getValue(graph, context, (Binding)Bindings.STRING);
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            Variable v = context.getParent(graph);
            Resource represents = v.getPossibleRepresents(graph);
            if (represents != null) {
                SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                List res = ListUtils.toList((ReadGraph)graph, (Resource)graph.getSingleObject(represents, SYSDYN.Variable_expressionList));
                if (res.size() == 1) {
                    Resource exp = (Resource)res.iterator().next();
                    String text = (String)graph.getRelatedValue(exp, SYSDYN.Expression_equation, (Binding)Bindings.STRING);
                    return text;
                }
            }
            return null;
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            if (value instanceof Variant) {
                value = ((Variant)value).getValue();
            }
            if (!(value instanceof String)) {
                throw new DatabaseException("Unexpected value " + value + ", expected String");
            }
            this.setValue(graph, context, value, (Binding)Bindings.STRING);
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            if (value instanceof Variant) {
                value = ((Variant)value).getValue();
            }
            if (!(value instanceof String)) {
                throw new DatabaseException("Unexpected value " + value + ", expected String");
            }
            Variable v = context.getParent((ReadGraph)graph);
            Resource represents = v.getPossibleRepresents((ReadGraph)graph);
            if (represents != null) {
                SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                List res = ListUtils.toList((ReadGraph)graph, (Resource)graph.getSingleObject(represents, SYSDYN.Variable_expressionList));
                if (res.size() == 1) {
                    Resource exp = (Resource)res.iterator().next();
                    graph.claimLiteral(exp, SYSDYN.Expression_equation, value, (Binding)Bindings.STRING);
                }
            }
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return Datatypes.STRING;
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap valuePropertyProperties = new VariableMapImpl(){

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            SysdynValueData data = (SysdynValueData)((Object)context.getParent(graph).getPropertyValue(graph, VALUE_DATA));
            String property = context.getName(graph);
            if (VALUE.equals(property)) {
                if (name.startsWith("$")) {
                    Integer index = Integer.parseInt(name.substring(1));
                    return new ValueIndexVariableI(context, data, index, true);
                }
                return new ValueIndexVariableN(context, data, name, true);
            }
            if (VALUES.equals(property)) {
                if (name.startsWith("$")) {
                    Integer index = Integer.parseInt(name.substring(1));
                    return new ValueIndexVariableI(context, data, index, false);
                }
                return new ValueIndexVariableN(context, data, name, false);
            }
            if (ACTIVE_DATASETS.equals(property)) {
                return new ActiveDatasets(context, data, name);
            }
            return All.getStandardPropertyDomainPropertyVariableFromValue((ReadGraph)graph, (Variable)context, (String)name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            return map;
        }
    };
}

