/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.sysdyn.manager.InternalBasicExperimentFactory;
import org.simantics.sysdyn.manager.InternalGameExperimentFactory;
import org.simantics.sysdyn.manager.InternalSensitivityExperimentFactory;
import org.simantics.sysdyn.solver.ISolverProvider;
import org.simantics.sysdyn.solver.SolverSettings;
import org.simantics.sysdyn.solver.Solvers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private static BundleContext bundleContext;
    public static final String PLUGIN_ID = "org.simantics.sysdyn";
    private static Activator plugin;

    private static List<ISolverProvider> getDeclarativeServiceMappings() {
        ServiceReference[] serviceReferences = new ServiceReference[]{};
        try {
            serviceReferences = Activator.getBundleContext().getAllServiceReferences(ISolverProvider.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Could not get service references for " + ISolverProvider.class.getName(), (Throwable)e);
        }
        if (serviceReferences == null || serviceReferences.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ISolverProvider> services = new ArrayList<ISolverProvider>(serviceReferences.length);
        ServiceReference[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference reference = serviceReferenceArray[n2];
            ISolverProvider service = (ISolverProvider)Activator.getBundleContext().getService(reference);
            services.add(service);
            ++n2;
        }
        return services;
    }

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        File modelsDir = Activator.getBundleContext().getDataFile("models");
        if (!modelsDir.exists()) {
            modelsDir.mkdir();
        }
        plugin = this;
        Solvers.registerBasicExperimentFactory(SolverSettings.SolverType.INTERNAL, new InternalBasicExperimentFactory());
        Solvers.registerGameExperimentFactory(SolverSettings.SolverType.INTERNAL, new InternalGameExperimentFactory());
        Solvers.registerSensitivityExperimentFactory(SolverSettings.SolverType.INTERNAL, new InternalSensitivityExperimentFactory());
        for (ISolverProvider provider : Activator.getDeclarativeServiceMappings()) {
            provider.register();
        }
    }

    public void stop(BundleContext context) throws Exception {
        Solvers.unregisterBasicExperimentFactory(SolverSettings.SolverType.INTERNAL);
        Solvers.unregisterGameExperimentFactory(SolverSettings.SolverType.INTERNAL);
        Solvers.unregisterSensitivityExperimentFactory(SolverSettings.SolverType.INTERNAL);
        for (ISolverProvider provider : Activator.getDeclarativeServiceMappings()) {
            provider.unregister();
        }
        File modelsDir = Activator.getBundleContext().getDataFile("models");
        if (modelsDir.exists()) {
            Activator.recursiveDelete(modelsDir);
        }
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    private static boolean recursiveDelete(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            File[] fileArray = fileOrDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File innerFile = fileArray[n2];
                if (!Activator.recursiveDelete(innerFile)) {
                    return false;
                }
                ++n2;
            }
        }
        return fileOrDir.delete();
    }
}

