/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets.impl;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ISelectionUtils;

public abstract class ReadFactoryImpl<Input, Output>
implements ReadFactory<Input, Output> {
    final Class<?> inputClass = ReflectionUtils.getSingleParameterType(this.getClass());
    final boolean sync;

    protected ReadFactoryImpl() {
        this(false);
    }

    protected ReadFactoryImpl(boolean sync) {
        this.sync = sync;
    }

    public Object getIdentity(Object inputContents) {
        return new Pair(inputContents, this.getClass());
    }

    private Object getInputContents(Object input, Class<?> inputClass) {
        if (inputClass.isInstance(input)) {
            return input;
        }
        if (input instanceof ISelection) {
            return ISelectionUtils.filterSingleSelection((Object)input, inputClass);
        }
        return null;
    }

    @Override
    public void listen(ISessionContext context, Object input, Listener<Output> listener) {
        final Object inputContents = this.getInputContents(input, this.inputClass);
        if (inputContents != null) {
            UnaryRead read = new UnaryRead<Object, Output>(this.getIdentity(inputContents)){

                public Output perform(ReadGraph graph) throws DatabaseException {
                    return ReadFactoryImpl.this.perform(graph, inputContents);
                }

                public String toString() {
                    return ReadFactoryImpl.this.getIdentity(inputContents).toString();
                }
            };
            if (this.sync) {
                try {
                    Object out = context.getSession().syncRequest((Read)read, listener);
                    listener.execute(out);
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                }
            } else {
                context.getSession().asyncRequest((Read)read, listener);
            }
        }
    }

    public abstract Output perform(ReadGraph var1, Input var2) throws DatabaseException;
}

