/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.browsing.ui.graph.impl.GraphInputSources;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.swt.ContextMenuInitializer;
import org.simantics.browsing.ui.swt.DefaultKeyListener;
import org.simantics.browsing.ui.swt.DefaultMouseListener;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.IContextMenuInitializer;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.management.ISessionContext;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalSelectionDragSourceListener;
import org.simantics.ui.dnd.NoImageDragSourceEffect;
import org.simantics.utils.datastructures.Function;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.HintTracker;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public abstract class SimanticsDialog
extends Dialog {
    private final WidgetSupportImpl widgetSupport = new WidgetSupportImpl();
    protected IHintContext factoryHints = new HintContext();
    protected LocalResourceManager resourceManager;
    protected ISelectionListener workbenchSelectionListener;
    protected Composite parent;
    private Map<String, String> args;
    private ISessionContext sessionContext;
    protected IMemento memento;
    private SessionContextInputSource inputSource = GraphInputSources.projectSource();
    private DisposeState disposeState = DisposeState.Alive;
    private final String title;
    private Object currentInput;

    protected abstract void createControls(Composite var1, ISessionContext var2, WidgetSupport var3);

    public SimanticsDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Transfer[] getAcceptedDataTypes() {
        return new Transfer[]{LocalObjectTransfer.getTransfer()};
    }

    protected void handleDrop(Object data, NodeContext target) {
        Object input;
        if (target != null && (input = target.getConstant(BuiltinKeys.INPUT)) instanceof IDropTargetNode) {
            ((IDropTargetNode)input).drop(data);
        }
    }

    protected Object createDragSource(GraphExplorer explorer) {
        ISelectionProvider selectionProvider = (ISelectionProvider)explorer.getAdapter(ISelectionProvider.class);
        LocalSelectionDragSourceListener listener = new LocalSelectionDragSourceListener(selectionProvider);
        Control control = (Control)explorer.getControl();
        DragSource source = new DragSource(control, 23);
        source.setTransfer(new Transfer[]{LocalObjectTransfer.getTransfer()});
        source.addDragListener((DragSourceListener)listener);
        source.setDragSourceEffect((DragSourceEffect)new NoImageDragSourceEffect(control));
        return listener;
    }

    protected Set<String> getUiContexts() {
        return Collections.emptySet();
    }

    protected void setInputSource(SessionContextInputSource source) {
        this.inputSource = source;
    }

    protected SessionContextInputSource getInputSource() {
        return this.inputSource;
    }

    protected Map<String, String> getViewArguments() {
        return this.args;
    }

    protected DisposeState getDisposeState() {
        return this.disposeState;
    }

    public ISessionContext getSessionContext() {
        return Simantics.getSessionContext();
    }

    protected final void attachToSession() {
        this.sessionContext = this.getSessionContext();
        this.applySessionContext(this.sessionContext);
    }

    protected IContextMenuInitializer getContextMenuInitializer() {
        String contextMenuId = this.getContextMenuId();
        if (contextMenuId != null) {
            return new ContextMenuInitializer(contextMenuId);
        }
        return null;
    }

    protected String getContextMenuId() {
        return null;
    }

    protected int getStyle() {
        return 0;
    }

    protected GraphExplorer createExplorerControl(Composite parent) {
        return GraphExplorerFactory.getInstance().selectionDataResolver(new DefaultSelectionDataResolver()).create(parent, this.getStyle());
    }

    protected void addListeners(GraphExplorer explorer, IMenuManager menuManager) {
        this.addSelectionInputListeners(explorer, menuManager);
    }

    protected void addSelectionInputListeners(GraphExplorer explorer, IMenuManager menuManager) {
        explorer.addListener((Object)new DefaultKeyListener(Simantics.getSessionContextProvider(), explorer, new Function<String[]>(){

            public String[] execute(Object ... obj) {
                return new String[]{SimanticsDialog.this.getEditingColumn((NodeContext)obj[0])};
            }
        }));
        explorer.addListener((Object)new DefaultMouseListener(explorer));
    }

    protected String getEditingColumn(NodeContext context) {
        return "single";
    }

    protected boolean isImportantInput(Object previousInput, Object input) {
        return !Objects.equals(previousInput, input);
    }

    protected final boolean applySessionContext(ISessionContext context) {
        if (this.disposeState != DisposeState.Alive) {
            return false;
        }
        this.sessionContext = context;
        Object input = this.getInputSource().get(context);
        if (!this.isImportantInput(this.currentInput, input)) {
            return false;
        }
        this.currentInput = input;
        this.widgetSupport.fireInput(context, input);
        this.applySessionContext(context);
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createControls(composite, this.sessionContext, this.widgetSupport);
        this.attachToSession();
        return composite;
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Object getSelection() {
        return null;
    }

    public class SessionContextProjectTracker
    extends HintTracker {
        public SessionContextProjectTracker() {
            HintListenerAdapter activeProjectListener = new HintListenerAdapter(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    SimanticsDialog.this.applySessionContext(SimanticsDialog.this.getSessionContext());
                }
            };
            this.addKeyHintListener(ProjectKeys.KEY_PROJECT, (IHintListener)activeProjectListener);
        }
    }
}

