/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.State;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.Util;

public final class SpecialOperations {
    private SpecialOperations() {
    }

    static int findIndex(int c, int[] points) {
        int a = 0;
        int b = points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (points[d] > c) {
                b = d;
                continue;
            }
            if (points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    public static boolean isFinite(Automaton a) {
        if (a.isSingleton()) {
            return true;
        }
        return SpecialOperations.isFinite(a.initial, new BitSet(a.getNumberOfStates()), new BitSet(a.getNumberOfStates()));
    }

    private static boolean isFinite(State s, BitSet path, BitSet visited) {
        path.set(s.number);
        for (Transition t : s.getTransitions()) {
            if (!path.get(t.to.number) && (visited.get(t.to.number) || SpecialOperations.isFinite(t.to, path, visited))) continue;
            return false;
        }
        path.clear(s.number);
        visited.set(s.number);
        return true;
    }

    public static String getCommonPrefix(Automaton a) {
        boolean done;
        if (a.isSingleton()) {
            return a.singleton;
        }
        StringBuilder b = new StringBuilder();
        HashSet<State> visited = new HashSet<State>();
        State s = a.initial;
        do {
            done = true;
            visited.add(s);
            if (s.accept || s.numTransitions() != 1) continue;
            Transition t = s.getTransitions().iterator().next();
            if (t.min != t.max || visited.contains(t.to)) continue;
            b.appendCodePoint(t.min);
            s = t.to;
            done = false;
        } while (!done);
        return b.toString();
    }

    public static BytesRef getCommonPrefixBytesRef(Automaton a) {
        boolean done;
        if (a.isSingleton()) {
            return new BytesRef(a.singleton);
        }
        BytesRef ref = new BytesRef(10);
        HashSet<State> visited = new HashSet<State>();
        State s = a.initial;
        do {
            done = true;
            visited.add(s);
            if (s.accept || s.numTransitions() != 1) continue;
            Transition t = s.getTransitions().iterator().next();
            if (t.min != t.max || visited.contains(t.to)) continue;
            ref.grow(++ref.length);
            ref.bytes[ref.length - 1] = (byte)t.min;
            s = t.to;
            done = false;
        } while (!done);
        return ref;
    }

    public static String getCommonSuffix(Automaton a) {
        if (a.isSingleton()) {
            return a.singleton;
        }
        Automaton r = a.clone();
        SpecialOperations.reverse(r);
        r.determinize();
        return new StringBuilder(SpecialOperations.getCommonPrefix(r)).reverse().toString();
    }

    public static BytesRef getCommonSuffixBytesRef(Automaton a) {
        if (a.isSingleton()) {
            return new BytesRef(a.singleton);
        }
        Automaton r = a.clone();
        SpecialOperations.reverse(r);
        r.determinize();
        BytesRef ref = SpecialOperations.getCommonPrefixBytesRef(r);
        SpecialOperations.reverseBytes(ref);
        return ref;
    }

    private static void reverseBytes(BytesRef ref) {
        if (ref.length <= 1) {
            return;
        }
        int num = ref.length >> 1;
        for (int i = ref.offset; i < ref.offset + num; ++i) {
            byte b = ref.bytes[i];
            ref.bytes[i] = ref.bytes[ref.offset * 2 + ref.length - i - 1];
            ref.bytes[ref.offset * 2 + ref.length - i - 1] = b;
        }
    }

    public static Set<State> reverse(Automaton a) {
        a.expandSingleton();
        HashMap m = new HashMap();
        State[] states = a.getNumberedStates();
        HashSet<State> accept = new HashSet<State>();
        for (State s : states) {
            if (!s.isAccept()) continue;
            accept.add(s);
        }
        for (State r : states) {
            m.put(r, new HashSet());
            r.accept = false;
        }
        for (State r : states) {
            for (Transition t : r.getTransitions()) {
                ((HashSet)m.get(t.to)).add(new Transition(t.min, t.max, r));
            }
        }
        for (State r : states) {
            Set tr = (Set)m.get(r);
            r.setTransitions(tr.toArray(new Transition[tr.size()]));
        }
        a.initial.accept = true;
        a.initial = new State();
        for (State r : accept) {
            a.initial.addEpsilon(r);
        }
        a.deterministic = false;
        a.clearNumberedStates();
        return accept;
    }

    private static PathNode getNode(PathNode[] nodes, int index) {
        assert (index < nodes.length);
        if (nodes[index] == null) {
            nodes[index] = new PathNode();
        }
        return nodes[index];
    }

    public static Set<IntsRef> getFiniteStrings(Automaton a, int limit) {
        HashSet<IntsRef> results = new HashSet<IntsRef>();
        if (limit != -1 && limit <= 0) {
            throw new IllegalArgumentException("limit must be -1 (which means no limit), or > 0; got: " + limit);
        }
        if (a.isSingleton()) {
            results.add(Util.toUTF32(a.singleton, new IntsRef()));
        } else {
            if (a.initial.accept) {
                results.add(new IntsRef());
            }
            if (a.initial.numTransitions() > 0 && (limit == -1 || results.size() < limit)) {
                Set pathStates = Collections.newSetFromMap(new IdentityHashMap());
                PathNode[] nodes = new PathNode[4];
                pathStates.add(a.initial);
                PathNode root = SpecialOperations.getNode(nodes, 0);
                root.resetState(a.initial);
                IntsRef string = new IntsRef(1);
                string.length = 1;
                while (string.length > 0) {
                    PathNode node = nodes[string.length - 1];
                    int label = node.nextLabel();
                    if (label != -1) {
                        string.ints[string.length - 1] = label;
                        if (node.to.accept) {
                            results.add(IntsRef.deepCopyOf(string));
                            if (results.size() == limit) break;
                        }
                        if (node.to.numTransitions() == 0) continue;
                        if (pathStates.contains(node.to)) {
                            throw new IllegalArgumentException("automaton has cycles");
                        }
                        pathStates.add(node.to);
                        if (nodes.length == string.length) {
                            PathNode[] newNodes = new PathNode[ArrayUtil.oversize(nodes.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                            System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
                            nodes = newNodes;
                        }
                        SpecialOperations.getNode(nodes, string.length).resetState(node.to);
                        ++string.length;
                        string.grow(string.length);
                        continue;
                    }
                    assert (pathStates.contains(node.state));
                    pathStates.remove(node.state);
                    --string.length;
                }
            }
        }
        return results;
    }

    private static class PathNode {
        public State state;
        public State to;
        public int transition;
        public int label;

        private PathNode() {
        }

        public void resetState(State state) {
            assert (state.numTransitions() != 0);
            this.state = state;
            this.transition = 0;
            Transition t = state.transitionsArray[this.transition];
            this.label = t.min;
            this.to = t.to;
        }

        public int nextLabel() {
            if (this.label > this.state.transitionsArray[this.transition].max) {
                ++this.transition;
                if (this.transition >= this.state.numTransitions()) {
                    return -1;
                }
                Transition t = this.state.transitionsArray[this.transition];
                this.label = t.min;
                this.to = t.to;
            }
            return this.label++;
        }
    }
}

