/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.rules.range;

import java.lang.reflect.Field;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.rules.range.IRangeAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldAccessor<T>
implements IRangeAccessor<T> {
    static Logger LOGGER = LoggerFactory.getLogger((String)"org.simantics.objmap");
    Field field;

    public FieldAccessor(Field field) {
        this.field = field;
    }

    @Override
    public T get(Object element) throws MappingException {
        try {
            Object result = this.field.get(element);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.trace("        FieldAccessor.get " + this.field.getName() + " -> " + result);
            }
            return (T)result;
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean set(Object element, T value) throws MappingException {
        block5: {
            Object currentValue = this.field.get(element);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.trace("        FieldAccessor.set " + this.field.getName() + " " + currentValue + " -> " + value);
            }
            if (!(value == null ? currentValue == null || this.field.getType().isPrimitive() : value.equals(currentValue))) break block5;
            return false;
        }
        try {
            this.field.set(element, value);
            return true;
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
    }
}

