/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.omsolver;

import gnu.trove.list.array.TDoubleArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Write;
import org.simantics.fmu.FMUControlJNI;
import org.simantics.fmu.FMUJNIException;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modelica.ModelicaManager;
import org.simantics.modelica.SimulationLocation;
import org.simantics.modeling.PartialIC;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.omsolver.ModelicaSolver;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.sysdyn.solver.ISolverMonitor;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysdynGameExperimentOMC
extends SysdynGameExperimentBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysdynGameExperimentOMC.class);
    private ModelicaSolver solver = new ModelicaSolver((SysdynExperiment)this);
    public FMUControlJNI control;
    private boolean loaded = false;
    private static boolean fortranLibrariesLoaded = false;

    public SysdynGameExperimentOMC(Resource experiment, Resource model, String identifier) {
        super(experiment, model, identifier);
    }

    public FMUControlJNI getFMUControl() {
        return this.control;
    }

    public void init(ReadGraph g) throws DatabaseException {
        super.init(g);
        if (this.control == null) {
            this.control = new FMUControlJNI();
        }
        this.results = new TDoubleArrayList[this.results != null ? this.results.length : 0];
    }

    protected void onExperimentDisposed() {
        super.onExperimentDisposed();
        if (this.control != null) {
            try {
                this.control.unloadFMU();
                this.loaded = false;
            }
            catch (FMUJNIException e) {
                LOGGER.error("Failed to unload FMU", (Throwable)e);
            }
        }
    }

    private boolean isValidFMU(File file) {
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        return file.length() != 0L;
    }

    public synchronized void simulate(IModelicaMonitor monitor, IProgressMonitor progressMonitor, String modelName) throws IOException {
        this.canceled = false;
        progressMonitor.subTask("Write modelica classes");
        String modelText = this.getModelicaCode(monitor, true, this.getOpenModelicaVersion());
        if (modelText == null) {
            return;
        }
        omcVersion = ModelicaManager.getDefaultOMVersion();
        monitor.message("Simulate " + modelName + " using OpenModelica " + omcVersion);
        progressMonitor.worked(1);
        progressMonitor.subTask("Write simulation files");
        HashMap inits = this.getExperimentParameters(monitor);
        String additionalScript = this.getAdditionalScripts();
        SimulationLocation simulationLocation = this.createSimulationFiles(this.sysdynModel, modelText, inits, additionalScript, true);
        progressMonitor.worked(1);
        File fmu = null;
        if (!this.sysdynModel.isStructureModified()) {
            fmu = !simulationLocation.executableFile.isFile() ? this.loadModelFmu(simulationLocation) : simulationLocation.executableFile;
        }
        if (fmu == null && (!this.isValidFMU(simulationLocation.executableFile) || this.sysdynModel.isStructureModified())) {
            progressMonitor.subTask("Build model");
            this.buildModel(simulationLocation, monitor);
            this.saveModelFmu(simulationLocation);
        }
        progressMonitor.worked(1);
        if (simulationLocation != null && !this.canceled) {
            try {
                if (!fortranLibrariesLoaded) {
                    File omDir = ModelicaManager.getOMHome();
                    File mingw = new File(omDir, "MinGW");
                    File mbin = new File(mingw, "bin");
                    String newLibPath = String.valueOf(System.getProperty("java.library.path")) + File.pathSeparator + mbin.getAbsolutePath();
                    System.setProperty("java.library.path", newLibPath);
                    Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                    fieldSysPath.setAccessible(true);
                    if (fieldSysPath != null) {
                        fieldSysPath.set(System.class.getClassLoader(), null);
                    }
                    System.loadLibrary("libgfortran-3");
                    System.out.println("Loaded libgfortran-3.dll");
                    System.loadLibrary("pthreadGC2");
                    System.out.println("Loaded pthreadGC2.dll");
                    fortranLibrariesLoaded = true;
                }
                this.control.loadFMUFile(simulationLocation.executableFile.getAbsolutePath());
                this.loaded = true;
                this.instantiate();
            }
            catch (FMUJNIException e) {
                LOGGER.error("SysdynGameExperiment FMU initialization failed", (Throwable)e);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.error("SysdynGameExperiment initialization failed", (Throwable)e);
            }
        }
        this.process = null;
        this.simulate(false);
    }

    private File loadModelFmu(SimulationLocation simulationLocation) {
        try {
            File fmuLocation = simulationLocation.executableFile;
            return (File)this.session.syncRequest(graph -> {
                byte[] fileBArray;
                block3: {
                    try {
                        fileBArray = (byte[])graph.getPossibleRelatedValue(this.getModel(), SysdynResource.getInstance((ReadGraph)graph).SysdynModel_fmuFile, (Binding)Bindings.BYTE_ARRAY);
                        if (fileBArray != null) break block3;
                        return null;
                    }
                    catch (IOException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
                FileUtils.writeFile((File)fmuLocation, (byte[])fileBArray);
                return fmuLocation;
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to load model FMU file", (Throwable)e);
            return null;
        }
    }

    private void saveModelFmu(SimulationLocation simulationLocation) {
        File fmuLocation = simulationLocation.executableFile;
        this.session.asyncRequest(graph -> {
            try {
                byte[] fileBArray = FileUtils.readFile((File)fmuLocation);
                graph.claimLiteral(this.getModel(), SysdynResource.getInstance((ReadGraph)graph).SysdynModel_fmuFile, (Object)fileBArray, (Binding)Bindings.BYTE_ARRAY);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
        });
    }

    public void rewindTo(double time) {
        if (this.control == null) {
            return;
        }
        super.rewindTo(time);
    }

    public void refresh(Session session) {
        try {
            this.control.initializeSimulation();
            this.clearResults();
        }
        catch (FMUJNIException e) {
            LOGGER.error("SysdynGameExperiment initializeSimulation failed", (Throwable)e);
        }
    }

    private synchronized void instantiate() {
        try {
            HashMap inits = this.getExperimentParameters(null);
            this.control.setStepLength(this.stepLength);
            this.control.setTime(this.startTime);
            this.control.instantiateSimulation();
            if (!this.control.isInitialized()) {
                this.control.initializeSimulation();
            }
            this.subscription = inits.get("variableFilter") == null || ((String)inits.get("variableFilter")).equals(".*") ? this.control.getAllVariables() : this.control.filterVariables((String)inits.get("variableFilter"));
            if (this.subscriptionIndexes == null) {
                this.subscriptionIndexes = new HashMap();
            }
            this.subscriptionIndexes.clear();
            int i = 0;
            while (i < this.subscription.length) {
                this.subscriptionIndexes.put(this.subscription[i], i);
                ++i;
            }
            this.results = new TDoubleArrayList[this.subscription.length];
            this.currentValues = new double[this.subscription.length];
            this.control.subscribe(this.subscription);
            this.clearResults();
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource run = CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)SysdynGameExperimentOMC.this.experiment, (String)SysdynGameExperimentOMC.this.getIdentifier());
                    if (run == null) {
                        LOGGER.warn("No run in GameExperiment.instantiate");
                        return;
                    }
                    Variable base = Variables.getVariable((ReadGraph)graph, (Resource)run);
                    SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                    Resource ic = graph.getPossibleObject(SysdynGameExperimentOMC.this.experiment, SYSDYN.Experiment_ic);
                    if (ic == null) {
                        return;
                    }
                    PartialIC data = (PartialIC)graph.getPossibleRelatedValue(ic, SYSDYN.InitialCondition_HasInitialValues, PartialIC.BINDING);
                    data.apply(graph, base);
                }
            });
        }
        catch (FMUJNIException e) {
            LOGGER.error("GameExperiment FMU instantiate failed", (Throwable)e);
        }
        catch (DatabaseException e) {
            LOGGER.error("GameExperiment instantiate failed due to unexpected database error", (Throwable)e);
        }
    }

    public void updateSubscriptions() {
        if (!this.loaded) {
            return;
        }
        try {
            if (this.control.isInitialized()) {
                this.currentValues = this.control.getSubscribedResults(this.currentValues);
            }
        }
        catch (FMUJNIException e) {
            LOGGER.error("FMU getSubscribedResults failed", (Throwable)e);
        }
        super.updateSubscriptions();
    }

    public ISolver getSolver() {
        return this.solver;
    }

    public void createSolver(ISolverMonitor solverMonitor) {
        this.solver = new ModelicaSolver((SysdynExperiment)this);
    }
}

