/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryIdentityHashSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializer;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheEntryBase<Procedure>
extends CacheEntry<Procedure> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheEntryBase.class);
    public static final short UNDEFINED_LEVEL = 5;
    public short level = (short)5;
    public short age = 0;
    public int GCStatus = 0;
    public static final CacheEntryBase[] NONE = new CacheEntryBase[0];
    static Object NO_RESULT = new Object(){

        public String toString() {
            return "NO_RESULT";
        }
    };
    protected static Object INVALID_RESULT = new Object(){

        public String toString() {
            return "INVALID_RESULT";
        }
    };
    protected static Object READY = new Object(){

        public String toString() {
            return "READY";
        }
    };
    protected static Object PENDING = new Object(){

        public String toString() {
            return "PENDING";
        }
    };
    protected static Object DISCARDED = new Object(){

        public String toString() {
            return "DISCARDED";
        }
    };
    protected static Object REQUIRES_COMPUTATION = new Object(){

        public String toString() {
            return "REFUTED";
        }
    };
    protected static Object EXCEPTED = new Object(){

        public String toString() {
            return "EXCEPTED";
        }
    };
    public Object statusOrException = REQUIRES_COMPUTATION;
    private CacheEntry p1 = null;
    private Object p2OrParents = null;
    private int hash = 0;
    Object result = NO_RESULT;

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = this.makeHash();
        }
        return this.hash;
    }

    abstract int makeHash();

    @Override
    public final boolean isFresh() {
        return REQUIRES_COMPUTATION == this.statusOrException;
    }

    @Override
    public void setReady() {
        assert (this.result != NO_RESULT);
        this.statusOrException = READY;
    }

    @Override
    @Deprecated
    public final boolean isReady() {
        return READY == this.statusOrException || EXCEPTED == this.statusOrException;
    }

    @Override
    public void discard() {
        this.statusOrException = DISCARDED;
        this.result = NO_RESULT;
    }

    @Override
    public final boolean isDiscarded() {
        return DISCARDED == this.statusOrException;
    }

    @Override
    public final void refute() {
        this.statusOrException = REQUIRES_COMPUTATION;
    }

    @Override
    public final boolean isRefuted() {
        return REQUIRES_COMPUTATION == this.statusOrException;
    }

    @Override
    public void except(Throwable throwable) {
        if (this.statusOrException != DISCARDED) {
            this.statusOrException = EXCEPTED;
            this.result = throwable;
        } else {
            LOGGER.warn("Cache entry got excepted status after being discarded: " + this.getClass().getSimpleName(), throwable);
            this.result = throwable;
        }
    }

    public final void checkAndThrow() throws DatabaseException {
        if (this.isExcepted()) {
            Throwable throwable = (Throwable)this.result;
            if (throwable instanceof DatabaseException) {
                throw (DatabaseException)throwable;
            }
            throw new DatabaseException(throwable);
        }
    }

    @Override
    public final boolean isExcepted() {
        return EXCEPTED == this.statusOrException;
    }

    @Override
    public void setPending(QuerySupport querySupport) {
        this.statusOrException = PENDING;
        this.clearResult(querySupport);
    }

    @Override
    public final boolean isPending() {
        return PENDING == this.statusOrException;
    }

    public final boolean requiresComputation() {
        return REQUIRES_COMPUTATION == this.statusOrException;
    }

    public final boolean assertPending() {
        boolean result = this.isPending();
        if (!result) {
            LOGGER.warn("Assertion failed, expected pending, got " + this.statusOrException);
        }
        return result;
    }

    public final boolean assertNotPending() {
        boolean result;
        boolean bl = result = !this.isPending();
        if (!result) {
            new Exception(this + ": Assertion failed, expected not pending, got " + this.statusOrException).printStackTrace();
        }
        return result;
    }

    public final boolean assertNotDiscarded() {
        boolean result;
        boolean bl = result = !this.isDiscarded();
        if (!result) {
            new Exception(this + ": Assertion failed, expected not discarded, got " + this.statusOrException).printStackTrace();
        }
        return result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public final <T> T getResult() {
        assert (this.statusOrException != DISCARDED);
        return (T)this.result;
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(NO_RESULT);
    }

    @Override
    public final void addParent(CacheEntry entry) {
        assert (entry != null);
        if (this.p1 == entry) {
            return;
        }
        if (this.p2OrParents == entry) {
            return;
        }
        if (this.p1 == null) {
            this.p1 = entry;
        } else if (this.p2OrParents == null) {
            this.p2OrParents = entry;
        } else if (this.p2OrParents instanceof QueryIdentityHashSet) {
            ((QueryIdentityHashSet)this.p2OrParents).add(entry);
            ((QueryIdentityHashSet)this.p2OrParents).purge();
        } else {
            CacheEntry tmp = (CacheEntry)this.p2OrParents;
            this.p2OrParents = new QueryIdentityHashSet(2);
            ((QueryIdentityHashSet)this.p2OrParents).add(tmp);
            ((QueryIdentityHashSet)this.p2OrParents).add(entry);
        }
    }

    @Override
    CacheEntry pruneFirstParents() {
        if (this.p1 == null) {
            return null;
        }
        if (!this.p1.isDiscarded()) {
            return this.p1;
        }
        this.p1 = null;
        if (this.p2OrParents instanceof QueryIdentityHashSet) {
            QueryIdentityHashSet set = (QueryIdentityHashSet)this.p2OrParents;
            CacheEntry entry = set.removeDiscarded();
            if (entry == null) {
                this.p2OrParents = null;
            }
            this.p1 = entry;
            return this.p1;
        }
        if (this.p2OrParents instanceof CacheEntry) {
            CacheEntry entry = (CacheEntry)this.p2OrParents;
            if (entry.isDiscarded()) {
                this.p2OrParents = null;
                return null;
            }
            this.p1 = entry;
            this.p2OrParents = null;
            return this.p1;
        }
        return null;
    }

    @Override
    void pruneParentSet() {
        CacheEntry entry;
        if (this.p2OrParents instanceof QueryIdentityHashSet) {
            QueryIdentityHashSet set = (QueryIdentityHashSet)this.p2OrParents;
            set.removeDiscardedReally();
            if (set.isEmpty()) {
                this.p2OrParents = null;
            }
        } else if (this.p2OrParents instanceof CacheEntry && (entry = (CacheEntry)this.p2OrParents).isDiscarded()) {
            this.p2OrParents = null;
        }
    }

    @Override
    public final void removeParent(CacheEntry entry) {
        if (this.p1 == null) {
            if (this.p2OrParents != null) {
                throw new Error("CacheEntryBase.removeParent: corrupted parents (p1 == null, while p2OrParents != null).");
            }
            throw new Error("CacheEntryBase.removeParent: no parents.");
        }
        if (this.p1 == entry) {
            if (this.p2OrParents == null) {
                this.p1 = null;
            } else if (this.p2OrParents instanceof QueryIdentityHashSet) {
                QueryIdentityHashSet set = (QueryIdentityHashSet)this.p2OrParents;
                int size = set.size();
                if (size == 0) {
                    this.p1 = null;
                    this.p2OrParents = null;
                } else if (size == 1) {
                    CacheEntry next;
                    this.p1 = next = set.iterator().next();
                    set = null;
                } else if (set.size() == 2) {
                    Iterator<CacheEntry> iterator = set.iterator();
                    this.p1 = iterator.next();
                    this.p2OrParents = iterator.next();
                } else {
                    this.p1 = set.iterator().next();
                    set.remove(this.p1);
                }
            } else {
                this.p1 = (CacheEntry)this.p2OrParents;
                this.p2OrParents = null;
            }
        } else if (this.p2OrParents.getClass() == QueryIdentityHashSet.class) {
            QueryIdentityHashSet set = (QueryIdentityHashSet)this.p2OrParents;
            boolean success = set.remove(entry);
            if (!success) {
                throw new Error("CacheEntryBase.removeParent: parent was not found.");
            }
            assert (set.size() >= 1);
            if (set.size() == 1) {
                this.p2OrParents = set.iterator().next();
            }
        } else if (this.p2OrParents == entry) {
            this.p2OrParents = null;
        } else {
            throw new Error("CacheEntryBase.removeParent: had 2 parents but neither was removed.");
        }
    }

    @Override
    public final boolean hasParents() {
        assert (this.statusOrException != DISCARDED);
        return this.p1 != null;
    }

    @Override
    public final Collection<CacheEntry<?>> getParents(QueryProcessor processor) {
        ArrayList result = new ArrayList();
        if (this.p1 != null) {
            result.add(this.p1);
        }
        if (this.p2OrParents != null) {
            if (this.p2OrParents instanceof QueryIdentityHashSet) {
                for (CacheEntry entry : (QueryIdentityHashSet)this.p2OrParents) {
                    result.add(entry);
                }
            } else {
                result.add((CacheEntry)this.p2OrParents);
            }
        }
        this.fillImpliedParents(processor, result);
        return result;
    }

    @Override
    CacheEntry getFirstParent(QueryProcessor processor) {
        return this.p1;
    }

    @Override
    boolean moreThanOneParent(QueryProcessor processor) {
        return this.p2OrParents != null;
    }

    @Override
    int parentCount(QueryProcessor processor) {
        if (this.p2OrParents != null) {
            if (this.p2OrParents instanceof QueryIdentityHashSet) {
                return ((QueryIdentityHashSet)this.p2OrParents).size() + 1;
            }
            return 2;
        }
        return this.p1 != null ? 1 : 0;
    }

    protected void fillImpliedParents(QueryProcessor processor, ArrayList<CacheEntry<?>> result) {
    }

    protected String internalError() {
        return String.valueOf(this.toString()) + " " + this.statusOrException + " " + this.result;
    }

    protected boolean handleException(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    protected boolean handleException(ReadGraphImpl graph, TripleIntProcedure procedure) throws DatabaseException {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    protected <T> boolean handleException(ReadGraphImpl graph, InternalProcedure<T> procedure) throws DatabaseException {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) throws DatabaseException {
        return false;
    }

    @Override
    boolean shouldBeCollected() {
        return true;
    }

    @Override
    short getLevel() {
        return this.level;
    }

    @Override
    short setLevel(short level) {
        short existing = this.level;
        this.level = level;
        return existing;
    }

    @Override
    void prepareRecompute(QuerySupport querySupport) {
        this.setPending(querySupport);
    }

    @Override
    int getGCStatus() {
        return this.GCStatus;
    }

    @Override
    int setGCStatus(int status) {
        this.GCStatus = status;
        return this.GCStatus;
    }

    @Override
    void setGCStatusFlag(int flag, boolean value) {
        this.GCStatus = value ? (this.GCStatus |= flag) : (this.GCStatus &= ~flag);
    }

    @Override
    public Object getOriginalRequest() {
        return this.getQuery();
    }

    public String classId() {
        return this.getClass().getName();
    }

    public void serializeKey(QuerySerializer serializer) {
        throw new IllegalStateException("Cannot serialize query key for " + this);
    }

    public void serializeValue(QuerySerializer serializer) {
        throw new IllegalStateException("Cannot serialize query value for " + this);
    }

    public void serializeParents(QuerySerializer serializer) {
        Collection<CacheEntry<?>> ps = this.getParents(serializer.getQueryProcessor());
        int sizePos = serializer.writeUnknownSize();
        int actual = 0;
        for (CacheEntry<?> entry : ps) {
            CacheEntryBase b = (CacheEntryBase)entry;
            String cid = b.classId();
            if (cid == null) continue;
            serializer.serializeId(b.classId());
            b.serializeKey(serializer);
            ++actual;
        }
        serializer.setUnknownSize(sizePos, actual);
    }

    public long cluster(QueryProcessor processor) {
        throw new IllegalStateException("Cannot compute query cluster for " + this);
    }

    public void serialize(QuerySerializer serializer) {
        serializer.serializeId(this.classId());
        this.serializeKey(serializer);
        this.serializeValue(serializer);
        this.serializeParents(serializer);
    }
}

