/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.acorn.cluster.ClusterBig;
import org.simantics.acorn.cluster.ClusterSmall;
import org.simantics.acorn.internal.Change;
import org.simantics.acorn.internal.ClusterChange;
import org.simantics.acorn.internal.ClusterSupport2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidClusterException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.impl.Modifier;
import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.utils.strings.AlphanumComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterImpl
extends ClusterBase
implements Modifier,
ClusterCollectorPolicy.CollectorCluster {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterImpl.class);
    protected static final int LONG_HEADER_SIZE = 7;
    protected static final long LONG_HEADER_VERSION = 1L;
    static final boolean DEBUG = false;
    public final IClusterTable clusterTable;
    public Change change = new Change();
    public ClusterChange cc;
    public byte[] foreignLookup;
    private boolean dirtySizeInBytes = true;
    private long sizeInBytes = 0L;

    protected static ClusterUID checkValidity(long type, long[] longs, int[] ints, byte[] bytes) throws InvalidClusterException {
        if (longs.length < 7) {
            throw new InvalidClusterException("Header size mismatch. Expected=7, got=" + longs.length);
        }
        if (longs[0] != type) {
            throw new InvalidClusterException("Type mismatch. Expected=" + type + ", got=" + longs[0] + " " + ClusterUID.make((long)longs[2], (long)longs[3]));
        }
        if (longs[1] != 1L) {
            throw new InvalidClusterException("Header size mismatch. Expected=1, got=" + longs[1]);
        }
        return ClusterUID.make((long)longs[2], (long)longs[3]);
    }

    protected static ClusteringSupport.Id getUniqueId(long[] longs) {
        return new ClusterBase.IdImpl(new UUID(longs[3], longs[4]));
    }

    protected ClusterImpl() {
        this.clusterTable = null;
    }

    public ClusterImpl(IClusterTable clusterTable, ClusterUID clusterUID, int clusterKey, ClusterSupport support) {
        super(support, clusterUID, clusterKey);
        this.clusterTable = clusterTable;
    }

    public static ClusterImpl dummy() {
        return new ClusterSmall();
    }

    public static ClusterImpl make(IClusterTable clusterTable, ClusterUID clusterUID, int clusterKey, ClusterSupport2 support) {
        return new ClusterSmall(clusterUID, clusterKey, support, clusterTable);
    }

    public static ClusterSmall proxy(IClusterTable clusterTable, ClusterUID clusterUID, int clusterKey, long clusterId, ClusterSupport2 support) {
        return new ClusterSmall(null, clusterUID, clusterKey, support);
    }

    public static ClusterImpl make(IClusterTable clusterTable, long[] longs, int[] ints, byte[] bytes, ClusterSupport2 support, int clusterKey) throws DatabaseException {
        if (longs[0] == 0L) {
            return new ClusterBig(clusterTable, longs, ints, bytes, support, clusterKey);
        }
        return new ClusterSmall(clusterTable, longs, ints, bytes, support, clusterKey);
    }

    public boolean hasVirtual() {
        return false;
    }

    public void markVirtual() {
    }

    public boolean isWriteOnly() {
        return false;
    }

    public boolean isLoaded() {
        return true;
    }

    public void resized() {
        this.dirtySizeInBytes = true;
    }

    public long getCachedSize() {
        if (this.dirtySizeInBytes) {
            try {
                this.sizeInBytes = this.getUsedSpace();
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to get used space by cluster {}", (Object)this.getClusterUID(), (Object)e);
            }
            this.dirtySizeInBytes = false;
        }
        return this.sizeInBytes;
    }

    protected void calculateModifiedId() {
    }

    public byte[] storeBytes() throws IOException {
        throw new UnsupportedOperationException();
    }

    public ClusterTables store() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected abstract int getResourceTableCount();

    public boolean hasStatements(final ClusterSupport support) {
        final AtomicBoolean found = new AtomicBoolean(false);
        int count = this.getResourceTableCount();
        int i = 1;
        while (i < count) {
            final int resourceKey = i;
            try {
                this.forPredicates(i, (ClusterI.PredicateProcedure)new ClusterI.PredicateProcedure<Integer>(){

                    public boolean execute(Integer c, int predicateKey, int objectIndex) {
                        try {
                            ClusterImpl.this.forObjects(resourceKey, predicateKey, objectIndex, (ClusterI.ObjectProcedure)new ClusterI.ObjectProcedure<Integer>(){

                                public boolean execute(Integer context, int objectKey) throws DatabaseException {
                                    found.set(true);
                                    return true;
                                }
                            }, 0, support);
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("Failed to retrieve objects for ({}, {}, {}) in {}", new Object[]{resourceKey, predicateKey, objectIndex, ClusterImpl.this.getClusterUID(), e});
                        }
                        return found.get();
                    }
                }, 0, support);
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to retrieve predicates for resource {} in {}", new Object[]{resourceKey, this.getClusterUID(), e});
            }
            if (found.get()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String dump(final ClusterSupport support) {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i < this.getResourceTableCount()) {
            sb.append(i + "\n");
            final int resourceKey = i;
            final ArrayList stms = new ArrayList();
            try {
                byte[] value = this.getValue(i, support);
                if (value != null) {
                    sb.append(" bytes: " + Arrays.toString(value) + "\n");
                }
                this.forPredicates(i, (ClusterI.PredicateProcedure)new ClusterI.PredicateProcedure<Integer>(){

                    public boolean execute(Integer c, final int predicateKey, int objectIndex) {
                        try {
                            ClusterImpl.this.forObjects(resourceKey, predicateKey, objectIndex, (ClusterI.ObjectProcedure)new ClusterI.ObjectProcedure<Integer>(){

                                public boolean execute(Integer context, int objectKey) throws DatabaseException {
                                    ClusterUID puid = support.getClusterByResourceKey(predicateKey).getClusterUID();
                                    ClusterUID ouid = support.getClusterByResourceKey(objectKey).getClusterUID();
                                    stms.add(" " + puid + " " + (predicateKey & 0xFFF) + " " + ouid + " " + (objectKey & 0xFFF));
                                    return false;
                                }
                            }, 0, support);
                        }
                        catch (DatabaseException e) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                }, 0, support);
                Collections.sort(stms, AlphanumComparator.COMPARATOR);
                for (String s : stms) {
                    sb.append(s);
                    sb.append("\n");
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return sb.toString();
    }

    public abstract boolean isValueEx(int var1) throws DatabaseException;

    public abstract ClusterI addRelation(int var1, ClusterUID var2, int var3, ClusterUID var4, int var5, ClusterSupport var6) throws DatabaseException;

    public IClusterTable getClusterTable() {
        return this.clusterTable;
    }

    public static class ClusterTables {
        public byte[] bytes;
        public int[] ints;
        public long[] longs;
    }
}

