/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.acorn.FileCache;
import org.simantics.acorn.FileIO;
import org.simantics.acorn.HeadState;
import org.simantics.acorn.MainState;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.exception.InvalidHeadStateException;
import org.simantics.acorn.internal.ClusterSupport2;
import org.simantics.acorn.lru.ChangeSetInfo;
import org.simantics.acorn.lru.ClusterInfo;
import org.simantics.acorn.lru.ClusterLRU;
import org.simantics.acorn.lru.ClusterStreamChunk;
import org.simantics.acorn.lru.FileInfo;
import org.simantics.acorn.lru.LRU;
import org.simantics.db.ClusterCreator;
import org.simantics.db.Database;
import org.simantics.db.ServiceLocator;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.service.ClusterSetsSupport;
import org.simantics.db.service.ClusterUID;
import org.simantics.utils.FileUtils;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager {
    static final Logger LOGGER = LoggerFactory.getLogger(ClusterManager.class);
    private ArrayList<String> currentChanges = new ArrayList();
    public final Path dbFolder;
    private FileCache fileCache;
    Path lastSessionDirectory;
    Path workingDirectory;
    public LRU<String, ClusterStreamChunk> streamLRU;
    public LRU<Long, ChangeSetInfo> csLRU;
    public ClusterLRU clusterLRU;
    public LRU<String, FileInfo> fileLRU;
    public MainState mainState;
    public HeadState state;
    private long lastSnapshot = System.nanoTime();
    public final ClusterSupport2 support = new ClusterSupport2(this);
    private AtomicBoolean safeToMakeSnapshot = new AtomicBoolean(true);
    private IllegalAcornStateException cause;
    private AtomicBoolean rollback = new AtomicBoolean(false);
    static Map<String, ITask> tasks = new HashMap<String, ITask>();

    public ClusterManager(Path dbFolder, FileCache fileCache) {
        this.dbFolder = dbFolder;
        this.fileCache = fileCache;
    }

    public ArrayList<String> getChanges(long changeSetId) throws AcornAccessVerificationException, IllegalAcornStateException {
        ChangeSetInfo info = this.csLRU.getWithoutMutex(changeSetId);
        info.acquireMutex();
        try {
            info.makeResident();
            ArrayList<String> arrayList = info.getCCSIds();
            return arrayList;
        }
        finally {
            info.releaseMutex();
        }
    }

    public ClusterBase getClusterByClusterKey(int clusterKey) throws DatabaseException, AcornAccessVerificationException, IllegalAcornStateException {
        return this.clusterLRU.getClusterByClusterKey(clusterKey);
    }

    public ClusterBase getClusterByClusterUIDOrMake(ClusterUID clusterUID) throws DatabaseException, AcornAccessVerificationException, IllegalAcornStateException {
        return this.clusterLRU.getClusterByClusterUIDOrMake(clusterUID);
    }

    public ClusterImpl getClusterByClusterUIDOrMakeProxy(ClusterUID clusterUID) throws DatabaseException, AcornAccessVerificationException, IllegalAcornStateException {
        return (ClusterImpl)((Object)this.clusterLRU.getClusterByClusterUIDOrMakeProxy(clusterUID));
    }

    public int getClusterKeyByClusterUIDOrMake(ClusterUID clusterUID) throws AcornAccessVerificationException {
        return this.clusterLRU.getClusterKeyByClusterUIDOrMake(clusterUID);
    }

    public int getClusterKeyByClusterUIDOrMakeWithoutMutex(ClusterUID clusterUID) throws IllegalAcornStateException, AcornAccessVerificationException {
        return this.clusterLRU.getClusterKeyByClusterUIDOrMakeWithoutMutex(clusterUID);
    }

    public int getClusterKeyByUID(long id1, long id2) throws DatabaseException, IllegalAcornStateException {
        return this.clusterLRU.getClusterKeyByUIDWithoutMutex(id1, id2);
    }

    public <T extends ClusterI> T getClusterProxyByResourceKey(int resourceKey) throws DatabaseException, AcornAccessVerificationException, IllegalAcornStateException {
        return this.clusterLRU.getClusterProxyByResourceKey(resourceKey);
    }

    public ClusterUID getClusterUIDByResourceKey(int resourceKey) throws DatabaseException, AcornAccessVerificationException {
        return this.clusterLRU.getClusterUIDByResourceKey(resourceKey);
    }

    public ClusterUID getClusterUIDByResourceKeyWithoutMutex(int resourceKey) throws DatabaseException, IllegalAcornStateException, AcornAccessVerificationException {
        return this.clusterLRU.getClusterUIDByResourceKeyWithoutMutex(resourceKey);
    }

    private static long countFiles(Path directory) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(directory);){
            int count = 0;
            Iterator<Path> iterator = ds.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            return count;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public synchronized void purge(ServiceLocator locator) throws IllegalAcornStateException {
        try {
            String[] parts;
            HashSet<String> emptyClusters = new HashSet<String>();
            for (String clusterKey : this.state.clusters) {
                String[] parts1 = clusterKey.split("#");
                String[] parts2 = parts1[0].split("\\.");
                long first = new BigInteger(parts2[0], 16).longValue();
                long second = new BigInteger(parts2[1], 16).longValue();
                ClusterUID uuid = ClusterUID.make((long)first, (long)second);
                ClusterInfo info = (ClusterInfo)this.clusterLRU.getWithoutMutex(uuid);
                info.acquireMutex();
                try {
                    try {
                        ClusterImpl impl = info.getCluster();
                        if (!impl.hasStatements(this.support)) {
                            emptyClusters.add(clusterKey);
                        }
                    }
                    catch (IllegalAcornStateException e) {
                        emptyClusters.add(clusterKey);
                        LOGGER.info("Failed to load cluster {}", (Object)uuid, (Object)e);
                        info.releaseMutex();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    info.releaseMutex();
                    throw throwable;
                }
                info.releaseMutex();
            }
            this.refreshHeadState();
            this.synchronizeWorkingDirectory();
            String currentDir = this.workingDirectory.getFileName().toString();
            Path baseline = this.workingDirectory.resolveSibling(String.valueOf(currentDir) + "_baseline");
            Files.createDirectories(baseline, new FileAttribute[0]);
            ArrayList<String> clustersToProcess = new ArrayList<String>(this.state.clusters);
            for (String clusterKey : clustersToProcess) {
                String[] parts1 = clusterKey.split("#");
                String[] parts3 = parts1[0].split("\\.");
                String readDirName = parts1[1];
                if (readDirName.equals(currentDir)) continue;
                long first = new BigInteger(parts3[0], 16).longValue();
                long second = new BigInteger(parts3[1], 16).longValue();
                ClusterUID uuid = ClusterUID.make((long)first, (long)second);
                if (emptyClusters.contains(clusterKey)) {
                    this.state.clusters.remove(clusterKey);
                    this.clusterLRU.purge(uuid);
                    LOGGER.info("purge drops empty cluster {}", (Object)uuid);
                    continue;
                }
                String fileName = String.valueOf(parts3[0]) + "." + parts3[1] + ".cluster";
                Path from = this.dbFolder.resolve(readDirName).resolve(fileName);
                Path to = baseline.resolve(fileName);
                LOGGER.info("purge copies {}  => {}", (Object)from, (Object)to);
                Files.copy(from, to, StandardCopyOption.COPY_ATTRIBUTES);
                ClusterInfo info = (ClusterInfo)this.clusterLRU.getWithoutMutex(uuid);
                info.moveTo(baseline);
            }
            for (String fileKey : this.state.files) {
                parts = fileKey.split("#");
                String readDirName = parts[1];
                if (readDirName.equals(currentDir)) continue;
                String fileName = String.valueOf(parts[0]) + ".extFile";
                Path from = this.dbFolder.resolve(readDirName).resolve(fileName);
                Path to = baseline.resolve(fileName);
                LOGGER.info("purge copies " + from + "  => " + to);
                Files.copy(from, to, StandardCopyOption.COPY_ATTRIBUTES);
                FileInfo info = this.fileLRU.getWithoutMutex(parts[0]);
                info.moveTo(baseline);
            }
            for (String fileKey : this.state.stream) {
                parts = fileKey.split("#");
                String readDirName = parts[1];
                if (readDirName.equals(currentDir)) continue;
                ClusterStreamChunk chunk = this.streamLRU.purge(parts[0]);
                LOGGER.info("purge removes " + chunk);
            }
            for (String fileKey : this.state.cs) {
                parts = fileKey.split("#");
                String readDirName = parts[1];
                if (readDirName.equals(currentDir)) continue;
                Long revisionId = Long.parseLong(parts[0]);
                ChangeSetInfo info = this.csLRU.purge(revisionId);
                LOGGER.info("purge removes " + info);
            }
            this.state.tailChangeSetId = this.state.headChangeSetId;
            this.makeSnapshot(locator, true);
            Files.walk(this.dbFolder, 1, new FileVisitOption[0]).filter(path -> Files.isDirectory(path, new LinkOption[0])).forEach(f -> this.tryPurgeDirectory((Path)f));
        }
        catch (IllegalAcornStateException e) {
            this.notSafeToMakeSnapshot(e);
            throw e;
        }
        catch (IOException e) {
            IllegalAcornStateException e1 = new IllegalAcornStateException(e);
            this.notSafeToMakeSnapshot(e1);
            throw e1;
        }
        catch (AcornAccessVerificationException e) {
            IllegalAcornStateException e1 = new IllegalAcornStateException((Throwable)((Object)e));
            this.notSafeToMakeSnapshot(e1);
            throw e1;
        }
    }

    void tryPurgeDirectory(Path f) {
        int ordinal;
        LOGGER.info("purge deletes " + f);
        String currentDir = f.getFileName().toString();
        if (currentDir.endsWith("db")) {
            return;
        }
        if (currentDir.endsWith("_baseline")) {
            currentDir = currentDir.replace("_baseline", "");
        }
        if ((ordinal = Integer.parseInt(currentDir)) < this.mainState.headDir - 1) {
            LOGGER.info("purge deletes " + f);
            FileUtils.deleteDir((File)f.toFile());
        }
    }

    public synchronized boolean makeSnapshot(ServiceLocator locator, boolean fullSave) throws IllegalAcornStateException {
        long amountOfFiles;
        block9: {
            block8: {
                if (!this.safeToMakeSnapshot.get()) {
                    throw this.cause;
                }
                if (fullSave || System.nanoTime() - this.lastSnapshot >= 10000000000L) break block8;
                return false;
            }
            amountOfFiles = ClusterManager.countFiles(this.workingDirectory);
            if (fullSave || amountOfFiles != 0L) break block9;
            return false;
        }
        try {
            LOGGER.info("makeSnapshot: start with " + amountOfFiles + " files");
            this.refreshHeadState();
            this.clusterLRU.shutdown();
            this.fileLRU.shutdown();
            this.streamLRU.shutdown();
            this.csLRU.shutdown();
            if (!this.safeToMakeSnapshot.get()) {
                throw this.cause;
            }
            ClusterSetsSupport cssi = (ClusterSetsSupport)locator.getService(ClusterSetsSupport.class);
            Database.Session.ClusterIds ids = this.getClusterIds();
            cssi.validate(ids.getSecond());
            cssi.save();
            this.persistHeadState();
            if (LOGGER.isInfoEnabled()) {
                amountOfFiles = ClusterManager.countFiles(this.workingDirectory);
                LOGGER.info(" -finished: amount of files is {}", (Object)amountOfFiles);
            }
            this.workingDirectory = this.dbFolder.resolve(Integer.toString(this.mainState.headDir));
            Files.createDirectories(this.workingDirectory, new FileAttribute[0]);
            cssi.updateWriteDirectory(this.workingDirectory);
            this.clusterLRU.setWriteDir(this.workingDirectory);
            this.fileLRU.setWriteDir(this.workingDirectory);
            this.streamLRU.setWriteDir(this.workingDirectory);
            this.csLRU.setWriteDir(this.workingDirectory);
            this.clusterLRU.resume();
            this.fileLRU.resume();
            this.streamLRU.resume();
            this.csLRU.resume();
            this.lastSnapshot = System.nanoTime();
            return true;
        }
        catch (IllegalAcornStateException e) {
            this.notSafeToMakeSnapshot(e);
            throw e;
        }
        catch (IOException e) {
            IllegalAcornStateException e1 = new IllegalAcornStateException(e);
            this.notSafeToMakeSnapshot(e1);
            throw e1;
        }
    }

    private void refreshHeadState() throws IOException, IllegalAcornStateException {
        this.state.clusters.clear();
        this.state.files.clear();
        this.state.stream.clear();
        this.state.cs.clear();
        this.clusterLRU.persist(this.state.clusters);
        this.fileLRU.persist(this.state.files);
        this.streamLRU.persist(this.state.stream);
        this.csLRU.persist(this.state.cs);
    }

    private void synchronizeWorkingDirectory() throws IOException {
        Files.walk(this.workingDirectory, 1, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(FileIO::uncheckedSyncPath);
    }

    private void persistHeadState() throws IOException {
        this.synchronizeWorkingDirectory();
        this.state.save(this.workingDirectory);
        ++this.mainState.headDir;
    }

    private void acquireAll() throws IllegalAcornStateException {
        this.clusterLRU.acquireMutex();
        this.fileLRU.acquireMutex();
        this.streamLRU.acquireMutex();
        this.csLRU.acquireMutex();
    }

    private void releaseAll() {
        this.csLRU.releaseMutex();
        this.streamLRU.releaseMutex();
        this.fileLRU.releaseMutex();
        this.clusterLRU.releaseMutex();
    }

    boolean rolledback() {
        return this.rollback.get();
    }

    public void load() throws IOException {
        this.mainState = MainState.load(this.dbFolder, () -> this.rollback.set(true));
        this.lastSessionDirectory = this.dbFolder.resolve(Integer.toString(this.mainState.headDir - 1));
        if (this.mainState.isInitial()) {
            this.state = new HeadState();
        } else {
            try {
                this.state = HeadState.load(this.lastSessionDirectory);
            }
            catch (InvalidHeadStateException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Throwable) {
                    try {
                        org.simantics.db.javacore.HeadState oldState = org.simantics.db.javacore.HeadState.load(this.lastSessionDirectory);
                        HeadState newState = new HeadState();
                        newState.clusters = oldState.clusters;
                        newState.cs = oldState.cs;
                        newState.files = oldState.files;
                        newState.stream = oldState.stream;
                        newState.headChangeSetId = oldState.headChangeSetId;
                        newState.reservedIds = oldState.reservedIds;
                        newState.transactionId = oldState.transactionId;
                        this.state = newState;
                    }
                    catch (InvalidHeadStateException e1) {
                        throw new IOException("Could not load HeadState due to corruption", e1);
                    }
                }
                throw new IOException("Could not load HeadState due to corruption", e);
            }
        }
        try {
            int length;
            Path readDir;
            String[] parts;
            this.workingDirectory = this.dbFolder.resolve(Integer.toString(this.mainState.headDir));
            Files.createDirectories(this.workingDirectory, new FileAttribute[0]);
            this.csLRU = new LRU(this, "Change Set", this.workingDirectory);
            this.streamLRU = new LRU(this, "Cluster Stream", this.workingDirectory);
            this.clusterLRU = new ClusterLRU(this, "Cluster", this.workingDirectory);
            this.fileLRU = new LRU(this, "External Value", this.workingDirectory);
            this.acquireAll();
            for (String clusterKey : this.state.clusters) {
                String[] parts1 = clusterKey.split("#");
                String[] parts2 = parts1[0].split("\\.");
                long first = new BigInteger(parts2[0], 16).longValue();
                long second = new BigInteger(parts2[1], 16).longValue();
                ClusterUID uuid = ClusterUID.make((long)first, (long)second);
                Path readDir2 = this.dbFolder.resolve(parts1[1]);
                int offset = Integer.parseInt(parts1[2]);
                int length2 = Integer.parseInt(parts1[3]);
                this.clusterLRU.map(new ClusterInfo(this, this.clusterLRU, readDir2, uuid, offset, length2));
            }
            for (String fileKey : this.state.files) {
                parts = fileKey.split("#");
                readDir = this.dbFolder.resolve(parts[1]);
                int offset = Integer.parseInt(parts[2]);
                length = Integer.parseInt(parts[3]);
                FileInfo info = new FileInfo(this.fileLRU, this.fileCache, readDir, parts[0], offset, length);
                this.fileLRU.map(info);
            }
            for (String fileKey : this.state.stream) {
                parts = fileKey.split("#");
                readDir = this.dbFolder.resolve(parts[1]);
                int offset = Integer.parseInt(parts[2]);
                length = Integer.parseInt(parts[3]);
                ClusterStreamChunk info = new ClusterStreamChunk(this, this.streamLRU, readDir, parts[0], offset, length);
                this.streamLRU.map(info);
            }
            for (String fileKey : this.state.cs) {
                parts = fileKey.split("#");
                readDir = this.dbFolder.resolve(parts[1]);
                Long revisionId = Long.parseLong(parts[0]);
                int offset = Integer.parseInt(parts[2]);
                int length3 = Integer.parseInt(parts[3]);
                ChangeSetInfo info = new ChangeSetInfo(this.csLRU, this.fileCache, readDir, revisionId, offset, length3);
                this.csLRU.map(info);
            }
            this.releaseAll();
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw new IOException(e);
        }
    }

    public <T> T clone(ClusterUID uid, ClusterCreator creator) throws DatabaseException, AcornAccessVerificationException, IllegalAcornStateException, IOException {
        this.clusterLRU.ensureUpdates(uid);
        ClusterInfo info = (ClusterInfo)this.clusterLRU.getWithoutMutex(uid);
        return info.clone(uid, creator);
    }

    public static void startLog(String msg) {
        tasks.put(msg, ThreadLogger.getInstance().begin(msg));
    }

    public static void endLog(String msg) {
        ITask task = tasks.get(msg);
        if (task != null) {
            task.finish();
        }
    }

    public void update(ClusterUID uid, ClusterImpl clu) throws AcornAccessVerificationException, IllegalAcornStateException {
        ClusterInfo info = (ClusterInfo)this.clusterLRU.getWithoutMutex(uid);
        info.acquireMutex();
        try {
            info.update(clu);
        }
        finally {
            info.releaseMutex();
        }
    }

    public long getClusterIdOrCreate(ClusterUID clusterUID) {
        return 1L;
    }

    public int getResourceKey(ClusterUID uid, int index) throws AcornAccessVerificationException {
        return this.clusterLRU.getResourceKey(uid, index);
    }

    public int getResourceKeyWitoutMutex(ClusterUID uid, int index) throws IllegalAcornStateException {
        return this.clusterLRU.getResourceKeyWithoutMutex(uid, index);
    }

    public Database.Session.ClusterIds getClusterIds() throws IllegalAcornStateException {
        this.clusterLRU.acquireMutex();
        try {
            Collection infos = this.clusterLRU.values();
            final int status = infos.size();
            final long[] firsts = new long[status];
            final long[] seconds = new long[status];
            int index = 0;
            for (ClusterInfo info : infos) {
                firsts[index] = 0L;
                seconds[index] = ((ClusterUID)info.getKey()).second;
                ++index;
            }
            Database.Session.ClusterIds clusterIds = new Database.Session.ClusterIds(){

                public int getStatus() {
                    return status;
                }

                public long[] getFirst() {
                    return firsts;
                }

                public long[] getSecond() {
                    return seconds;
                }
            };
            return clusterIds;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.clusterLRU.releaseMutex();
        }
    }

    public void addIntoCurrentChangeSet(String ccs) throws IllegalAcornStateException {
        this.csLRU.acquireMutex();
        try {
            try {
                this.currentChanges.add(ccs);
            }
            catch (Throwable t) {
                throw new IllegalAcornStateException(t);
            }
        }
        finally {
            this.csLRU.releaseMutex();
        }
    }

    public void commitChangeSet(long changeSetId, byte[] data) throws IllegalAcornStateException {
        this.csLRU.acquireMutex();
        try {
            try {
                ArrayList<String> csids = new ArrayList<String>(this.currentChanges);
                this.currentChanges = new ArrayList();
                new ChangeSetInfo(this.csLRU, this.fileCache, changeSetId, data, csids);
            }
            catch (Throwable t) {
                throw new IllegalAcornStateException(t);
            }
        }
        finally {
            this.csLRU.releaseMutex();
        }
    }

    public byte[] getMetadata(long changeSetId) throws AcornAccessVerificationException, IllegalAcornStateException {
        ChangeSetInfo info = this.csLRU.getWithoutMutex(changeSetId);
        if (info == null) {
            return null;
        }
        info.acquireMutex();
        try {
            byte[] byArray = info.getMetadataBytes();
            return byArray;
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            info.releaseMutex();
        }
    }

    public byte[] getResourceFile(byte[] clusterUID, int resourceIndex) throws AcornAccessVerificationException, IllegalAcornStateException {
        ClusterUID uid = ClusterUID.make((byte[])clusterUID, (int)0);
        String key = String.valueOf(uid.toString()) + "_" + resourceIndex;
        FileInfo info = this.fileLRU.getWithoutMutex(key);
        if (info == null) {
            return null;
        }
        info.acquireMutex();
        try {
            byte[] byArray = info.getResourceFile();
            return byArray;
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            info.releaseMutex();
        }
    }

    public Database.Session.ResourceSegment getResourceSegment(byte[] clusterUID, int resourceIndex, long segmentOffset, short segmentSize) throws AcornAccessVerificationException, IllegalAcornStateException {
        ClusterUID uid = ClusterUID.make((byte[])clusterUID, (int)0);
        String key = String.valueOf(uid.toString()) + "_" + resourceIndex;
        FileInfo info = this.fileLRU.getWithoutMutex(key);
        if (info == null) {
            return null;
        }
        info.acquireMutex();
        try {
            Database.Session.ResourceSegment resourceSegment = info.getResourceSegment(clusterUID, resourceIndex, segmentOffset, segmentSize);
            return resourceSegment;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            info.releaseMutex();
        }
    }

    public void modiFileEx(ClusterUID uid, int resourceKey, long offset, long size, byte[] bytes, long pos, ClusterSupport support) throws IllegalAcornStateException {
        try {
            String key = String.valueOf(uid.toString()) + "_" + ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
            FileInfo info = null;
            this.fileLRU.acquireMutex();
            try {
                try {
                    info = this.fileLRU.get(key);
                    if (info == null) {
                        info = new FileInfo(this.fileLRU, this.fileCache, key, (int)(offset + size));
                    }
                }
                catch (Throwable t) {
                    throw new IllegalAcornStateException(t);
                }
            }
            finally {
                this.fileLRU.releaseMutex();
            }
            info.acquireMutex();
            try {
                try {
                    info.updateData(bytes, offset, pos, size);
                }
                catch (Throwable t) {
                    throw new IllegalAcornStateException(t);
                }
            }
            finally {
                info.releaseMutex();
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.clusterLRU.shutdown();
        this.fileLRU.shutdown();
        this.streamLRU.shutdown();
        this.csLRU.shutdown();
    }

    public void notSafeToMakeSnapshot(IllegalAcornStateException t) {
        this.safeToMakeSnapshot.compareAndSet(true, false);
        this.cause = t;
    }

    public long getTailChangeSetId() {
        return this.state.tailChangeSetId;
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }
}

