/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.ui;

import java.net.URL;
import javax.inject.Named;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.simantics.db.Resource;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.debug.browser.internal.DebugBrowserServer;
import org.simantics.debug.browser.ui.Activator;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class LaunchDebugBrowser {
    private static int browserCounter = 0;

    @CanExecute
    public boolean canExecute() {
        return Platform.inDevelopmentMode();
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell activeShell, @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") ISelection selection) {
        try {
            DebugBrowserServer server = org.simantics.debug.browser.internal.Activator.getDefault().startDebugServer();
            URL url = server.getURL();
            Resource input = (Resource)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class, (boolean)true);
            URL inputUrl = input != null ? new URL(String.valueOf(url.toExternalForm()) + "/" + input.getResourceId()) : url;
            IWorkbenchBrowserSupport bs = PlatformUI.getWorkbench().getBrowserSupport();
            if (bs.isInternalWebBrowserAvailable()) {
                IWebBrowser browser = bs.createBrowser(38, "graph.debug.browser." + browserCounter++, "Database Debug Browser", url.toString());
                browser.openURL(inputUrl);
            } else {
                bs.getExternalBrowser().openURL(inputUrl);
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.browser.ui", "Failed to open external browser.", (Throwable)e));
            ErrorDialog.openError((Shell)activeShell, (String)"Failed to Open External Browser", (String)"Failed to open debug browser in the default external web browser. See exception for details.", (IStatus)new Status(4, "org.simantics.debug.browser.ui", "", (Throwable)e));
        }
    }
}

