/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.translation;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRelationAst;

public class RelationRepository {
    THashMap<String, ArrayList<DRelationAst>> relations = new THashMap();
    THashMap<String, ArrayList<DAnnotationAst>> annotations = new THashMap();

    public String add(DRelationAst relation) throws NotPatternException {
        String name = relation.lhs.getPatternHead().name;
        ArrayList<DRelationAst> vs = (ArrayList<DRelationAst>)this.relations.get((Object)name);
        if (vs == null) {
            vs = new ArrayList<DRelationAst>(2);
            this.relations.put((Object)name, vs);
        }
        vs.add(relation);
        return name;
    }

    public void addDefinitions(String name, ArrayList<DRelationAst> relationList) {
        ArrayList<DRelationAst> vs = (ArrayList<DRelationAst>)this.relations.get((Object)name);
        if (vs == null) {
            vs = new ArrayList<DRelationAst>(relationList.size());
            this.relations.put((Object)name, vs);
        }
        vs.addAll(relationList);
    }

    public void addAnnotation(String name, DAnnotationAst annotation) {
        ArrayList<DAnnotationAst> as = (ArrayList<DAnnotationAst>)this.annotations.get((Object)name);
        if (as == null) {
            as = new ArrayList<DAnnotationAst>(2);
            this.annotations.put((Object)name, as);
        }
        as.add(annotation);
    }

    public void addAnnotations(String name, ArrayList<DAnnotationAst> annotationList) {
        ArrayList<DAnnotationAst> as = (ArrayList<DAnnotationAst>)this.annotations.get((Object)name);
        if (as == null) {
            as = new ArrayList<DAnnotationAst>(annotationList.size());
            this.annotations.put((Object)name, as);
        }
        as.addAll(annotationList);
    }

    public Collection<String> getRelationNames() {
        return this.relations.keySet();
    }

    public ArrayList<DRelationAst> getDefinition(String name) {
        return (ArrayList)this.relations.get((Object)name);
    }

    public ArrayList<DAnnotationAst> getAnnotations(String name) {
        return (ArrayList)this.annotations.get((Object)name);
    }

    public void addFrom(RelationRepository repo, String oldName, String newName) {
        this.addDefinitions(newName, repo.getDefinition(oldName));
        ArrayList<DAnnotationAst> as = repo.getAnnotations(oldName);
        if (as != null) {
            this.addAnnotations(newName, as);
        }
    }
}

