package org.simantics.scl.commands;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;

/**
 * Command object represents a UI-operation that makes changes to the database. 
 * 
 * @author Hannu Niemist&ouml;
 */
public interface Command {
    /**
     * Checks that parameter values satisfy conditions needed for execution of the command.
     * It is not necessary to give all the parameters that are given to commit-method. In that
     * case this function makes just a partial checking of the given parameters.
     */
    boolean check(RequestProcessor processor, Resource model, Object ... parameters) throws DatabaseException;
    
    /**
     * Tries to execute the command.
     */
    Object execute(RequestProcessor processor, Resource model, Object ... parameters) throws DatabaseException;
    
    /**
     * Tries to execute the command asynchronously.
     */
    void asyncExecute(RequestProcessor processor, Resource model, Object[] parameters,
            Procedure<Object> procedure);
}
