package org.simantics.layer0;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class DatabaseManagementResource {
    
    public final Resource Bundles;
    public final Resource GraphBundle;
    public final Resource HasFile;
    public final Resource HasFile_Inverse;
    public final Resource HasHashCode;
    public final Resource HasHashCode_Inverse;
    public final Resource HasInstallInfo;
    public final Resource HasInstallInfo_Inverse;
    public final Resource HasVersionedId;
    public final Resource HasVersionedId_Inverse;
    public final Resource InstallInfo;
    public final Resource InstalledGraphBundles;
    public final Resource OSGiSymbolicName;
    public final Resource OSGiVersion;
    public final Resource VersionedId;
        
    public static class URIs {
        public static final String Bundles = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/Bundles";
        public static final String GraphBundle = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/GraphBundle";
        public static final String HasFile = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/HasFile";
        public static final String HasFile_Inverse = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/HasFile/Inverse";
        public static final String HasHashCode = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/HasHashCode";
        public static final String HasHashCode_Inverse = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/HasHashCode/Inverse";
        public static final String HasInstallInfo = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/HasInstallInfo";
        public static final String HasInstallInfo_Inverse = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/HasInstallInfo/Inverse";
        public static final String HasVersionedId = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/HasVersionedId";
        public static final String HasVersionedId_Inverse = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/HasVersionedId/Inverse";
        public static final String InstallInfo = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/InstallInfo";
        public static final String InstalledGraphBundles = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/InstalledGraphBundles";
        public static final String OSGiSymbolicName = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/OSGiSymbolicName";
        public static final String OSGiVersion = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/OSGiVersion";
        public static final String VersionedId = "http://www.simantics.org/Layer0-1.1/DatabaseManagement/VersionedId";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public DatabaseManagementResource(ReadGraph graph) {
        Bundles = getResourceOrNull(graph, URIs.Bundles);
        GraphBundle = getResourceOrNull(graph, URIs.GraphBundle);
        HasFile = getResourceOrNull(graph, URIs.HasFile);
        HasFile_Inverse = getResourceOrNull(graph, URIs.HasFile_Inverse);
        HasHashCode = getResourceOrNull(graph, URIs.HasHashCode);
        HasHashCode_Inverse = getResourceOrNull(graph, URIs.HasHashCode_Inverse);
        HasInstallInfo = getResourceOrNull(graph, URIs.HasInstallInfo);
        HasInstallInfo_Inverse = getResourceOrNull(graph, URIs.HasInstallInfo_Inverse);
        HasVersionedId = getResourceOrNull(graph, URIs.HasVersionedId);
        HasVersionedId_Inverse = getResourceOrNull(graph, URIs.HasVersionedId_Inverse);
        InstallInfo = getResourceOrNull(graph, URIs.InstallInfo);
        InstalledGraphBundles = getResourceOrNull(graph, URIs.InstalledGraphBundles);
        OSGiSymbolicName = getResourceOrNull(graph, URIs.OSGiSymbolicName);
        OSGiVersion = getResourceOrNull(graph, URIs.OSGiVersion);
        VersionedId = getResourceOrNull(graph, URIs.VersionedId);
    }
    
    public static DatabaseManagementResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        DatabaseManagementResource ret = session.peekService(DatabaseManagementResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new DatabaseManagementResource(qc.getIndependentGraph(graph));
            session.registerService(DatabaseManagementResource.class, ret);
        }
        return ret;
    }
    
    public static DatabaseManagementResource getInstance(RequestProcessor session) throws DatabaseException {
        DatabaseManagementResource ret = session.peekService(DatabaseManagementResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<DatabaseManagementResource>() {
                public DatabaseManagementResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new DatabaseManagementResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(DatabaseManagementResource.class, ret);
        }
        return ret;
    }
    
}

