package org.simantics.fastlz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

import org.simantics.compressions.CompressionCodec;
import org.simantics.compressions.Compressions;

public class FastLZCodec implements CompressionCodec {

    public FastLZCodec() {
    }
    
    @Override
    public int compressBound(int inputSize) {
        return FastLZ.compressBound(inputSize);
    }

    @Override
    public int compressBuffer(ByteBuffer input, int inputOffset,
            int length, ByteBuffer output, int outputOffset) {
        return FastLZ.compressBuffer(input, inputOffset, length, output, outputOffset);
    }

    @Override
    public int decompressBuffer(ByteBuffer input, int inputOffset,
            int length, ByteBuffer output, int outputOffset, int maxout) {
        return FastLZ.decompressBuffer(input, inputOffset, length, output, outputOffset, maxout);
    }

    @Override
    public InputStream read(File file) throws FileNotFoundException {
        return FastLZ.read(file);
    }

    @Override
    public OutputStream write(File file) throws FileNotFoundException {
        return FastLZ.write(file);
    }

    @Override
    public int compress(byte[] uncompressedData, int i, int length,
            byte[] compressedData, int j) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public byte[] decompress(byte[] compressedData, int i,
            int uncompressedLength) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public String getId() {
        return Compressions.FASTLZ;
    }

}
