/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.fastlz;

/**
 * @author Tuukka Lehtonen
 */
public enum ARCHType {
    PPC, PPC_64, SPARC, X86, X86_64, UNKNOWN;

    public static ARCHType calculate() {
        String osArch = System.getProperty("os.arch");
        assert osArch != null;
        osArch = osArch.toLowerCase();
        if (osArch.equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86"))
            return X86;
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64"))
            return X86_64;
        if (osArch.equals("ppc"))
            return PPC;
        if (osArch.startsWith("ppc"))
            return PPC_64;
        if (osArch.startsWith("sparc"))
            return SPARC;
        return UNKNOWN;
    }
}