/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.ui.internal;

import org.eclipse.core.runtime.Platform;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.debug.ui.graph.GraphicalDebuggerEditor;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;


public class GraphicalDebuggerEditorAdapter extends AbstractResourceEditorAdapter {

    public GraphicalDebuggerEditorAdapter() {
        super(Messages.GraphicalDebuggerEditorAdapter_GraphicalDebugger, SimanticsUI.getImageDescriptor("icons/etool16/bug.png")); //$NON-NLS-1$
    }

    @Override
    public boolean canHandle(ReadGraph g, Resource r) {
        return Platform.inDevelopmentMode();
    }

    @Override
    public void openEditor(Resource r) throws Exception {
        openEditorWithId(GraphicalDebuggerEditor.EDITOR_ID, new ResourceEditorInput(GraphicalDebuggerEditor.EDITOR_ID,r));
    }
    
    @Override
    public String getEditorId() {
    	return GraphicalDebuggerEditor.EDITOR_ID;
    }
    
}
