/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.unitParser.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class UnitResult {
    private ArrayList<String> dividers = new ArrayList();
    private ArrayList<String> dividents = new ArrayList();
    private StringBuilder fullUnit = new StringBuilder();
    private UnitType unitType;
    private final Equivalent[] EQUIVALENTS = new Equivalent[]{new Equivalent("$", "$s", "dollar", "dollars", "usd"), new Equivalent("\u20ac", "\u20acs", "eur", "euro", "euros", "e", "ecu"), new Equivalent("\ufffd", "\ufffds", "pound", "pounds", "gbp"), new Equivalent("unit", "units"), new Equivalent("person", "people", "persons"), new Equivalent("second", "seconds", "sec", "s"), new Equivalent("minute", "minutes", "min"), new Equivalent("hour", "hours", "h", "hr"), new Equivalent("day", "days", "d"), new Equivalent("month", "months", "mon", "mth", "mo", "mos"), new Equivalent("year", "years", "a", "y", "yr")};
    private boolean allowEquivalents;

    public UnitResult(boolean allowEquivalents) {
        this.allowEquivalents = allowEquivalents;
        this.setUnitType(UnitType.NORMAL);
    }

    public void appendResult(UnitResult result) {
        this.addAllDividents(result.getDividents());
        this.addAllDividers(result.getDividers());
        this.append(result.getFullUnit());
        this.setUnitType(result.getUnitType());
    }

    public void addDivider(String divider) {
        this.dividers.add(divider);
        Collections.sort(this.dividers);
    }

    public void addAllDividers(ArrayList<String> dividers) {
        this.dividers.addAll(dividers);
        Collections.sort(this.dividers);
    }

    public void addDivident(String divident) {
        this.dividents.add(divident);
        Collections.sort(this.dividents);
    }

    public void addAllDividents(ArrayList<String> dividents) {
        this.dividents.addAll(dividents);
        Collections.sort(this.dividents);
    }

    public void append(String text) {
        this.fullUnit.append(text);
    }

    public ArrayList<String> getDividers() {
        return this.dividers;
    }

    public ArrayList<String> getDividents() {
        return this.dividents;
    }

    public String getFullUnit() {
        return this.fullUnit.toString();
    }

    public String getCleanFullUnit() {
        String s;
        if (this.dividers.size() == 0 && this.dividents.size() == 0) {
            return "";
        }
        if (this.dividers.size() > 0 && this.dividents.size() == 0) {
            this.dividents.add("1");
        }
        ArrayList<String> copyDividers1 = new ArrayList<String>(this.dividers);
        ArrayList<String> copyDividents1 = new ArrayList<String>(this.dividents);
        this.reduceUnitLists(this.dividents, copyDividents1, copyDividers1, this.allowEquivalents);
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = copyDividents1.iterator();
        while (iterator.hasNext()) {
            s = iterator.next();
            sb.append(s);
            if (!iterator.hasNext()) continue;
            sb.append("*");
        }
        if (copyDividers1.size() > 0) {
            sb.append("/");
            if (copyDividers1.size() > 1) {
                sb.append("(");
            }
            iterator = copyDividers1.iterator();
            while (iterator.hasNext()) {
                s = iterator.next();
                sb.append(s);
                if (!iterator.hasNext()) continue;
                sb.append("*");
            }
            if (copyDividers1.size() > 1) {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        String b;
        String a;
        int i;
        if (!(obj instanceof UnitResult)) {
            return false;
        }
        UnitResult other = (UnitResult)obj;
        if (this.getUnitType() == UnitType.ANY || other.getUnitType() == UnitType.ANY) {
            return true;
        }
        if (this.getUnitType() != other.getUnitType()) {
            return true;
        }
        ArrayList<String> copyDividers1 = new ArrayList<String>(this.dividers);
        ArrayList<String> copyDividents1 = new ArrayList<String>(this.dividents);
        this.reduceUnitLists(this.dividents, copyDividents1, copyDividers1, this.allowEquivalents);
        ArrayList<String> copyDividers2 = new ArrayList<String>(other.dividers);
        ArrayList<String> copyDividents2 = new ArrayList<String>(other.dividents);
        this.reduceUnitLists(other.dividents, copyDividents2, copyDividers2, this.allowEquivalents);
        if (copyDividents1.size() != copyDividents2.size()) {
            return false;
        }
        if (copyDividers1.size() != copyDividers2.size()) {
            return false;
        }
        if (this.allowEquivalents) {
            i = 0;
            while (i < copyDividents1.size()) {
                copyDividents1.set(i, this.getDefaultForm(copyDividents1.get(i)));
                copyDividents2.set(i, this.getDefaultForm(copyDividents2.get(i)));
                Collections.sort(copyDividents1);
                Collections.sort(copyDividents2);
                ++i;
            }
            i = 0;
            while (i < copyDividers1.size()) {
                copyDividers1.set(i, this.getDefaultForm(copyDividers1.get(i)));
                copyDividers2.set(i, this.getDefaultForm(copyDividers2.get(i)));
                Collections.sort(copyDividers1);
                Collections.sort(copyDividers2);
                ++i;
            }
        }
        i = 0;
        while (i < copyDividents1.size()) {
            a = copyDividents1.get(i);
            if (!a.equals(b = copyDividents2.get(i))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < copyDividers1.size()) {
            a = copyDividers1.get(i);
            if (!a.equals(b = copyDividers2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getDefaultForm(String unit) {
        Equivalent[] equivalentArray = this.EQUIVALENTS;
        int n = this.EQUIVALENTS.length;
        int n2 = 0;
        while (n2 < n) {
            Equivalent e = equivalentArray[n2];
            if (e.contains(unit)) {
                return e.getDefault();
            }
            ++n2;
        }
        return unit;
    }

    public void reduceUnitLists(ArrayList<String> originalDividents, ArrayList<String> copyDividents, ArrayList<String> copyDividers, boolean allowEquivalents) {
        if (allowEquivalents) {
            int i = 0;
            while (i < originalDividents.size()) {
                copyDividents.set(i, this.getDefaultForm(copyDividents.get(i)));
                ++i;
            }
            i = 0;
            while (i < copyDividers.size()) {
                copyDividers.set(i, this.getDefaultForm(copyDividers.get(i)));
                ++i;
            }
        }
        for (String s : originalDividents) {
            String equiv;
            String string = equiv = allowEquivalents ? this.getDefaultForm(s) : s;
            if (!copyDividers.contains(equiv)) continue;
            copyDividers.remove(equiv);
            copyDividents.remove(equiv);
        }
        if (copyDividents.isEmpty()) {
            copyDividents.add("1");
        }
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public void setUnitType(UnitType unitType) {
        this.unitType = unitType;
    }

    public String toString() {
        return this.getCleanFullUnit();
    }

    private class Equivalent {
        public ArrayList<String> forms = new ArrayList();

        Equivalent(String ... forms) {
            String[] stringArray = forms;
            int n = forms.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                this.forms.add(f);
                ++n2;
            }
        }

        public boolean contains(String form) {
            for (String f : this.forms) {
                if (!f.equalsIgnoreCase(form)) continue;
                return true;
            }
            return false;
        }

        public String getDefault() {
            if (this.forms.size() > 0) {
                return this.forms.get(0);
            }
            return null;
        }
    }

    public static enum UnitType {
        NORMAL,
        ANY,
        DMNL,
        OPERATOR,
        SCALAR;

    }
}

