/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.solver;

import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynExperimentFactory;
import org.simantics.sysdyn.manager.SysdynPlaybackExperiment;
import org.simantics.sysdyn.solver.SolverSettings;

public class Solvers {
    private Map<SolverSettings.SolverType, SysdynExperimentFactory> basicExperimentFactories = new HashMap<SolverSettings.SolverType, SysdynExperimentFactory>();
    private Map<SolverSettings.SolverType, SysdynExperimentFactory> gameExperimentFactories = new HashMap<SolverSettings.SolverType, SysdynExperimentFactory>();
    private Map<SolverSettings.SolverType, SysdynExperimentFactory> sensitivityExperimentFactories = new HashMap<SolverSettings.SolverType, SysdynExperimentFactory>();
    private static Solvers INSTANCE;
    private static final Map<String, SysdynExperiment> experiments;

    static {
        experiments = new HashMap<String, SysdynExperiment>();
    }

    private Solvers() {
    }

    public static synchronized Solvers getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Solvers();
        }
        return INSTANCE;
    }

    public static synchronized SysdynExperiment getExperiment(ReadGraph g, SolverSettings.SolverType solver, Resource experiment, Resource modelResource, String identifier) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        if (g.isInstanceOf(experiment, sr.PlaybackExperiment)) {
            return new SysdynPlaybackExperiment(experiment, modelResource, identifier);
        }
        if (g.isInstanceOf(experiment, sr.GameExperiment)) {
            return Solvers.getGameExperiment(solver, experiment, modelResource, identifier);
        }
        if (g.isInstanceOf(experiment, sr.SensitivityAnalysisExperiment)) {
            return Solvers.getSensitivityExperiment(solver, experiment, modelResource, identifier);
        }
        if (g.isInstanceOf(experiment, sr.BasicExperiment)) {
            return Solvers.getBasicExperiment(solver, experiment, modelResource, identifier);
        }
        throw new DatabaseException("Unknown experiment type " + g.getURI(experiment));
    }

    private static synchronized SysdynExperiment getBasicExperiment(SolverSettings.SolverType solver, Resource experiment, Resource model, String identifier) throws DatabaseException {
        SysdynExperiment result = experiments.get(identifier);
        if (result == null) {
            result = Solvers.instantiateBasicExperiment(solver, experiment, model, identifier);
            experiments.put(identifier, result);
        }
        return result;
    }

    private static synchronized SysdynExperiment getGameExperiment(SolverSettings.SolverType solver, Resource experiment, Resource model, String identifier) throws DatabaseException {
        SysdynExperiment result = experiments.get(identifier);
        if (result == null) {
            result = Solvers.instantiateGameExperiment(solver, experiment, model, identifier);
            experiments.put(identifier, result);
        }
        return result;
    }

    private static synchronized SysdynExperiment getSensitivityExperiment(SolverSettings.SolverType solver, Resource experiment, Resource model, String identifier) throws DatabaseException {
        SysdynExperiment result = experiments.get(identifier);
        if (result == null) {
            result = Solvers.instantiateSensitivityExperiment(solver, experiment, model, identifier);
            experiments.put(identifier, result);
        }
        return result;
    }

    private static synchronized SysdynExperiment instantiateBasicExperiment(SolverSettings.SolverType solver, Resource experiment, Resource model, String identifier) throws DatabaseException {
        Solvers s = Solvers.getInstance();
        SysdynExperimentFactory factory = s.basicExperimentFactories.get((Object)solver);
        if (factory == null) {
            throw new DatabaseException("No game experiment factory registered as " + (Object)((Object)solver));
        }
        return factory.create(experiment, model, identifier);
    }

    private static synchronized SysdynExperiment instantiateGameExperiment(SolverSettings.SolverType solver, Resource experiment, Resource model, String identifier) throws DatabaseException {
        Solvers s = Solvers.getInstance();
        SysdynExperimentFactory factory = s.gameExperimentFactories.get((Object)solver);
        if (factory == null) {
            throw new DatabaseException("No game experiment factory registered as " + (Object)((Object)solver));
        }
        return factory.create(experiment, model, identifier);
    }

    private static synchronized SysdynExperiment instantiateSensitivityExperiment(SolverSettings.SolverType solver, Resource experiment, Resource model, String identifier) throws DatabaseException {
        Solvers s = Solvers.getInstance();
        SysdynExperimentFactory factory = s.sensitivityExperimentFactories.get((Object)solver);
        if (factory == null) {
            throw new DatabaseException("No game experiment factory registered as " + (Object)((Object)solver));
        }
        return factory.create(experiment, model, identifier);
    }

    public static synchronized void registerBasicExperimentFactory(SolverSettings.SolverType solver, SysdynExperimentFactory factory) {
        Solvers s = Solvers.getInstance();
        s.basicExperimentFactories.put(solver, factory);
    }

    public static synchronized void unregisterBasicExperimentFactory(SolverSettings.SolverType solver) {
        Solvers s = Solvers.getInstance();
        s.basicExperimentFactories.remove((Object)solver);
    }

    public static synchronized void registerGameExperimentFactory(SolverSettings.SolverType solver, SysdynExperimentFactory factory) {
        Solvers s = Solvers.getInstance();
        s.gameExperimentFactories.put(solver, factory);
    }

    public static synchronized void unregisterGameExperimentFactory(SolverSettings.SolverType solver) {
        Solvers s = Solvers.getInstance();
        s.gameExperimentFactories.remove((Object)solver);
    }

    public static synchronized void registerSensitivityExperimentFactory(SolverSettings.SolverType solver, SysdynExperimentFactory factory) {
        Solvers s = Solvers.getInstance();
        s.sensitivityExperimentFactories.put(solver, factory);
    }

    public static synchronized void unregisterSensitivityExperimentFactory(SolverSettings.SolverType solver) {
        Solvers s = Solvers.getInstance();
        s.sensitivityExperimentFactories.remove((Object)solver);
    }
}

