/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.solver;

import fi.semantum.sysdyn.solver.Solver;
import java.io.File;
import java.util.HashMap;
import org.simantics.modelica.ModelicaManager;
import org.simantics.modelica.SimulationLocation;
import org.simantics.sysdyn.manager.FunctionUtils;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.modelica.ModelicaWriter;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.sysdyn.solver.InternalSolverResult;
import org.simantics.sysdyn.solver.SolverSettings;
import org.simantics.utils.FileUtils;

public class InternalSolver
implements ISolver {
    public static final boolean PRINT_CODE = false;
    private SysdynExperiment experiment;
    private SysdynModel model;
    public Solver solver;
    private double start;
    private double stop;
    private double step;
    private double interval;
    private final boolean isGame;
    private SimulationLocation location;
    private HashMap<String, SysdynDataSet> results;

    public InternalSolver(SysdynExperiment experiment, SysdynModel model, boolean isGame) {
        this.experiment = experiment;
        this.model = model;
        this.isGame = isGame;
        this.solver = new Solver();
        this.start = 0.0;
        this.stop = 500.0;
        this.interval = this.step = 0.1;
    }

    @Override
    public void initialize() throws Exception {
        Model representation = this.model.getConfiguration().getModel();
        this.start = representation.getStartTime();
        this.stop = representation.getStopTime();
        this.step = representation.getSimulationStepLength();
        this.interval = representation.getOutputInterval();
        String modelContent = ModelicaWriter.write(this.model.getModules(), this.start, this.stop, this.step, this.isGame, "1.9");
        FunctionUtils.updateFunctionFilesForExperiment(this.experiment);
        this.location = ModelicaManager.createSimulationLocation((File)this.experiment.getExperimentDir(), (String)this.model.getConfiguration().getLabel(), (String)modelContent);
        this.solver.setStep(this.step);
        this.solver.setStart(this.start);
    }

    @Override
    public void buildModel() throws Exception {
        StringBuilder code = new StringBuilder();
        for (String path : FunctionUtils.getLibraryPathsForModelica(this.experiment)) {
            File f = new File(this.location.modelFile.getParentFile(), path);
            code.append(FileUtils.getContents((File)f));
        }
        code.append(FileUtils.getContents((File)this.location.modelFile));
        this.solver.prepare(code.toString());
    }

    @Override
    public void runSolver() throws Exception {
        long startTime = System.nanoTime();
        int count = (int)((this.stop - this.start) / this.interval) + 1;
        int steps = (int)(this.interval / this.step);
        double[] times = new double[count];
        String[] keys = this.solver.keys();
        double[][] values = new double[keys.length][];
        times[0] = this.start;
        double[] valueArray = this.solver.values();
        int i = 0;
        while (i < keys.length) {
            values[i] = new double[count];
            values[i][0] = valueArray[i];
            ++i;
        }
        int interval = 1;
        while (interval < count) {
            int i2 = 0;
            while (i2 < steps) {
                this.solver.step();
                ++i2;
            }
            times[interval] = times[interval - 1] + (double)steps * this.step;
            valueArray = this.solver.values();
            i2 = 0;
            while (i2 < keys.length) {
                values[i2][interval] = valueArray[i2];
                ++i2;
            }
            ++interval;
        }
        this.results = new HashMap();
        i = 0;
        while (i < keys.length) {
            String name = keys[i];
            double[] arr = values[i];
            this.results.put(name, new SysdynDataSet(name, null, times, arr));
            ++i;
        }
        long endTime = System.nanoTime();
        System.err.println("ran simulation in " + 1.0E-6 * (double)(endTime - startTime) + "ms.");
    }

    @Override
    public void updateResults() throws Exception {
        InternalSolverResult result = new InternalSolverResult(null, this.results);
        this.experiment.setCurrentResult(result);
        this.experiment.resultsChanged();
    }

    @Override
    public SolverSettings.SolverType getType() {
        return SolverSettings.SolverType.INTERNAL;
    }

    @Override
    public double[] getSubscribedResults(double[] array) {
        return this.solver.values();
    }

    @Override
    public double getTime() {
        return this.solver.getTime();
    }

    @Override
    public void prepareToStep() throws Exception {
        this.solver.aboutToRun();
    }

    @Override
    public void setRealValue(String name, double value) throws Exception {
        this.solver.setValue(name, value);
    }

    @Override
    public void simulateStep() throws Exception {
        this.solver.step();
    }

    @Override
    public void setStepLength(double length) throws Exception {
        this.solver.setStep(length);
    }
}

