/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.utils;

import java.io.StringReader;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.utils.FormatUtils;

public class RepresentationUtils {
    public static boolean isGameExperimentActive() {
        IProject project = Simantics.peekProject();
        if (project == null) {
            return false;
        }
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment active = manager.getActiveExperiment();
        return active instanceof SysdynGameExperimentBase;
    }

    public static boolean isPartOfGameExperiment(Variable variable) {
        Configuration conf = variable.getParentConfiguration();
        if (conf != null) {
            return conf.isGameConfiguration();
        }
        return false;
    }

    public static boolean isPartOfGameExperiment(Module module) {
        Configuration conf = module.getParentConfiguration();
        if (conf != null) {
            return conf.isGameConfiguration();
        }
        return false;
    }

    public static Variable getFirstGameVariableReference(Variable variable, String expression) {
        Variable result;
        block4: {
            String equation = FormatUtils.formatExpressionForModelica(variable, expression, false);
            ExpressionParser parser = new ExpressionParser(new StringReader(equation));
            result = null;
            try {
                parser.expr();
                if (parser.getReferences().isEmpty()) break block4;
                Set<String> references = parser.getReferences().keySet();
                for (String reference : references) {
                    result = RepresentationUtils.getGameVariableReference(variable, variable.getParentConfiguration(), reference);
                    if (result == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    private static Variable getGameVariableReference(Variable variable, Configuration configuration, String reference) {
        String r = reference.split("\\.")[0];
        for (IElement element : configuration.getElements()) {
            IndependentVariable v;
            if (element instanceof Module) {
                Module m = (Module)element;
                if (!r.equals(m.getName())) continue;
                if (!reference.contains(".")) {
                    return null;
                }
                Configuration moduleConfiguration = m.getType().getConfiguration();
                return RepresentationUtils.getGameVariableReference(variable, moduleConfiguration, reference.substring(reference.indexOf(".") + 1));
            }
            if (!(element instanceof IndependentVariable) || element instanceof Stock || !r.equals((v = (IndependentVariable)element).getName())) continue;
            if (v.getName().equals(variable.getName())) {
                return null;
            }
            if (Variability.PARAMETER.equals((Object)Variability.getVariability(v, false, null))) {
                return v;
            }
            return null;
        }
        return null;
    }

    public static Variable getVariable(Configuration configuration, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        String[] components = name.replace('_', ' ').split("\\.");
        Configuration conf = configuration;
        int i = 0;
        while (i < components.length - 1) {
            Module module = RepresentationUtils.findModule(conf, components[i]);
            if (module == null) {
                return null;
            }
            conf = module.getType().getConfiguration();
            ++i;
        }
        return RepresentationUtils.findVariable(conf, components[components.length - 1]);
    }

    private static Module findModule(Configuration conf, String name) {
        for (IElement element : conf.getElements()) {
            Module module;
            if (!(element instanceof Module) || !(module = (Module)element).getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    private static Variable findVariable(Configuration conf, String name) {
        for (IElement element : conf.getElements()) {
            Variable variable;
            if (!(element instanceof Variable) || !(variable = (Variable)element).getName().equals(name)) continue;
            return variable;
        }
        return null;
    }
}

