/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.nodemanager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.sysdyn.Functions;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.manager.SysdynPlaybackExperiment;
import org.simantics.sysdyn.nodemanager.ChildVariableNode;
import org.simantics.sysdyn.nodemanager.NamedPropertyVariableNode;
import org.simantics.sysdyn.nodemanager.SysdynValueData;
import org.simantics.sysdyn.nodemanager.SysdynVariableNode;
import org.simantics.sysdyn.representation.IElement;

public class SysdynEngine
implements StandardNodeManagerSupport<SysdynVariableNode> {
    private final SysdynExperiment solver;
    private final String runName;
    private boolean sync;

    public SysdynEngine(ReadGraph graph, SysdynExperiment solver, Resource run) throws DatabaseException {
        this.solver = solver;
        this.runName = NameUtils.getSafeName((ReadGraph)graph, (Resource)run);
        assert (solver != null);
    }

    public void setSync(boolean value) {
        this.sync = value;
    }

    public boolean getSync() {
        return this.sync;
    }

    public SysdynExperiment getSolver() {
        return this.solver;
    }

    public String getRunName() {
        return this.runName;
    }

    public Object getEngineValue(SysdynVariableNode node) throws NodeManagerException {
        String name = node.getName();
        if (Functions.TIME.equals(name)) {
            if (this.solver != null && this.solver instanceof SysdynPlaybackExperiment) {
                return ((SysdynPlaybackExperiment)this.solver).getTime();
            }
            if (this.solver != null && this.solver instanceof SysdynGameExperimentBase) {
                return ((SysdynGameExperimentBase)this.solver).getSolver().getTime();
            }
            return Double.NaN;
        }
        if (Functions.VALUE_DATA.equals(name)) {
            return new SysdynValueData(this.solver, node);
        }
        return null;
    }

    public Binding getEngineBinding(SysdynVariableNode node) throws NodeManagerException {
        String name = node.getName();
        if (Functions.VALUE_DATA.equals(name)) {
            return SysdynValueData.BINDING;
        }
        if (Functions.TIME.equals(name)) {
            return Bindings.DOUBLE;
        }
        return Bindings.DOUBLE;
    }

    public void setEngineValue(SysdynVariableNode node, Object value) throws NodeManagerException {
    }

    public String getName(SysdynVariableNode node) {
        return node.getName();
    }

    public Map<String, SysdynVariableNode> getChildren(SysdynVariableNode node) {
        if (Variables.Role.PROPERTY.equals((Object)node.getRole())) {
            return Collections.emptyMap();
        }
        Collection<IElement> children = this.solver.getChildren(node.getRVI());
        if (children.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, SysdynVariableNode> result = new HashMap<String, SysdynVariableNode>();
        for (IElement child : children) {
            result.put(child.getName(), new ChildVariableNode(node, child));
        }
        return result;
    }

    public Map<String, SysdynVariableNode> getProperties(SysdynVariableNode node) {
        if (Variables.Role.PROPERTY.equals((Object)node.getRole())) {
            return Collections.emptyMap();
        }
        HashMap<String, SysdynVariableNode> result = new HashMap<String, SysdynVariableNode>();
        if (!node.getName().isEmpty()) {
            result.put(Functions.VALUE_DATA, new NamedPropertyVariableNode(node, Functions.VALUE_DATA));
        } else {
            result.put(Functions.TIME, new NamedPropertyVariableNode(node, Functions.TIME));
        }
        return result;
    }
}

