/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.nodemanager;

import org.simantics.db.layer0.variable.Variables;
import org.simantics.sysdyn.nodemanager.SysdynVariableNode;
import org.simantics.sysdyn.representation.IElement;

public class ChildVariableNode
extends SysdynVariableNode {
    protected IElement element;

    public ChildVariableNode(SysdynVariableNode parent, IElement element) {
        super(parent);
        this.element = element;
    }

    public <T> T getElement() {
        return (T)this.element;
    }

    @Override
    public Variables.Role getRole() {
        return Variables.Role.CHILD;
    }

    @Override
    public String getName() {
        if (this.element == null) {
            return "";
        }
        return this.element.getName();
    }

    @Override
    public String getRVI() {
        if (this.parent == null) {
            return this.getName();
        }
        String parentRVI = this.parent.getRVI();
        return String.valueOf(parentRVI) + "/" + this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChildVariableNode other = (ChildVariableNode)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }
}

